/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.utils.ConstructorContextUtil;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TypesCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TypesCompletionStrategy.class);
    private final Provider<ApexIndex> apexIndexProvider;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;
    private final ConstructorContextUtil constructorUtil;

    @Inject
    public TypesCompletionStrategy(Provider<ApexIndex> apexIndexProvider, ApexDocumentService documentService, CompletionActivationFactory factory, ConstructorContextUtil constructorUtil) {
        this.apexIndexProvider = apexIndexProvider;
        this.documentService = documentService;
        this.factory = factory;
        this.constructorUtil = constructorUtil;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            try {
                if (!this.constructorUtil.isConstructorContext((Document)doc, params.getPosition())) {
                    PrefixCompletionActivationStrategy strategy = this.factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
                    strategy.getCompletionPrefix().ifPresent(prefix -> {
                        items.addAll(this.getSystemTypeCompletionItems((String)prefix));
                        items.addAll(this.getSystemTypeCompletionItems("System." + prefix));
                    });
                }
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing completion", (Throwable)ble);
            }
        });
        return CompletionItemTransformer.dedup(items);
    }

    private List<CompletionItem> getSystemTypeCompletionItems(String fullPrefix) {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            List<ApexTypeId> typeIds = apexIndex.fuzzyFindTypeIds(fullPrefix).stream().filter(id -> !StringUtils.startsWithIgnoreCase((CharSequence)id.getApexName().getString(), (CharSequence)"System.") || StringUtils.startsWithIgnoreCase((CharSequence)fullPrefix, (CharSequence)"System.")).collect(Collectors.toList());
            List<CompletionItem> list = CompletionItemTransformer.transform(fullPrefix, typeIds).stream().filter(item -> !StringUtils.contains((CharSequence)item.getLabel(), (CharSequence)".")).collect(Collectors.toList());
            return list;
        }
    }
}

