/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.PgTypes
{
	[Serializable]
	public struct PgPath
	{
		#region Fields

		private PgPoint[]	points;
		private bool		isClosedPath;

		#endregion

		#region Properties

		public PgPoint[] Points
		{
			get { return points; }
		}

		public bool IsClosedPath
		{
			get { return isClosedPath; }
		}

		#endregion

		#region Constructors

		public PgPath(bool isClosedPath, PgPoint[] points)
		{
			this.isClosedPath	= isClosedPath;
			this.points			= (PgPoint[])points.Clone();
		}

		#endregion

		#region Operators

		public static bool operator ==(PgPath left, PgPath right)
		{
			bool equals = false;

			if (left.Points.Length == right.Points.Length)
			{
				equals = true;
				for (int i = 0; i < left.Points.Length; i++)
				{
					if (left.Points[i] != right.Points[i])
					{
						equals = false;
						break;
					}
				}
			}

			return equals;
		}

		public static bool operator !=(PgPath left, PgPath right)
		{
			bool notequals = true;

			if (left.Points.Length == right.Points.Length)
			{
				notequals = false;
				for (int i = 0; i < left.Points.Length; i++)
				{
					if (left.Points[i] != right.Points[i])
					{
						notequals = true;
						break;
					}
				}
			}

			return notequals;
		}

		#endregion

		#region Overriden Methods

		public override string ToString()
		{
			System.Text.StringBuilder b = new System.Text.StringBuilder();

			b.Append(this.isClosedPath ? "(" : "[");

			for (int i = 0; i < this.points.Length; i++)
			{
				if (b.Length > 1)
				{
					b.Append(",");
				}
				b.Append(this.points[i].ToString());
			}

			b.Append(this.isClosedPath ? ")" : "]");

			return b.ToString();
		}

		public override int GetHashCode()
		{
			return base.GetHashCode();
		}

		public override bool Equals(object obj)
		{
			if (obj is PgPath)
			{
				return ((PgPath)obj) == this;
			}
			else
			{
				return false;
			}
		}

		#endregion

		#region Static Methods

		public static PgPath Parse(string s)
		{
			throw new NotSupportedException();
		}

		#endregion
	}
}
