/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;

public class ElementNSImpl
extends ElementImpl {
    static final long serialVersionUID = -9142310625494392642L;
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String namespaceURI;
    protected String localName;

    protected ElementNSImpl() {
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2) throws DOMException {
        super(coreDocumentImpl, string2);
        this.setName(string, string2);
    }

    private void setName(String string, String string2) throws DOMException {
        int n = string2.indexOf(58);
        String string3 = this.namespaceURI = string != null && string.length() == 0 ? null : string;
        if (n < 0) {
            Object var4_4 = null;
            this.localName = string2;
        } else {
            String string4 = string2.substring(0, n);
            this.localName = string2.substring(n + 1);
            if (this.ownerDocument.errorChecking) {
                if (this.namespaceURI == null || this.localName.length() == 0 || this.localName.indexOf(58) >= 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
                if (string4.equals("xml") ? !string.equals(xmlURI) : n == 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
            }
        }
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2, String string3) throws DOMException {
        super(coreDocumentImpl, string2);
        this.localName = string3;
        this.namespaceURI = string;
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl, string);
    }

    void rename(String string, String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = string2;
        this.setName(string, string2);
        this.reconcileDefaultAttributes();
    }

    protected void setValues(CoreDocumentImpl coreDocumentImpl, String string, String string2, String string3) {
        this.firstChild = null;
        this.previousSibling = null;
        this.nextSibling = null;
        this.fNodeListCache = null;
        this.attributes = null;
        this.flags = 0;
        this.setOwnerDocument(coreDocumentImpl);
        this.needsSyncData(true);
        this.name = string2;
        this.localName = string3;
        this.namespaceURI = string;
    }

    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        int n;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return (n = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, n);
    }

    public void setPrefix(String string) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (!CoreDocumentImpl.isXMLName(string)) {
                throw new DOMException(5, "DOM002 Illegal character");
            }
            if (this.namespaceURI == null || string.indexOf(58) >= 0) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
            if (string != null && string.equals("xml") && !this.namespaceURI.equals(xmlURI)) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
        }
        this.name = string + ":" + this.localName;
    }

    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }

    public String getBaseURI() {
        Attr attr;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes != null && (attr = (Attr)this.attributes.getNamedItemNS(xmlURI, "base")) != null) {
            return attr.getNodeValue();
        }
        return this.ownerNode.getBaseURI();
    }
}

