/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.IOException;
import org.pdfbox.ttf.HeaderTable;
import org.pdfbox.ttf.MaximumProfileTable;
import org.pdfbox.ttf.TTFDataStream;
import org.pdfbox.ttf.TTFTable;
import org.pdfbox.ttf.TrueTypeFont;

public class IndexToLocationTable
extends TTFTable {
    private static final short SHORT_OFFSETS = 0;
    private static final short LONG_OFFSETS = 1;
    public static final String TAG = "loca";
    private long[] offsets;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        HeaderTable head = ttf.getHeader();
        MaximumProfileTable maxp = ttf.getMaximumProfile();
        int numGlyphs = maxp.getNumGlyphs();
        this.offsets = new long[numGlyphs + 1];
        for (int i = 0; i < numGlyphs + 1; ++i) {
            if (head.getIndexToLocFormat() == 0) {
                this.offsets[i] = data.readUnsignedShort() * 2;
                continue;
            }
            if (head.getIndexToLocFormat() == 1) {
                this.offsets[i] = data.readUnsignedInt();
                continue;
            }
            throw new IOException("Error:TTF.loca unknown offset format.");
        }
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public void setOffsets(long[] offsetsValue) {
        this.offsets = offsetsValue;
    }
}

