/************************************************************************
*																		*
* 			Pandora Products - Jim Schimpf Std Support Stuff			*
*					Copyright 1998 Jim Schimpf							*
*  																		*
*						MAC FILE TOKENIZER								*
*																		*
*		Module:CTokFile.h												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		12-Feb-88	J.Schimpf	Initial Version						*
*	0.2		 3-Aug-91	J.Schimpf	Add seek,tell & rewind				*
*	0.3		 1-Jan-92	J.Schimpf	Add file name to MFILE				*
*	0.4		 8-Aug-95	J.Schimpf	Convert to object					*
*	0.5		22-Sep-95	J.Schimpf	Convert to file tokenizer			*
*	0.6		22-Jan-97	J.Schimpf	Add initializer						*
*																		*
*	DESCRIPTION:													    *
*		Converts file to a stream of tokens								*
*		TOKEN := [<WS chars>]<Contigious characters = TOKEN>[<WS>]		*
*				 Maximum # characters in token in MAX_TOK				*
*		Characters in a line following <COMMENT_CHAR> are ignored to EOL*
*		NOTE: Files are treated as lines and TOKENS cannot be extend	*
*		over line breaks												*
*																		*
*																		*
************************************************************************/

#include "CBufFile.h"

#pragma once

/*  USEFUL STUFF */

#define MAX_TOK_BUF		256		// Maximum internal buffer for lines
#define MAX_TOK			256		// Maximum token size
//#define COMMENT_CHAR	'*'		// Comment character
#define QUOTE_CHAR		'"'		// Quote character

// Token grabber return
#define TOK_BUF_MT		-3		// TOKEN input buffer MT
#define TOK_BUF_EOL		-2		// End of line found
#define TOK_BUF_EOF		-1		// End of FILE found
#define TOK_BUF_TOK		0		// Token returned
#define TOK_QUOTE_TOK	1		// Quoted token (literal)									
			
/************************************************************
*		OBJECT DEFS
************************************************************/

class CTokFile : public CBufFile {

	public:
	
		CTokFile(void);						// Constructor to init stuff
		void init(void);					// Initialize for run
		
		int get_token( char *val );			// Get a token
		void unget_token(void);				// Unget last token received
		
		int line_count( void );				// # Lines read by tokenizer

	private:
	    char buf[MAX_TOK_BUF];				// Input buffer
	    int psn;					// Position in input buffer
		char token[MAX_TOK_BUF];	// Current token
		bool unget_flag;			// TRUE if unget called
		int lines;					// # Lines in file
			
};
