/************************************************************************
*																		*
* 			Pandora Products - Jim Schimpf Std Support Stuff			*
*					Copyright 1998 Jim Schimpf							*
*  																		*
*						MAC FILE Lexical Analyzer						*
*																		*
*		Module:CLexFile.cp												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		 12-Feb-88	J.Schimpf	Initial Version						*
*	0.2		29-Jul-91	J.Schimpf	Add rewind function					*
*	0.3		 3-Aug-91	J.Schimpf	Add ftell,fseek & rewind			*
*	0.4		31-Dec-92	J.Schimpf	Convert for THINK C 5.0				*
*	0.5		 1-Jan-93	J.Schimpf	Don't return file name in input		*
*	0.6		16-Feb-93	J.Schimpf	Add fprintf							*
*	0.7		16-Feb-93	J.Schimpf	Put in correction for FTELL			*
*	0.8		12-Mar-93	J.Schimpf	Accept \n as line terminator in 	*
*									FGETS								*
*	0.9		 8-Aug-95	J.Schimpf	Convert to object					*
*	1.0		10-Aug-95	J.Schimpf	Allow user control of type,signature*
*									file type lists						*
*	1.1		22-Sep-95	J.Schimpf	Convert to file tokenizer			*
*	1.2		28-Dec-95	J.Schimpf	Add QUOTE mark for tokens			*
*	1.3		18-Aug-96	J.Schimpf	Remove inherited					*
*	1.4		22-Jan-97	J.Schimpf	Fix exit of " loop that would		*
*									leave an extra char in token		*
*	1.5		27-Sep-98	J.Schimpf	Remove COMMENT rtn and return EOL	*
*	1.6		27-Sep-98	J.Schimpf	Convert to Lexical analyzer			*
*																		*
*	DESCRIPTION:													    *
*		Converts file to a stream of tokens								*
*		TOKEN := [<WS chars>]<Contigious characters = TOKEN>[<WS>]		*
*				or <QUOTE><charcters with embedded spaces><QUOTE>		*
*				 Maximum # characters in token in MAX_TOK				*
*		Characters in a line following <COMMENT_CHAR> are ignored to EOL*
*		NOTE: Files are treated as lines and TOKENS cannot be extend	*
*		over line breaks												*
*																		*
*	Methods:															*
*																		*
*	Name					Description 								*
*-----------------------------------------------------------------------*
*																		*
************************************************************************/

/******* INCLUDE FILES ******/

#include "CLexFile.h"
#include <ctype.h>

/***********************************************************************
*
*  init(int cnt,LEX_TOKEN *tlist)	- Initializer for token run
*
*	INPUT:	cnt		- # Lexical tokens to be found
*			tlist	- List of tokens
*
*	OUTPUT:	NONE
*			Initialize all internal variables to default states
*
***********************************************************************/

void CLexFile::init(int cnt,LEX_TOKEN *tlist)
{
	int i;

	numTokens = cnt;
	
	// Copy the tokens to the internal list

	for( i=0; i<numTokens; i++ )
	{
		list[i].lex_value = tlist[i].lex_value;
		strcpy(list[i].token,tlist[i].token);
	}

	// Init the Token layer

	CTokFile::init();
}
	

/***********************************************************************
*		TOKEN FILE I/O OPERATIONS
************************************************************************/
/***********************************************************************
*
* bool get_token( char *val )	- Get the next token from the
*												  file
*
*	INPUT:	val	- Returned token, NOTE: Must have TOK_MAX+1 spaces
*
*	OUTPUT:	true if token found, false if EOF or no token
*			NOTE: TOKEN returned in UC only
*
***********************************************************************/

int CLexFile::get_token( char *token )
{
	int type;
	int i;
	
	// (1) Ok get the current token and update last token

	type = CTokFile::get_token( token );

	// (2) If type well known then return that

	switch( type ) {

		case TOK_BUF_EOL:	token[0] = '\0';
							return( LEX_BUF_EOL );

		case TOK_BUF_EOF:	token[0] = '\0';
							return( LEX_BUF_EOF );
							
		case TOK_QUOTE_TOK:	return( LEX_QUOT_TOK );	// REF:JS09272003
	
	}

	// (3) Falling here => regular token so try to match with
	// internal list

	for( i=0; i<numTokens; i++ )
	{
		if( strcmp(list[i].token,token) == 0 )
		{
			return( list[i].lex_value );
		}
	}

	// (4) Not found, just return that it was a token
	
	return( LEX_BUF_TOK );
}


/****************** INTERNAL PRIVATE OPERATIONS ************************/
