/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.boot.cli.command.init.InitializrService;
import org.springframework.boot.cli.command.init.ProjectGenerationRequest;
import org.springframework.boot.cli.command.init.ProjectGenerationResponse;
import org.springframework.boot.cli.command.init.ReportableException;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

class ProjectGenerator {
    private static final String ZIP_MIME_TYPE = "application/zip";
    private final InitializrService initializrService;

    ProjectGenerator(InitializrService initializrService) {
        this.initializrService = initializrService;
    }

    public void generateProject(ProjectGenerationRequest request, boolean force) throws IOException {
        String fileName;
        ProjectGenerationResponse response = this.initializrService.generate(request);
        String string = fileName = request.getOutput() != null ? request.getOutput() : response.getFileName();
        if (this.shouldExtract(request, response)) {
            if (this.isZipArchive(response)) {
                this.extractProject(response, request.getOutput(), force);
                return;
            }
            Log.info("Could not extract '" + response.getContentType() + "'");
            fileName = response.getFileName();
        }
        if (fileName == null) {
            throw new ReportableException("Could not save the project, the server did not set a preferred file name and no location was set. Specify the output location for the project.");
        }
        this.writeProject(response, fileName, force);
    }

    private boolean shouldExtract(ProjectGenerationRequest request, ProjectGenerationResponse response) {
        if (request.isExtract()) {
            return true;
        }
        return this.isZipArchive(response) && request.getOutput() != null && !request.getOutput().contains(".");
    }

    private boolean isZipArchive(ProjectGenerationResponse entity) {
        if (entity.getContentType() != null) {
            try {
                return ZIP_MIME_TYPE.equals(entity.getContentType().getMimeType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractProject(ProjectGenerationResponse entity, String output, boolean overwrite) throws IOException {
        File outputFolder;
        File file = outputFolder = output != null ? new File(output) : new File(System.getProperty("user.dir"));
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        }
        ZipInputStream zipStream = new ZipInputStream(new ByteArrayInputStream(entity.getContent()));
        try {
            this.extractFromStream(zipStream, overwrite, outputFolder);
            this.fixExecutableFlag(outputFolder, "mvnw");
            this.fixExecutableFlag(outputFolder, "gradlew");
            Log.info("Project extracted to '" + outputFolder.getAbsolutePath() + "'");
        }
        finally {
            zipStream.close();
        }
    }

    private void extractFromStream(ZipInputStream zipStream, boolean overwrite, File outputFolder) throws IOException {
        ZipEntry entry = zipStream.getNextEntry();
        while (entry != null) {
            File file = new File(outputFolder, entry.getName());
            if (file.exists() && !overwrite) {
                throw new ReportableException((file.isDirectory() ? "Directory" : "File") + " '" + file.getName() + "' already exists. Use --force if you want to overwrite or specify an alternate location.");
            }
            if (!entry.isDirectory()) {
                FileCopyUtils.copy(StreamUtils.nonClosing(zipStream), (OutputStream)new FileOutputStream(file));
            } else {
                file.mkdir();
            }
            zipStream.closeEntry();
            entry = zipStream.getNextEntry();
        }
    }

    private void writeProject(ProjectGenerationResponse entity, String output, boolean overwrite) throws IOException {
        File outputFile = new File(output);
        if (outputFile.exists()) {
            if (!overwrite) {
                throw new ReportableException("File '" + outputFile.getName() + "' already exists. Use --force if you want to overwrite or specify an alternate location.");
            }
            if (!outputFile.delete()) {
                throw new ReportableException("Failed to delete existing file " + outputFile.getPath());
            }
        }
        FileCopyUtils.copy(entity.getContent(), outputFile);
        Log.info("Content saved to '" + output + "'");
    }

    private void fixExecutableFlag(File dir, String fileName) {
        File f = new File(dir, fileName);
        if (f.exists()) {
            f.setExecutable(true, false);
        }
    }
}

