/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.profile.commands;

import groovy.lang.MetaClass;
import groovy.transform.Generated;
import io.micronaut.cli.MicronautCli;
import io.micronaut.cli.console.logging.MicronautConsole;
import io.micronaut.cli.profile.ExecutionContext;
import io.micronaut.cli.profile.commands.AbstractCreateCommand;
import io.micronaut.cli.profile.commands.SupportedBuildTool;
import io.micronaut.cli.profile.commands.SupportedLanguage;
import io.micronaut.cli.profile.commands.SupportedTestFramework;
import io.micronaut.cli.util.VersionInfo;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashSet;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import picocli.CommandLine;

@CommandLine.Command(name="create-function", description={"Creates a serverless function application"})
public class CreateFunctionCommand
extends AbstractCreateCommand {
    public static final String NAME = "create-function";
    @CommandLine.Parameters(arity="0..1", paramLabel="NAME", description={"The name of the function to create."})
    private String functionName;
    @CommandLine.Option(paramLabel="PROVIDER", names={"-r", "--provider"}, description={"Which cloud provider to use. Possible values: ${DEFAULT-VALUE}."})
    protected String provider;
    @CommandLine.Option(paramLabel="LANG", names={"-l", "--lang"}, description={"Which language to use. Possible values: ${COMPLETION-CANDIDATES}."})
    private SupportedLanguage lang;
    @CommandLine.Option(paramLabel="TEST", names={"-t", "--test"}, description={"Which test framework to use. Possible values: ${COMPLETION-CANDIDATES}."})
    private SupportedTestFramework testFramework;
    @CommandLine.Option(paramLabel="BUILD-TOOL", names={"-b", "--build"}, description={"Which build tool to configure. Possible values: ${COMPLETION-CANDIDATES}."})
    private SupportedBuildTool build;
    protected static final String DEFAULT_PROFILE_NAME = "function-aws";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public CreateFunctionCommand() {
        MetaClass metaClass;
        SupportedBuildTool supportedBuildTool;
        SupportedLanguage supportedLanguage;
        String string;
        this.provider = string = "aws";
        this.lang = supportedLanguage = SupportedLanguage.java;
        this.build = supportedBuildTool = SupportedBuildTool.gradle;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void messageOnComplete(MicronautConsole console, AbstractCreateCommand.CreateServiceCommandObject command, File targetDir) {
        console.addStatus(ShortTypeHandling.castToString(new GStringImpl(new Object[]{Paths.get(targetDir.getPath(), new String[0]).toAbsolutePath().normalize()}, new String[]{"Function created at ", ""})));
    }

    @Override
    public boolean handle(ExecutionContext executionContext) {
        String functionProfile = this.evaluateProfileName();
        String langFeature = this.evaluateLangFeature(functionProfile);
        String testFeature = this.evaluateTestFeature();
        this.checkInvalidSelections(executionContext, langFeature, testFeature);
        HashSet<String> selectedFeatures = new HashSet<String>();
        DefaultGroovyMethods.addAll(selectedFeatures, new Object[]{langFeature, testFeature});
        DefaultGroovyMethods.addAll(selectedFeatures, this.getFeatures());
        AbstractCreateCommand.CreateServiceCommandObject createServiceCommandObject = new AbstractCreateCommand.CreateServiceCommandObject();
        String string = this.functionName;
        createServiceCommandObject.setAppName(string);
        File file = executionContext.getBaseDir();
        createServiceCommandObject.setBaseDir(file);
        String string2 = this.lang.name();
        createServiceCommandObject.setLang(string2);
        String string3 = functionProfile;
        createServiceCommandObject.setProfileName(string3);
        String string4 = VersionInfo.getVersion(MicronautCli.class);
        createServiceCommandObject.setMicronautVersion(string4);
        HashSet<String> hashSet = selectedFeatures;
        createServiceCommandObject.setFeatures(hashSet);
        boolean bl = this.getInplace();
        createServiceCommandObject.setInplace(bl);
        String string5 = this.build.toString();
        createServiceCommandObject.setBuild(string5);
        MicronautConsole micronautConsole = executionContext.getConsole();
        createServiceCommandObject.setConsole(micronautConsole);
        AbstractCreateCommand.CreateServiceCommandObject cmd = createServiceCommandObject;
        return super.handle(cmd);
    }

    @Override
    protected String evaluateProfileName() {
        return ShortTypeHandling.castToString(new GStringImpl(new Object[]{this.provider}, new String[]{"function-", ""}));
    }

    protected String evaluateLangFeature(String profile) {
        return ShortTypeHandling.castToString(new GStringImpl(new Object[]{profile, this.lang.name()}, new String[]{"", "-", ""}));
    }

    protected String evaluateTestFeature() {
        return ShortTypeHandling.castToString(new GStringImpl(new Object[]{this.provider, this.resolveTest()}, new String[]{"test-", "-", ""}));
    }

    protected SupportedTestFramework resolveTest() {
        SupportedTestFramework supportedTestFramework = this.testFramework;
        return DefaultTypeTransformation.booleanUnbox(supportedTestFramework) ? supportedTestFramework : CreateFunctionCommand.defaultTestFeature(this.lang);
    }

    protected static SupportedTestFramework defaultTestFeature(SupportedLanguage lang) {
        SupportedLanguage supportedLanguage = lang;
        if (ScriptBytecodeAdapter.isCase(supportedLanguage, SupportedLanguage.java)) {
            return SupportedTestFramework.junit;
        }
        if (ScriptBytecodeAdapter.isCase(supportedLanguage, SupportedLanguage.groovy)) {
            return SupportedTestFramework.spock;
        }
        if (ScriptBytecodeAdapter.isCase(supportedLanguage, SupportedLanguage.kotlin)) {
            return SupportedTestFramework.spek;
        }
        return SupportedTestFramework.junit;
    }

    protected void checkInvalidSelections(ExecutionContext executionContext, String langFeature, String testFeature) {
        if (langFeature.contains("kotlin") && !testFeature.contains("spek")) {
            executionContext.getConsole().warn("Kotlin project may not support your chosen test framework");
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CreateFunctionCommand.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public String getFunctionName() {
        return this.functionName;
    }

    @Generated
    public void setFunctionName(String string) {
        this.functionName = string;
    }

    @Generated
    public SupportedLanguage getLang() {
        return this.lang;
    }

    @Generated
    public void setLang(SupportedLanguage supportedLanguage) {
        this.lang = supportedLanguage;
    }

    @Generated
    public SupportedTestFramework getTestFramework() {
        return this.testFramework;
    }

    @Generated
    public void setTestFramework(SupportedTestFramework supportedTestFramework) {
        this.testFramework = supportedTestFramework;
    }

    @Generated
    public SupportedBuildTool getBuild() {
        return this.build;
    }

    @Generated
    public void setBuild(SupportedBuildTool supportedBuildTool) {
        this.build = supportedBuildTool;
    }
}

