///////////////////////////////////////////////////////////////////////////
// mathex 0.2 (beta) - Copyright (C) 2000-2003, by Sadao Massago         //
// file: inttest.cpp (integration by trapezoidal rule)                   //
// requires: mathex.h, mathex.cpp                                        //
// project web page: http://sourceforge.net/projects/sscilib/            //
// ----------------------------------------------------------------------//
// The mathex library and related files is licenced under the term of    //
// GNU LGPL (Lesser General Public License) version 2.1 or latter        //
// with exceptions that allow for static linking.                        //
// See license.txt for detail.                                           //
// For GNU LGPL, see lesser.txt.                                         //
// For information over GNU or GNU compatible license, visit the site    //
// http://www.gnu.org.                                                   //
///////////////////////////////////////////////////////////////////////////
// Note:
// Bug fixed by Aggod Jozsef <Aggod@freemail.hu> in november of 2000


#include <iostream>
#include <iomanip>

#include <string>

// #define _DEBUG_

#include "mathex.h"

using namespace std;


int main()
{
  double x, I;

  string expr;
  smlib::mathex form;
  
  int m;
  double a, b, h;
  bool status;
  
  cout << "integration (trapsezoidal rule) examples\n";

  // getting the lower limit. will be an expression
  do {
    cout << "Enter the expression of lower limit: ";    
    do {
	   expr.erase();
      getline(cin, expr);
    } while(expr.empty());


    try {
	    form.expression(expr);
		 form.parse();
       a = form.eval();
		 status = true; 
	 }
	 catch(smlib::mathex::error e) {
	   cout << e.what() << endl;
		status = false;
		cout << expr << endl;
		cout << setw(form.stopposition()) << "^" << endl;
    }
	 // catch(exception e) {
	 //  cout << e.what() << endl;
	 //	status = false;
    // }
  } while(!status);

  // getting the upper limit. will be an expression
  do {
    cout << "Enter the expression of upper limit: ";    
    do {
	   expr.erase();
      getline(cin, expr);
    } while(expr.empty());


    try {
	    form.expression(expr);
		 form.parse();
       b = form.eval();
		 status = true; 
	 }
	 catch(smlib::mathex::error e) {
	   cout << e.what() << endl;
		status = false;
		cout << expr << endl;
		cout << setw(form.stopposition()) << "^" << endl;
    }
	 // catch(exception e) {
	 //  cout << e.what() << endl;
	 //	status = false;
    // }
  } while(!status);

  // getting the number of divisions. will be an expression
  do {
    cout << "Enter the expression of number of divisions: ";    
    do {
	   expr.erase();
      getline(cin, expr);
    } while(expr.empty());


    try {
	    form.expression(expr);
		 form.parse();
       m = static_cast<int>(form.eval());
		 if(m <=0) {
		   cout << "number of division must be grather than zero\n";
			status = false;
		 }
		 else
		   status = true; 
	 }
	 catch(smlib::mathex::error e) {
	   cout << e.what() << endl;
		status = false;
		cout << expr << endl;
		cout << setw(form.stopposition()) << "^" << endl;
    }
	 // catch(exception e) {
	 //   cout << e.what() << endl;
	 //	status = false;
    // }
  } while(!status);


   // sharing with internal variables ...
   // table making example
      cout << "function table example\n";
      // expr.delvar();
   // sharing with internal variables ... 
      if(!form.addvar("x", &x)) {
         cout << "Error adding internal variable x as name \"x\"\n";
         return 1;
      }
      do {
      
         cout << "Enter expression of x: ";
      
         do { 
			   expr.erase();
            getline(cin, expr); // getline delete '\n'character?
         } while(expr.empty());
      
         cout << "now parsing the expression " << expr << endl;
         try {
			   form.expression(expr);
            form.parse(); // parse
            status = true; // parse sucessfull
         }
             catch(smlib::mathex::error e) {
               status = false; // parse failure
               cout << e.what() << endl; // erroer message
					// show expression and error position
               cout << expr << endl;
               cout << setw(form.stopposition()) << "^" << endl;
            }
            //  catch(exception e) {
            //    status = false; // parse failure
            //    cout << e.what() << endl; // erroer message
            // }
      } while(!status);


  // calculate the integral
  h = (b-a)/m;
  x = a;
  try {
    I = form.eval();
    //  for(j=0; j<=(m-1); j++) {
    for(int j=0; j < (m-1); j++) {  // Aggod Jozsef <Aggod@freemail.hu> in 2000.11.12.
      x += h;
      I += 2*form.eval();
    }
    x = b;
    I += form.eval();
    I *= ( h * .5 );    // Aggod Jozsef <Aggod@freemail.hu> in 2000.11.12.
	 
    // print the result
    cout << "a = " << a << endl;
    cout << "b = " << b << endl;
    cout << "m = " << m << endl;
    cout << "h = " << h << endl;
	 cout << "expression = " << expr << endl;
    cout << "integral = " << I << endl;
  }
  catch(smlib::mathex::error e) {
    cout << e.what() << endl;
  }
  catch(exception e) {
    cout << e.what() << endl;
  }
  return 0;
} // main

// end of inttest.cpp
