/*
 * Decompiled with CFR 0.152.
 */
package com.leastfixedpoint.json;

import com.leastfixedpoint.json.JSONNull;
import com.leastfixedpoint.json.JSONSerializable;
import com.leastfixedpoint.json.JSONSerializationError;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class JSONWriter {
    protected int indentLevel = 0;
    protected Writer writer;
    protected boolean indentMode;
    protected boolean sortKeys = true;
    protected static final char[] hex = "0123456789ABCDEF".toCharArray();

    public static void writeTo(Writer w, Object value) throws IOException {
        JSONWriter.writeTo(w, value, false);
    }

    public static void writeTo(Writer w, Object value, boolean indenting) throws IOException {
        new JSONWriter(w, indenting).write(value);
    }

    public static String writeToString(Object value) throws JSONSerializationError {
        return JSONWriter.writeToString(value, false);
    }

    public static String writeToString(Object value, boolean indenting) throws JSONSerializationError {
        StringWriter w = new StringWriter();
        try {
            JSONWriter.writeTo(w, value, indenting);
        }
        catch (JSONSerializationError jse) {
            throw jse;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while writing to string buffer", e);
        }
        return w.getBuffer().toString();
    }

    public JSONWriter(Writer writer) {
        this(writer, false);
    }

    public JSONWriter(Writer writer, boolean indenting) {
        this.writer = writer;
        this.indentMode = indenting;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean getIndentMode() {
        return this.indentMode;
    }

    public void setIndentMode(boolean value) {
        this.indentMode = value;
    }

    public boolean getSortKeys() {
        return this.sortKeys;
    }

    public void setSortKeys(boolean value) {
        this.sortKeys = value;
    }

    public void newline() throws IOException {
        if (this.indentMode) {
            this.emit('\n');
            for (int i = 0; i < this.indentLevel; ++i) {
                this.emit(' ');
            }
        }
    }

    public void write(Object object) throws IOException {
        if (object instanceof JSONNull) {
            this.emit("null");
        } else if (object instanceof JSONSerializable) {
            ((JSONSerializable)object).jsonSerialize(this);
        } else if (object instanceof Class) {
            this.string(object);
        } else if (object instanceof Boolean) {
            this.bool((Boolean)object);
        } else if (object instanceof Number) {
            this.number((Number)object);
        } else if (object instanceof String) {
            this.string(object);
        } else if (object instanceof Character) {
            this.string(object);
        } else if (object instanceof Map) {
            this.map((Map)object);
        } else if (object instanceof Iterable) {
            this.iterable((Iterable)object);
        } else if (object != null && object.getClass().isArray()) {
            this.array(object);
        } else {
            throw new JSONSerializationError("Cannot write object in JSON format: " + object);
        }
    }

    protected void number(Number n) throws IOException {
        String s = n.toString();
        if (s.endsWith(".0")) {
            this.emit(s.substring(0, s.length() - 2));
        } else {
            this.emit(s);
        }
    }

    protected void map(Map<?, ?> map) throws IOException {
        this.emit('{');
        this.indentLevel += 2;
        this.newline();
        boolean needComma = false;
        if (this.sortKeys) {
            ArrayList<String> sortedKeys = new ArrayList<String>(map.size());
            for (Object obj : map.keySet()) {
                if (!(obj instanceof String)) {
                    throw new JSONSerializationError("Cannot write non-string JSON map key: " + obj);
                }
                sortedKeys.add((String)obj);
            }
            Collections.sort(sortedKeys);
            for (String string : sortedKeys) {
                if (needComma) {
                    this.emit(',');
                    this.newline();
                }
                needComma = true;
                this.emit('\"');
                this.emit(string);
                this.emit("\":");
                this.write(map.get(string));
            }
        } else {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (needComma) {
                    this.emit(',');
                    this.newline();
                }
                needComma = true;
                this.emit('\"');
                Object obj = entry.getKey();
                if (!(obj instanceof String)) {
                    throw new JSONSerializationError("Cannot write non-string JSON map key: " + obj);
                }
                this.emit((String)obj);
                this.emit("\":");
                this.write(entry.getValue());
            }
        }
        this.indentLevel -= 2;
        this.newline();
        this.emit('}');
    }

    protected void iterable(Iterable<?> it) throws IOException {
        this.emit('[');
        boolean needComma = false;
        for (Object value : it) {
            if (needComma) {
                this.emit(',');
            }
            needComma = true;
            this.write(value);
        }
        this.emit(']');
    }

    protected void array(Object object) throws IOException {
        this.emit('[');
        int length = Array.getLength(object);
        boolean needComma = false;
        for (int i = 0; i < length; ++i) {
            if (needComma) {
                this.emit(',');
            }
            needComma = true;
            this.write(Array.get(object, i));
        }
        this.emit(']');
    }

    protected void bool(boolean b) throws IOException {
        this.emit(b ? "true" : "false");
    }

    protected void string(Object obj) throws IOException {
        this.emit('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.emit("\\\"");
            } else if (c == '\\') {
                this.emit("\\\\");
            } else if (c == '/') {
                this.emit("\\/");
            } else if (c == '\b') {
                this.emit("\\b");
            } else if (c == '\f') {
                this.emit("\\f");
            } else if (c == '\n') {
                this.emit("\\n");
            } else if (c == '\r') {
                this.emit("\\r");
            } else if (c == '\t') {
                this.emit("\\t");
            } else if (Character.isISOControl(c)) {
                this.emitUnicode(c);
            } else {
                this.emit(c);
            }
            c = it.next();
        }
        this.emit('\"');
    }

    protected void emit(Object obj) throws IOException {
        this.writer.write(obj.toString());
    }

    protected void emit(char c) throws IOException {
        this.writer.write(c);
    }

    protected void emitUnicode(char c) throws IOException {
        this.emit("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.emit(hex[digit]);
            n <<= 4;
        }
    }
}

