/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.wire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.kotlin.com.google.inject.AbstractModule;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.ImplementedBy;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.MembersInjector;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.ProvidedBy;
import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Scope;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.DefaultBindingTargetVisitor;
import org.jetbrains.kotlin.com.google.inject.spi.Dependency;
import org.jetbrains.kotlin.com.google.inject.spi.HasDependencies;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionRequest;
import org.jetbrains.kotlin.com.google.inject.spi.LinkedKeyBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderInstanceBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderKeyBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderLookup;
import org.jetbrains.kotlin.com.google.inject.spi.StaticInjectionRequest;
import org.jetbrains.kotlin.com.google.inject.spi.UntargettedBinding;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DeferredProvider;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Guice4;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.TypeArguments;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.ParameterKeys;

final class DependencyAnalyzer
extends DefaultBindingTargetVisitor<Object, Boolean> {
    private static final Set<Class<?>> RESTRICTED_CLASSES = new HashSet<Class>(Arrays.asList(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, Logger.class, MembersInjector.class, Module.class, Provider.class, Scope.class, TypeLiteral.class));
    private final Map<TypeLiteral<?>, Boolean> analyzedTypes = new HashMap();
    private final Set<Key<?>> requiredKeys = new HashSet();

    DependencyAnalyzer() {
        this.requiredKeys.add(ParameterKeys.PROPERTIES);
    }

    public Set<Key<?>> findMissingKeys(Set<Key<?>> localKeys) {
        HashSet missingKeys = new HashSet();
        while (this.requiredKeys.size() > 0) {
            ArrayList candidateKeys = new ArrayList(this.requiredKeys);
            this.requiredKeys.clear();
            for (Key key : candidateKeys) {
                if (localKeys.contains(key) || !missingKeys.add(key)) continue;
                this.analyzeImplicitBindings(key.getTypeLiteral());
            }
        }
        return missingKeys;
    }

    @Override
    public Boolean visit(UntargettedBinding<?> binding) {
        return this.analyzeImplementation(binding.getKey().getTypeLiteral(), true);
    }

    @Override
    public Boolean visit(LinkedKeyBinding<?> binding) {
        Key<?> linkedKey = binding.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return this.analyzeImplementation(linkedKey.getTypeLiteral(), true);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ProviderKeyBinding<?> binding) {
        Key<javax.inject.Provider<?>> providerKey = binding.getProviderKey();
        if (providerKey.getAnnotationType() == null) {
            return this.analyzeImplementation(providerKey.getTypeLiteral(), true);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ProviderInstanceBinding<?> binding) {
        javax.inject.Provider<?> provider = Guice4.getProviderInstance(binding);
        if (provider instanceof DeferredProvider) {
            try {
                Class clazz = ((DeferredProvider)provider).getImplementationClass().load();
                this.analyzeImplementation(TypeLiteral.get(clazz), false);
            }
            catch (TypeNotPresentException typeNotPresentException) {
                // empty catch block
            }
            return Boolean.TRUE;
        }
        return this.analyzeDependencies(binding.getDependencies());
    }

    @Override
    public Boolean visitOther(Binding<?> binding) {
        if (binding instanceof HasDependencies) {
            return this.analyzeDependencies(((HasDependencies)((Object)binding)).getDependencies());
        }
        return Boolean.TRUE;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        this.requireKey(lookup.getKey());
        return Boolean.TRUE;
    }

    public Boolean visit(StaticInjectionRequest request) {
        return this.analyzeInjectionPoints(request.getInjectionPoints());
    }

    @Override
    public Boolean visit(InjectionRequest<?> request) {
        return this.analyzeInjectionPoints(request.getInjectionPoints());
    }

    private void requireKey(Key<?> key) {
        if (!this.requiredKeys.contains(key)) {
            Class<?> clazz = key.getTypeLiteral().getRawType();
            if (javax.inject.Provider.class == clazz || Provider.class == clazz) {
                this.requireKey(key.ofType(TypeArguments.get(key.getTypeLiteral(), 0)));
            } else if (!RESTRICTED_CLASSES.contains(clazz)) {
                this.requiredKeys.add(key);
            }
        }
    }

    private Boolean analyzeImplementation(TypeLiteral<?> type, boolean reportErrors) {
        Boolean applyBinding = this.analyzedTypes.get(type);
        if (null == applyBinding) {
            applyBinding = Boolean.TRUE;
            if (TypeArguments.isConcrete(type) && !type.toString().startsWith("java")) {
                try {
                    boolean rhs = this.analyzeInjectionPoints(InjectionPoint.forInstanceMethodsAndFields(type));
                    if (!this.analyzeDependencies(InjectionPoint.forConstructorOf(type).getDependencies()) || !rhs) {
                        applyBinding = Boolean.FALSE;
                    }
                }
                catch (RuntimeException e) {
                    if (reportErrors) {
                        Logs.debug("Potential problem: {}", type, e);
                    }
                    applyBinding = Boolean.FALSE;
                }
                catch (LinkageError e) {
                    if (reportErrors) {
                        Logs.debug("Potential problem: {}", type, e);
                    }
                    applyBinding = Boolean.FALSE;
                }
            }
            this.analyzedTypes.put(type, applyBinding);
        }
        return applyBinding;
    }

    private boolean analyzeInjectionPoints(Set<InjectionPoint> points) {
        boolean applyBinding = true;
        for (InjectionPoint p : points) {
            applyBinding &= this.analyzeDependencies(p.getDependencies());
        }
        return applyBinding;
    }

    private boolean analyzeDependencies(Collection<Dependency<?>> dependencies) {
        boolean applyBinding = true;
        for (Dependency<?> d : dependencies) {
            Key<?> key = d.getKey();
            if (key.hasAttributes() && "Assisted".equals(key.getAnnotationType().getSimpleName())) {
                applyBinding = false;
                continue;
            }
            this.requireKey(key);
        }
        return applyBinding;
    }

    private void analyzeImplicitBindings(TypeLiteral<?> type) {
        if (!this.analyzedTypes.containsKey(type)) {
            Class<?> clazz = type.getRawType();
            if (TypeArguments.isConcrete(clazz)) {
                this.analyzeImplementation(type, false);
            } else {
                this.analyzedTypes.put(type, Boolean.TRUE);
                ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
                if (null != implementedBy) {
                    this.requireKey(Key.get(implementedBy.value()));
                } else {
                    ProvidedBy providedBy = clazz.getAnnotation(ProvidedBy.class);
                    if (null != providedBy) {
                        this.requireKey(Key.get(providedBy.value()));
                    }
                }
            }
        }
    }
}

