/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 !2\u00020\u0001:\u0001!B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u0005H\u0002J \u0010\u0012\u001a\u00020\u00072\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0000J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsStableName;", "", "name", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "canBeMangled", "", "isPresentInGeneratedCode", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;ZZ)V", "getName", "()Ljava/lang/String;", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getCanBeMangled", "()Z", "doesJSManglingChangeName", "shouldClashBeCaughtByCommonFrontendCheck", "lhs", "rhs", "isExternalRedeclarable", "clashesWith", "other", "component1", "component2", "component3", "component4", "copy", "equals", "hashCode", "", "toString", "Companion", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsStableName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsStableName.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsStableName\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,127:1\n16#2:128\n*S KotlinDebug\n*F\n+ 1 FirJsStableName.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsStableName\n*L\n101#1:128\n*E\n"})
public final class FirJsStableName {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final FirBasedSymbol<?> symbol;
    private final boolean canBeMangled;
    private final boolean isPresentInGeneratedCode;

    public FirJsStableName(@NotNull String name2, @NotNull FirBasedSymbol<?> symbol, boolean canBeMangled, boolean isPresentInGeneratedCode) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        this.name = name2;
        this.symbol = symbol;
        this.canBeMangled = canBeMangled;
        this.isPresentInGeneratedCode = isPresentInGeneratedCode;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final FirBasedSymbol<?> getSymbol() {
        return this.symbol;
    }

    public final boolean getCanBeMangled() {
        return this.canBeMangled;
    }

    public final boolean isPresentInGeneratedCode() {
        return this.isPresentInGeneratedCode;
    }

    private final boolean doesJSManglingChangeName(FirBasedSymbol<?> $this$doesJSManglingChangeName) {
        FirBasedSymbol<?> firBasedSymbol = $this$doesJSManglingChangeName;
        return firBasedSymbol instanceof FirFunctionSymbol ? FirCallableSymbolKt.isExtension((FirCallableSymbol)$this$doesJSManglingChangeName) || !((Collection)((FirFunctionSymbol)$this$doesJSManglingChangeName).getValueParameterSymbols()).isEmpty() || !((Collection)((FirFunctionSymbol)$this$doesJSManglingChangeName).getTypeParameterSymbols()).isEmpty() : (firBasedSymbol instanceof FirPropertySymbol ? FirCallableSymbolKt.isExtension((FirCallableSymbol)$this$doesJSManglingChangeName) : false);
    }

    private final boolean shouldClashBeCaughtByCommonFrontendCheck(FirBasedSymbol<?> lhs, FirBasedSymbol<?> rhs) {
        return lhs instanceof FirFunctionSymbol && rhs instanceof FirFunctionSymbol || lhs instanceof FirPropertySymbol && rhs instanceof FirPropertySymbol || lhs instanceof FirClassLikeSymbol && rhs instanceof FirClassLikeSymbol;
    }

    private final boolean isExternalRedeclarable() {
        boolean bl;
        if (this.isPresentInGeneratedCode) {
            bl = false;
        } else {
            boolean bl2;
            FirBasedSymbol<?> firBasedSymbol = this.symbol;
            FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
            if (firCallableSymbol != null) {
                FirCallableSymbol $this$isFinal$iv = firCallableSymbol;
                boolean $i$f$isFinal = false;
                bl2 = $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
            } else {
                bl2 = false;
            }
            bl = bl2 ? true : this.symbol instanceof FirClassLikeSymbol;
        }
        return bl;
    }

    public final boolean clashesWith(@NotNull FirJsStableName other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.symbol == other.symbol ? false : (!Intrinsics.areEqual(this.name, other.name) ? false : (!this.isPresentInGeneratedCode && !other.isPresentInGeneratedCode ? false : (this.isExternalRedeclarable() || other.isExternalRedeclarable() ? false : (FirJsHelpersKt.isActual(this.symbol) != FirJsHelpersKt.isActual(other.symbol) ? false : (FirJsHelpersKt.isExpect(this.symbol) != FirJsHelpersKt.isExpect(other.symbol) ? false : (this.canBeMangled && this.doesJSManglingChangeName(this.symbol) ? false : (other.canBeMangled && this.doesJSManglingChangeName(other.symbol) ? false : !this.canBeMangled || !other.canBeMangled || !this.shouldClashBeCaughtByCommonFrontendCheck(this.symbol, other.symbol))))))));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final FirBasedSymbol<?> component2() {
        return this.symbol;
    }

    public final boolean component3() {
        return this.canBeMangled;
    }

    public final boolean component4() {
        return this.isPresentInGeneratedCode;
    }

    @NotNull
    public final FirJsStableName copy(@NotNull String name2, @NotNull FirBasedSymbol<?> symbol, boolean canBeMangled, boolean isPresentInGeneratedCode) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return new FirJsStableName(name2, symbol, canBeMangled, isPresentInGeneratedCode);
    }

    public static /* synthetic */ FirJsStableName copy$default(FirJsStableName firJsStableName, String string2, FirBasedSymbol firBasedSymbol, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = firJsStableName.name;
        }
        if ((n & 2) != 0) {
            firBasedSymbol = firJsStableName.symbol;
        }
        if ((n & 4) != 0) {
            bl = firJsStableName.canBeMangled;
        }
        if ((n & 8) != 0) {
            bl2 = firJsStableName.isPresentInGeneratedCode;
        }
        return firJsStableName.copy(string2, firBasedSymbol, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "FirJsStableName(name=" + this.name + ", symbol=" + this.symbol + ", canBeMangled=" + this.canBeMangled + ", isPresentInGeneratedCode=" + this.isPresentInGeneratedCode + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.symbol.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.canBeMangled);
        result2 = result2 * 31 + Boolean.hashCode(this.isPresentInGeneratedCode);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FirJsStableName)) {
            return false;
        }
        FirJsStableName firJsStableName = (FirJsStableName)other;
        if (!Intrinsics.areEqual(this.name, firJsStableName.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.symbol, firJsStableName.symbol)) {
            return false;
        }
        if (this.canBeMangled != firJsStableName.canBeMangled) {
            return false;
        }
        return this.isPresentInGeneratedCode == firJsStableName.isPresentInGeneratedCode;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsStableName$Companion;", "", "<init>", "()V", "hasPublicName", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "createStableNameOrNull", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsStableName;", "checkers.js"})
    @SourceDebugExtension(value={"SMAP\nFirJsStableName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsStableName.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsStableName$Companion\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,127:1\n62#2:128\n18#2:129\n42#2,3:130\n19#2:133\n*S KotlinDebug\n*F\n+ 1 FirJsStableName.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/FirJsStableName$Companion\n*L\n25#1:128\n29#1:129\n31#1:130,3\n35#1:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasPublicName(FirBasedSymbol<?> symbol, FirSession session2) {
            FirBasedSymbol<?> firBasedSymbol = symbol;
            if (firBasedSymbol instanceof FirClassLikeSymbol) {
                FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)symbol;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getClassId().isLocal()) return false;
                return true;
            }
            if (!(firBasedSymbol instanceof FirCallableSymbol)) return false;
            FirClassLikeSymbol<?> parentClass = FirHelpersKt.getContainingClassSymbol(symbol, session2);
            if (parentClass != null) {
                FirBasedSymbol $this$visibility$iv = (FirCallableSymbol)symbol;
                boolean $i$f$getVisibility = false;
                Visibility $i$f$isLocal = ((FirCallableSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
                if ($i$f$isLocal instanceof Visibilities.Public) {
                    return true;
                }
                if (!($i$f$isLocal instanceof Visibilities.Protected)) return false;
                FirClassLikeSymbol<?> $this$isFinal$iv = parentClass;
                boolean $i$f$isFinal = false;
                if ($this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                    return false;
                }
                boolean bl = false;
                if (bl) return false;
                $this$visibility$iv = parentClass;
                $i$f$getVisibility = false;
                if (!((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility().isPublicAPI()) return false;
                return true;
            }
            if (((FirCallableSymbol)symbol).getCallableId().isLocal()) return false;
            FirCallableSymbol $this$effectiveVisibility$iv = (FirCallableSymbol)symbol;
            boolean $i$f$getEffectiveVisibility = false;
            if (!$this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility().getPublicApi()) return false;
            return true;
        }

        @Nullable
        public final FirJsStableName createStableNameOrNull(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session2) {
            boolean hasStableNameInJavaScript;
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter(session2, "session");
            String jsName = FirJsHelpersKt.getJsName(symbol, session2);
            if (jsName != null) {
                return new FirJsStableName(jsName, symbol, false, FirJsHelpersKt.isPresentInGeneratedCode(symbol, session2));
            }
            FirBasedSymbol<?> firBasedSymbol = symbol;
            if (firBasedSymbol instanceof FirConstructorSymbol) {
                return null;
            }
            if (firBasedSymbol instanceof FirPropertyAccessorSymbol) {
                return null;
            }
            if (firBasedSymbol instanceof FirTypeAliasSymbol) {
                return null;
            }
            boolean bl = FirWebCommonHelpersKt.isEffectivelyExternal(symbol, session2) ? true : (hasStableNameInJavaScript = FirJsHelpersKt.isExportedObject(symbol, session2));
            if (hasStableNameInJavaScript || this.hasPublicName(symbol, session2)) {
                String name2;
                Name name3 = FirDeclarationUtilKt.getMemberDeclarationNameOrNull(symbol);
                String string2 = name2 = name3 != null ? name3.getIdentifierOrNullIfSpecial() : null;
                if (name2 != null) {
                    return new FirJsStableName(name2, symbol, !hasStableNameInJavaScript, FirJsHelpersKt.isPresentInGeneratedCode(symbol, session2));
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

