/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDelegationInExpectClassSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "<init>", "()V", "isApplicable", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkPsi", "", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkLightTree", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDelegationInExpectClassSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDelegationInExpectClassSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDelegationInExpectClassSyntaxChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,55:1\n37#2:56\n803#3,7:57\n*S KotlinDebug\n*F\n+ 1 FirDelegationInExpectClassSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDelegationInExpectClassSyntaxChecker\n*L\n20#1:56\n47#1:57,7\n*E\n"})
public final class FirDelegationInExpectClassSyntaxChecker
extends FirDeclarationSyntaxChecker<FirRegularClass, KtClassOrObject> {
    @NotNull
    public static final FirDelegationInExpectClassSyntaxChecker INSTANCE = new FirDelegationInExpectClassSyntaxChecker();

    private FirDelegationInExpectClassSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirRegularClass element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        FirMemberDeclaration $this$isExpect$iv = element;
        boolean $i$f$isExpect = false;
        return $this$isExpect$iv.getStatus().isExpect();
    }

    @Override
    public void checkPsi(@NotNull FirRegularClass element, @NotNull KtPsiSourceElement source, @NotNull KtClassOrObject psi, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirTypeRef superTypeRef : element.getSuperTypeRefs()) {
            KtDelegatedSuperTypeEntry parent2;
            KtSourceElement superSource;
            if (superTypeRef.getSource() == null) continue;
            PsiElement psiElement = KtSourceElementKt.getPsi(superSource);
            PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
            if ((psiElement2 instanceof KtDelegatedSuperTypeEntry ? (KtDelegatedSuperTypeEntry)psiElement2 : null) == null) continue;
            parent2 = parent2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)new KtRealPsiSourceElement(parent2), FirErrors.INSTANCE.getIMPLEMENTATION_BY_DELEGATION_IN_EXPECT_CLASS(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkLightTree(@NotNull FirRegularClass element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirTypeRef superTypeRef : element.getSuperTypeRefs()) {
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode parent2;
            KtSourceElement superSource;
            if (superTypeRef.getSource() == null || superSource.getTreeStructure().getParent(superSource.getLighterASTNode()) == null || !Intrinsics.areEqual(parent2.getTokenType(), KtNodeTypes.DELEGATED_SUPER_TYPE_ENTRY)) continue;
            LighterASTNode lighterASTNode = parent2;
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv = superSource.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv), FirErrors.INSTANCE.getIMPLEMENTATION_BY_DELEGATION_IN_EXPECT_CLASS(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

