/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ConstructorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaCodeReferenceElementImpl
extends CompositePsiElement
implements PsiAnnotatedJavaCodeReferenceElement,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance(PsiJavaCodeReferenceElementImpl.class);
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private volatile Kind myKindWhenDummy = Kind.CLASS_NAME_KIND;
    private final int myHC = ourHC++;

    public PsiJavaCodeReferenceElementImpl() {
        super(JavaElementType.JAVA_CODE_REFERENCE);
    }

    public final int hashCode() {
        return this.myHC;
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.getReferenceNameNode();
        return refName != null ? refName.getStartOffset() : super.getTextOffset();
    }

    public void setKindWhenDummy(@NotNull Kind kind) {
        if (kind == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(0);
        }
        IElementType type2 = this.getTreeParent().getElementType();
        LOG.assertTrue(PsiJavaCodeReferenceElementImpl.isDummy(type2), type2);
        this.myKindWhenDummy = kind;
    }

    private static boolean isDummy(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(1);
        }
        return type2 == TokenType.DUMMY_HOLDER || type2 == JavaElementType.DUMMY_ELEMENT;
    }

    @NotNull
    public Kind getKindEnum(@NotNull PsiFile containingFile) {
        PsiElement parent2;
        CompositeElement treeParent;
        IElementType i;
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(2);
        }
        if (!containingFile.isValid()) {
            PsiUtilCore.ensureValid(this);
        }
        if (PsiJavaCodeReferenceElementImpl.isDummy(i = (treeParent = this.getTreeParent()).getElementType())) {
            Kind kind = this.myKindWhenDummy;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(3);
            }
            return kind;
        }
        if (i == JavaElementType.TYPE) {
            Kind kind = treeParent.getTreeParent().getPsi() instanceof PsiTypeCodeFragment ? Kind.CLASS_OR_PACKAGE_NAME_KIND : Kind.CLASS_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(4);
            }
            return kind;
        }
        if (i == JavaElementType.EXTENDS_LIST || i == JavaElementType.IMPLEMENTS_LIST || i == JavaElementType.PERMITS_LIST || i == JavaElementType.EXTENDS_BOUND_LIST || i == JavaElementType.THROWS_LIST || i == JavaElementType.THIS_EXPRESSION || i == JavaElementType.SUPER_EXPRESSION || i == JavaDocElementType.DOC_METHOD_OR_FIELD_REF || i == JavaDocElementType.DOC_TAG_VALUE_ELEMENT || i == JavaElementType.REFERENCE_PARAMETER_LIST || i == JavaElementType.ANNOTATION || i == JavaElementType.USES_STATEMENT || i == JavaElementType.PROVIDES_STATEMENT || i == JavaElementType.PROVIDES_WITH_LIST) {
            Kind kind = this.isQualified() ? Kind.CLASS_OR_PACKAGE_NAME_KIND : Kind.CLASS_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(5);
            }
            return kind;
        }
        if (i == JavaElementType.NEW_EXPRESSION) {
            ASTNode qualifier = treeParent.findChildByRole(54);
            Kind kind = qualifier != null ? Kind.CLASS_IN_QUALIFIED_NEW_KIND : Kind.CLASS_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(6);
            }
            return kind;
        }
        if (i == JavaElementType.ANONYMOUS_CLASS) {
            if (treeParent.getChildRole(this) == 78) {
                CompositeElement granny = treeParent.getTreeParent();
                IElementType gType = granny.getElementType();
                LOG.assertTrue(gType == JavaElementType.NEW_EXPRESSION, gType);
                ASTNode qualifier = granny.findChildByRole(54);
                Kind kind = qualifier != null ? Kind.CLASS_IN_QUALIFIED_NEW_KIND : Kind.CLASS_NAME_KIND;
                if (kind == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(7);
                }
                return kind;
            }
            Kind kind = Kind.CLASS_OR_PACKAGE_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(8);
            }
            return kind;
        }
        if (i == JavaElementType.PACKAGE_STATEMENT || i == JavaElementType.EXPORTS_STATEMENT || i == JavaElementType.OPENS_STATEMENT) {
            Kind kind = Kind.PACKAGE_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(9);
            }
            return kind;
        }
        if (i == JavaElementType.IMPORT_STATEMENT && (parent2 = treeParent.getPsi()) instanceof PsiImportStatement) {
            boolean isOnDemand = ((PsiImportStatement)parent2).isOnDemand();
            Kind kind = isOnDemand ? Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : Kind.CLASS_FQ_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(10);
            }
            return kind;
        }
        if (i == JavaElementType.IMPORT_STATIC_STATEMENT) {
            Kind kind = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(11);
            }
            return kind;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            Kind parentKind = ((PsiJavaCodeReferenceElementImpl)treeParent).getKindEnum(containingFile);
            if (parentKind == Kind.CLASS_NAME_KIND) {
                Kind kind = Kind.CLASS_OR_PACKAGE_NAME_KIND;
                if (kind == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(12);
                }
                return kind;
            }
            if (parentKind == Kind.CLASS_FQ_NAME_KIND) {
                Kind kind = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
                if (kind == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(13);
                }
                return kind;
            }
            Kind kind = parentKind;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(14);
            }
            return kind;
        }
        if (i == JavaElementType.CLASS || i == JavaElementType.PARAMETER_LIST || i == TokenType.ERROR_ELEMENT) {
            Kind kind = Kind.CLASS_OR_PACKAGE_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(15);
            }
            return kind;
        }
        if (i == JavaElementType.IMPORT_STATIC_REFERENCE) {
            Kind kind = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(16);
            }
            return kind;
        }
        if (i == JavaDocElementType.DOC_TAG || i == JavaDocElementType.DOC_INLINE_TAG || i == JavaDocElementType.DOC_REFERENCE_HOLDER || i == JavaDocElementType.DOC_TYPE_HOLDER) {
            PsiDocComment docComment = PsiTreeUtil.getParentOfType((PsiElement)this, PsiDocComment.class);
            if (JavaDocUtil.isInsidePackageInfo(docComment)) {
                Kind kind = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
                if (kind == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(17);
                }
                return kind;
            }
            Kind kind = Kind.CLASS_OR_PACKAGE_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(18);
            }
            return kind;
        }
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(i)) {
            PsiJavaCodeReferenceCodeFragment fragment = (PsiJavaCodeReferenceCodeFragment)treeParent.getPsi();
            Kind kind = fragment.isClassesAccepted() ? Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : Kind.PACKAGE_NAME_KIND;
            if (kind == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(19);
            }
            return kind;
        }
        this.diagnoseUnknownParent(treeParent, i);
        Kind kind = Kind.CLASS_NAME_KIND;
        if (kind == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(20);
        }
        return kind;
    }

    private void diagnoseUnknownParent(@NotNull CompositeElement parent2, @NotNull IElementType parentElementType) {
        if (parent2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(21);
        }
        if (parentElementType == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(22);
        }
        String msg = "Java code reference '" + this.getText() + "' has unknown parent: '" + parent2 + "' (" + parent2.getClass() + "); of type: " + parentElementType + "\n";
        while (parent2 != null && parent2.getPsi() instanceof PsiExpression) {
            parent2 = parent2.getTreeParent();
            msg = msg + " Parent: '" + parent2 + "'\n";
        }
        if (parent2 != null) {
            msg = msg + "PSI of the top-level PsiExpression parent:\n" + DebugUtil.treeToString(parent2, true);
        }
        LOG.error(msg);
    }

    private static boolean isCodeFragmentType(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(23);
        }
        return type2 == TokenType.CODE_FRAGMENT || type2 instanceof ICodeFragmentElementType;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(24);
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            ASTNode ref = this.findChildByRole(53);
            assert (ref != null) : this;
            PsiElement lastChild = ref.getPsi().getPrevSibling();
            if (lastChild != null) {
                PsiModifierList modifierList2 = PsiImplUtil.findNeighbourModifierList(this);
                if (modifierList2 != null) {
                    modifierList2.addRange(this.getFirstChild(), lastChild);
                } else {
                    this.getParent().addRangeBefore(this.getFirstChild(), lastChild, this);
                }
                if (ref != this.getFirstChild()) {
                    this.deleteChildRange(this.getFirstChild(), ref.getPsi().getPrevSibling());
                }
            }
        } else if (child.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST) {
            this.replaceChildInternal(child, PsiReferenceExpressionImpl.createEmptyRefParameterList(this.getProject()));
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role), role);
        switch (role) {
            case 53: {
                return TreeUtil.findChildBackward(this, JavaTokenType.IDENTIFIER);
            }
            case 246: {
                TreeElement lastChild = this.getLastChildNode();
                return lastChild.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST ? lastChild : null;
            }
            case 54: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    @Override
    public final int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(25);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        return this.getCanonicalText(false, null, this.getContainingFile());
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated, PsiAnnotation @Nullable [] annotations2) {
        return this.getCanonicalText(annotated, annotations2, this.getContainingFile());
    }

    @NotNull
    private String getCanonicalText(boolean annotated, PsiAnnotation @Nullable [] annotations2, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(26);
        }
        Kind kind = this.getKindEnum(containingFile);
        switch (kind) {
            case CLASS_NAME_KIND: 
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement target;
                JavaResolveResult[] results = PsiImplUtil.multiResolveImpl(containingFile.getProject(), containingFile, this, false, OurGenericsResolver.INSTANCE);
                PsiElement psiElement = target = results.length == 1 ? results[0].getElement() : null;
                if (target instanceof PsiClass) {
                    StringBuilder buffer = new StringBuilder();
                    PsiClass aClass = (PsiClass)target;
                    PsiElement qualifier = this.getQualifier();
                    String prefix = null;
                    if (qualifier instanceof PsiJavaCodeReferenceElementImpl) {
                        prefix = ((PsiJavaCodeReferenceElementImpl)qualifier).getCanonicalText(annotated, annotations2, containingFile);
                        annotations2 = null;
                    } else {
                        String fqn = aClass.getQualifiedName();
                        if (fqn != null) {
                            prefix = StringUtil.getPackageName(fqn);
                        }
                    }
                    if (!StringUtil.isEmpty(prefix)) {
                        buffer.append(prefix);
                        buffer.append('.');
                    }
                    if (annotated) {
                        List<PsiAnnotation> list = annotations2 != null ? Arrays.asList(annotations2) : this.getAnnotations();
                        PsiNameHelper.appendAnnotations(buffer, list, true);
                    }
                    buffer.append(aClass.getName());
                    PsiNameHelper.appendTypeArgs(buffer, this.getTypeParameters(), true, annotated);
                    String string2 = buffer.toString();
                    if (string2 == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(27);
                    }
                    return string2;
                }
                if (target instanceof PsiPackage) {
                    String string3 = ((PsiPackage)target).getQualifiedName();
                    if (string3 == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(28);
                    }
                    return string3;
                }
                LOG.assertTrue(target == null, target);
                return this.getNormalizedText();
            }
            case PACKAGE_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                return this.getNormalizedText();
            }
        }
        throw new IllegalArgumentException("Unexpected kind: " + (Object)((Object)kind));
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public final PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @NotNull
    public static TextRange calcRangeInElement(@NotNull CompositePsiElement refElement) {
        TreeElement nameChild;
        if (refElement == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(29);
        }
        if ((nameChild = (TreeElement)refElement.findChildByRole(53)) == null) {
            TreeElement dot = (TreeElement)refElement.findChildByRole(55);
            if (dot == null) {
                throw new IllegalStateException(refElement.toString());
            }
            TextRange textRange = TextRange.from(dot.getStartOffsetInParent() + dot.getTextLength(), 0);
            if (textRange == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(30);
            }
            return textRange;
        }
        TextRange textRange = TextRange.from(nameChild.getStartOffsetInParent(), nameChild.getTextLength());
        if (textRange == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(31);
        }
        return textRange;
    }

    public static JavaResolveResult @NotNull [] tryClassResult(@NotNull String qualifiedName, @NotNull PsiJavaCodeReferenceElement referenceElement) {
        if (qualifiedName == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(32);
        }
        if (referenceElement == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(33);
        }
        PsiElement qualifier = referenceElement.getQualifier();
        Project project = referenceElement.getProject();
        if (qualifier instanceof PsiJavaCodeReferenceElement) {
            PsiClass referencedClass = ResolveClassUtil.resolveClass((PsiJavaCodeReferenceElement)qualifier, referenceElement.getContainingFile());
            if (referencedClass != null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(34);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            PsiClass aClass = JavaPsiFacade.getInstance(project).findClass(qualifiedName, referenceElement.getResolveScope());
            if (aClass != null) {
                JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, PsiSubstitutor.EMPTY, referenceElement, false)};
                if (javaResolveResultArray == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(35);
                }
                return javaResolveResultArray;
            }
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(36);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(37);
        }
        return javaResolveResult;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
        if (javaResolveResultArray == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(38);
        }
        return javaResolveResultArray;
    }

    @NotNull
    private PsiSubstitutor updateSubstitutor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(39);
        }
        @NotNull PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        PsiType[] parameters = this.getTypeParameters();
        PsiSubstitutor psiSubstitutor = subst = subst.putAll(psiClass, parameters);
        if (psiSubstitutor == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(40);
        }
        return psiSubstitutor;
    }

    private JavaResolveResult @NotNull [] resolve(@NotNull Kind kind, @NotNull PsiFile containingFile) {
        if (kind == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(41);
        }
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(42);
        }
        ProgressManager.checkCanceled();
        switch (kind) {
            case CLASS_FQ_NAME_KIND: {
                PsiClass aClass;
                String text = this.getNormalizedText();
                if (!StringUtil.isEmptyOrSpaces(text) && (aClass = JavaPsiFacade.getInstance(containingFile.getProject()).findClass(text, this.getResolveScope())) != null) {
                    JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, this.updateSubstitutor(aClass), this, false)};
                    if (javaResolveResultArray == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(43);
                    }
                    return javaResolveResultArray;
                }
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(44);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement parent2 = this.getParent();
                if (parent2 instanceof JavaDummyHolder) {
                    parent2 = parent2.getContext();
                }
                if (parent2 instanceof PsiAnonymousClass) {
                    parent2 = parent2.getParent();
                }
                if (!(parent2 instanceof PsiNewExpression)) {
                    if (parent2 instanceof PsiJavaCodeReferenceElement) {
                        if (JavaResolveResult.EMPTY_ARRAY == null) {
                            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(45);
                        }
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    LOG.error("Invalid java reference: " + parent2);
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(46);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiExpression qualifier = ((PsiNewExpression)parent2).getQualifier();
                LOG.assertTrue(qualifier != null);
                PsiType qualifierType = qualifier.getType();
                if (qualifierType == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(47);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!(qualifierType instanceof PsiClassType)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(48);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(qualifierType);
                PsiElement resultElement = result2.getElement();
                if (resultElement == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(49);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(50);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this, containingFile);
                resultElement.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result2.getSubstitutor()), this, this);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(51);
                }
                return javaResolveResultArray;
            }
            case CLASS_NAME_KIND: {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(52);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, this, null);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(53);
                }
                return javaResolveResultArray;
            }
            case PACKAGE_NAME_KIND: {
                String packageName2 = this.getNormalizedText();
                Project project = this.getManager().getProject();
                PsiPackage aPackage = JavaPsiFacade.getInstance(project).findPackage(packageName2);
                if (aPackage != null && aPackage.isValid()) {
                    JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aPackage, PsiSubstitutor.EMPTY, this, false)};
                    if (javaResolveResultArray == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(54);
                    }
                    return javaResolveResultArray;
                }
                if (JavaPsiFacade.getInstance(project).isPartOfPackagePrefix(packageName2)) {
                    if (CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(55);
                    }
                    return CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE;
                }
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(56);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                JavaResolveResult[] result3;
                Kind classKind = kind == Kind.CLASS_OR_PACKAGE_NAME_KIND ? Kind.CLASS_NAME_KIND : Kind.CLASS_FQ_NAME_KIND;
                PsiImportStatement importStatement = PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatement.class);
                if (!(importStatement == null || importStatement.isOnDemand() && this.isQualified())) {
                    result3 = this.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                    if (result3.length == 0) {
                        result3 = this.resolve(classKind, containingFile);
                    }
                } else {
                    result3 = this.resolve(classKind, containingFile);
                    if (result3.length == 1 && !result3[0].isAccessible()) {
                        JavaResolveResult[] packageResult = this.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                        if (packageResult.length != 0) {
                            result3 = packageResult;
                        }
                    } else if (result3.length == 0) {
                        result3 = this.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                    }
                }
                if (result3 == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(57);
                }
                return result3;
            }
        }
        throw new IllegalArgumentException("Unexpected kind: " + (Object)((Object)kind));
    }

    @Override
    public final PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier;
        if (newElementName == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(58);
        }
        if ((oldIdentifier = this.getReferenceNameElement()) == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(59);
        }
        PsiFile containingFile = this.getContainingFile();
        CheckUtil.checkWritable(containingFile);
        if (this.isReferenceTo(element)) {
            PsiJavaCodeReferenceElementImpl psiJavaCodeReferenceElementImpl = this;
            if (psiJavaCodeReferenceElementImpl == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(60);
            }
            return psiJavaCodeReferenceElementImpl;
        }
        Kind kind = this.getKindEnum(containingFile);
        switch (kind) {
            case CLASS_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: {
                if (!(element instanceof PsiClass)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind, element + " is not a PsiClass but " + element.getClass());
                }
                return this.bindToClass((PsiClass)element, containingFile);
            }
            case PACKAGE_NAME_KIND: {
                if (!(element instanceof PsiPackage)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind, "I, " + this + " (" + this.getClass() + ") contained in " + containingFile + " in " + containingFile.getVirtualFile() + " am a package since my treeParent is " + this.getTreeParent() + " of " + this.getTreeParent().getElementType() + ", but " + element + " is not a PsiPackage but " + element.getClass());
                }
                return this.bindToPackage((PsiPackage)element);
            }
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                if (element instanceof PsiClass) {
                    return this.bindToClass((PsiClass)element, containingFile);
                }
                if (element instanceof PsiPackage) {
                    return this.bindToPackage((PsiPackage)element);
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind, element + " is not a PsiClass/PsiPackage but " + element.getClass());
            }
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                if (element instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)element;
                    String name2 = aClass.getName();
                    if (name2 == null) {
                        throw new IncorrectOperationException(aClass.toString());
                    }
                    PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(containingFile.getProject()).getParserFacade();
                    PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(name2, this.getParent());
                    this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
                    PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref;
                    if (psiJavaCodeReferenceElement == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(61);
                    }
                    return psiJavaCodeReferenceElement;
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind, element + " is not a PsiClass but " + element.getClass());
            }
        }
        throw new IllegalArgumentException("Unexpected kind: " + (Object)((Object)kind));
    }

    @NotNull
    private static IncorrectOperationException cannotBindError(@NotNull PsiElement element, @NotNull Kind kind, @NotNull String reason) {
        if (element == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(62);
        }
        if (kind == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(63);
        }
        if (reason == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(64);
        }
        return new IncorrectOperationException("Cannot bind to " + element + " of kind: " + (Object)((Object)kind) + " because " + reason);
    }

    @NotNull
    private PsiElement bindToClass(@NotNull PsiClass aClass, @NotNull PsiFile containingFile) throws IncorrectOperationException {
        PsiReferenceParameterList qRefParameterList;
        PsiElement refQualifier;
        PsiJavaCodeReferenceElement ref;
        PsiElement qualifier;
        if (aClass == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(65);
        }
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(66);
        }
        String qName = aClass.getQualifiedName();
        Project project = containingFile.getProject();
        boolean preserveQualification = JavaFileCodeStyleFacade.forContext(containingFile).useFQClassNames() && this.isFullyQualified(containingFile);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        if (qName == null) {
            qName = aClass.getName();
            assert (qName != null) : aClass;
            PsiClass psiClass = facade.getResolveHelper().resolveReferencedClass(qName, this);
            if (!this.getManager().areElementsEquivalent(psiClass, aClass)) {
                String reason = "reference '" + qName + "' resolved to " + psiClass + " (which is not equivalent to " + aClass + ")";
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(aClass, this.getKindEnum(containingFile), reason);
            }
        } else {
            if (facade.findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
                PsiJavaCodeReferenceElementImpl psiJavaCodeReferenceElementImpl = this;
                if (psiJavaCodeReferenceElementImpl == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(67);
                }
                return psiJavaCodeReferenceElementImpl;
            }
            if (facade.getResolveHelper().resolveReferencedClass(qName, this) == null && facade.getResolveHelper().resolveReferencedClass(StringUtil.getPackageName(qName), this) != null) {
                qName = aClass.getName();
                assert (qName != null) : aClass;
            }
        }
        StringBuilder text = new StringBuilder(qName);
        PsiReferenceParameterList parameterList2 = this.getParameterList();
        if (parameterList2 != null) {
            for (PsiElement cur = this.getReferenceNameElement(); cur != parameterList2; cur = cur.getNextSibling()) {
                assert (cur != null) : this.getText();
                text.append(cur.getText());
            }
        }
        PsiReferenceParameterList parentReferencesList = (qualifier = this.getQualifier()) instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)qualifier).getParameterList() : null;
        try {
            ref = facade.getParserFacade().createReferenceFromText(text.toString(), this.getParent());
        }
        catch (IncorrectOperationException e) {
            throw new IncorrectOperationException(e.getMessage() + " [qname=" + qName + " class=" + aClass + ";" + aClass.getClass().getName() + "]");
        }
        List<PsiAnnotation> annotations2 = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiAnnotation.class);
        if (!annotations2.isEmpty()) {
            ref.addRangeBefore(annotations2.get(0), annotations2.get(annotations2.size() - 1), ref.getReferenceNameElement());
        }
        PsiReferenceParameterList refParameterList = ref.getParameterList();
        if (parameterList2 != null && refParameterList != null) {
            refParameterList.replace(parameterList2);
        }
        if (parentReferencesList != null && (refQualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && (qRefParameterList = ((PsiJavaCodeReferenceElement)refQualifier).getParameterList()) != null) {
            qRefParameterList.replace(parentReferencesList);
        }
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        if (!preserveQualification) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences(ref, 8192);
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref;
        if (psiJavaCodeReferenceElement == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(68);
        }
        return psiJavaCodeReferenceElement;
    }

    @NotNull
    private List<PsiAnnotation> getAnnotations() {
        PsiModifierList modifierList2;
        List<PsiAnnotation> annotations2 = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiAnnotation.class);
        if (!this.isQualified() && (modifierList2 = PsiImplUtil.findNeighbourModifierList(this)) != null) {
            annotations2 = new ArrayList<PsiAnnotation>(annotations2);
            PsiImplUtil.collectTypeUseAnnotations(modifierList2, annotations2);
        }
        List<PsiAnnotation> list = annotations2;
        if (list == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(69);
        }
        return list;
    }

    private boolean isFullyQualified(@NotNull PsiFile containingFile) {
        ASTNode qualifier;
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(70);
        }
        Kind kind = this.getKindEnum(containingFile);
        switch (kind) {
            case CLASS_OR_PACKAGE_NAME_KIND: {
                if (!(this.resolve() instanceof PsiPackage)) break;
                return true;
            }
            case CLASS_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                break;
            }
            case PACKAGE_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unexpected kind: " + (Object)((Object)kind));
            }
        }
        if ((qualifier = this.findChildByRole(54)) == null) {
            return false;
        }
        IElementType qualifierElementType = qualifier.getElementType();
        LOG.assertTrue(qualifierElementType == JavaElementType.JAVA_CODE_REFERENCE, qualifierElementType);
        PsiElement refElement = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).resolve();
        if (refElement instanceof PsiPackage) {
            return true;
        }
        return ((PsiJavaCodeReferenceElementImpl)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).isFullyQualified(containingFile);
    }

    @NotNull
    private PsiElement bindToPackage(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        String qName;
        if (aPackage == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(71);
        }
        if ((qName = aPackage.getQualifiedName()).isEmpty()) {
            throw new IncorrectOperationException("Cannot bind to default package: " + aPackage);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(qName, this.getParent());
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref;
        if (psiJavaCodeReferenceElement == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(72);
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(73);
        }
        PsiFile containingFile = this.getContainingFile();
        return this.isReferenceTo(element, containingFile);
    }

    private boolean isReferenceTo(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(74);
        }
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(75);
        }
        Kind kind = this.getKindEnum(containingFile);
        switch (kind) {
            case CLASS_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                if (element instanceof PsiClass) break;
                return false;
            }
            case CLASS_FQ_NAME_KIND: {
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                String qName = ((PsiClass)element).getQualifiedName();
                return qName != null && qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case PACKAGE_NAME_KIND: {
                if (!(element instanceof PsiPackage)) {
                    return false;
                }
                String qName = ((PsiPackage)element).getQualifiedName();
                return qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case CLASS_OR_PACKAGE_NAME_KIND: {
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                if (element instanceof PsiClass) {
                    PsiElement nameElement = this.getReferenceNameElement();
                    if (nameElement == null) {
                        return false;
                    }
                    String name2 = ((PsiClass)element).getName();
                    if (name2 == null) {
                        return false;
                    }
                    return nameElement.textMatches(name2) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
                }
                return false;
            }
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                String qName;
                if (element instanceof PsiClass && (qName = ((PsiClass)element).getQualifiedName()) != null && qName.equals(this.getCanonicalText(false, null, containingFile))) {
                    return !PsiUtil.isFromDefaultPackage((PsiClass)element) || PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatementBase.class) == null;
                }
                if (element instanceof PsiPackage) {
                    qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                return false;
            }
            default: {
                throw new IllegalArgumentException("Unexpected kind: " + (Object)((Object)kind));
            }
        }
        ASTNode referenceNameElement = this.getReferenceNameNode();
        if (referenceNameElement == null || referenceNameElement.getElementType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        String name3 = ((PsiClass)element).getName();
        return name3 != null && referenceNameElement.getText().equals(name3) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    private String getNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText(this);
        }
        String string2 = whiteSpaceAndComments;
        if (string2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(76);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName(this.getNormalizedText(), false);
        }
        String string2 = cachedQName;
        if (string2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(77);
        }
        return string2;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        Kind kind;
        if (targetClass == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(78);
        }
        if ((kind = this.getKindEnum(this.getContainingFile())) != Kind.CLASS_NAME_KIND && kind != Kind.CLASS_OR_PACKAGE_NAME_KIND && kind != Kind.CLASS_IN_QUALIFIED_NEW_KIND) {
            LOG.error("Wrong kind " + (Object)((Object)kind));
            return;
        }
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public PsiElement getQualifier() {
        return SourceTreeToPsiMap.treeElementToPsi(this.findChildByRole(54));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
    }

    @Override
    public Object @NotNull [] getVariants() {
        ElementFilter filter;
        switch (this.getKindEnum(this.getContainingFile())) {
            case CLASS_OR_PACKAGE_NAME_KIND: {
                filter = new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.PACKAGE);
                break;
            }
            case CLASS_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            case PACKAGE_NAME_KIND: {
                filter = ElementClassFilter.PACKAGE;
                break;
            }
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                filter = this.isQualified() ? new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.PACKAGE) : ElementClassFilter.PACKAGE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        Object[] objectArray = PsiImplUtil.getReferenceVariantsByFilter(this, filter);
        if (objectArray == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(79);
        }
        return objectArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(80);
        }
        ArrayList<ElementFilter> filters = new ArrayList<ElementFilter>();
        if (this.isInCode() && !(this.getParent() instanceof PsiImportStatement) && !(this.getParent() instanceof PsiReferenceList)) {
            filters.add(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter(new ConstructorFilter())));
            filters.add(ElementClassFilter.VARIABLE);
        }
        switch (this.getKindEnum(this.getContainingFile())) {
            case CLASS_OR_PACKAGE_NAME_KIND: {
                filters.add(ElementClassFilter.CLASS);
                filters.add(ElementClassFilter.PACKAGE);
                break;
            }
            case CLASS_NAME_KIND: {
                filters.add(ElementClassFilter.CLASS);
                if (!this.isQualified() && PsiTreeUtil.getParentOfType((PsiElement)this, PsiJavaModule.class) == null) break;
                filters.add(ElementClassFilter.PACKAGE);
                break;
            }
            case PACKAGE_NAME_KIND: {
                filters.add(ElementClassFilter.PACKAGE);
                break;
            }
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                filters.add(ElementClassFilter.PACKAGE);
                if (!this.isQualified() && !PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType())) break;
                filters.add(ElementClassFilter.CLASS);
                break;
            }
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement parent2 = this.getParent();
                if (parent2 instanceof PsiNewExpression) {
                    PsiExpression qualifier = ((PsiNewExpression)parent2).getQualifier();
                    assert (qualifier != null) : parent2;
                    PsiType type2 = qualifier.getType();
                    PsiClass aClass = PsiUtil.resolveClassInType(type2);
                    if (aClass != null) {
                        AndFilter filter = new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new ModifierFilter("static", false));
                        aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)filter, processor), ResolveState.initial(), null, this);
                    }
                }
                return;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        OrFilter filter = new OrFilter(filters.toArray(ElementFilter.EMPTY_ARRAY));
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)filter, processor);
        for (PsiTypeParameter typeParameter : this.getUnfinishedMethodTypeParameters()) {
            if (proc.execute(typeParameter, ResolveState.initial())) continue;
            return;
        }
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    private PsiTypeParameter @NotNull [] getUnfinishedMethodTypeParameters() {
        ProcessingContext context = new ProcessingContext();
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiJavaPatterns.psiElement(PsiTypeElement.class).afterLeaf((ElementPattern<PsiElement>)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(">")).withParent(((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiTypeParameterList.class).withParent(PsiErrorElement.class)).save("typeParameterList"))))).accepts(this, context)) {
            PsiTypeParameterList list = (PsiTypeParameterList)context.get("typeParameterList");
            PsiElement current = list.getParent().getParent();
            if (current instanceof PsiField) {
                current = current.getParent();
            }
            if (current instanceof PsiClass) {
                PsiTypeParameter[] psiTypeParameterArray = list.getTypeParameters();
                if (psiTypeParameterArray == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(81);
                }
                return psiTypeParameterArray;
            }
        }
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(82);
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    private boolean isInCode() {
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType()) || this.getParent() instanceof PsiAnnotation) {
            return false;
        }
        for (PsiElement superParent = this.getParent(); superParent != null; superParent = superParent.getParent()) {
            if (superParent instanceof PsiCodeBlock || superParent instanceof PsiLocalVariable) {
                return true;
            }
            if (!(superParent instanceof PsiClass) && !(superParent instanceof PsiCatchSection)) continue;
            return false;
        }
        return false;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return SourceTreeToPsiMap.treeElementToPsi(this.getReferenceNameNode());
    }

    @Nullable
    private ASTNode getReferenceNameNode() {
        return this.findChildByRole(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    @Override
    public String getQualifiedName() {
        Kind kind = this.getKindEnum(this.getContainingFile());
        switch (kind) {
            case CLASS_NAME_KIND: 
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name2 = aClass.getQualifiedName();
                    if (name2 == null) {
                        name2 = aClass.getName();
                    }
                    return name2;
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null, target);
                return this.getClassNameText();
            }
            case PACKAGE_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                return this.getNormalizedText();
            }
        }
        throw new IllegalArgumentException("Unexpected kind: " + (Object)((Object)kind));
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.getReferenceNameNode();
        if (childByRole == null) {
            return null;
        }
        return childByRole.getText();
    }

    @Override
    @NotNull
    public final TextRange getRangeInElement() {
        return PsiJavaCodeReferenceElementImpl.calcRangeInElement(this);
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        PsiReferenceParameterList parameterList2 = this.getParameterList();
        if (parameterList2 == null) {
            if (PsiType.EMPTY_ARRAY == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(83);
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] psiTypeArray = parameterList2.getTypeArguments();
        if (psiTypeArray == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(84);
        }
        return psiTypeArray;
    }

    @Override
    public int getTypeParameterCount() {
        PsiReferenceParameterList parameterList2 = this.getParameterList();
        if (parameterList2 == null) {
            return 0;
        }
        return parameterList2.getTypeArgumentCount();
    }

    @Override
    @NotNull
    public final PsiElement getElement() {
        PsiJavaCodeReferenceElementImpl psiJavaCodeReferenceElementImpl = this;
        if (psiJavaCodeReferenceElementImpl == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(85);
        }
        return psiJavaCodeReferenceElementImpl;
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(86);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public final String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 26: 
            case 42: 
            case 66: 
            case 70: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 59: 
            case 62: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindEnum";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRangeInElement";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "tryClassResult";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSubstitutor";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "bindToElement";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "bindToClass";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "bindToPackage";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedText";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameText";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnfinishedMethodTypeParameters";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setKindWhenDummy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDummy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKindEnum";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseUnknownParent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isCodeFragmentType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calcRangeInElement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "tryClassResult";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateSubstitutor";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "cannotBindError";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "bindToClass";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isFullyQualified";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "bindToPackage";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "fullyQualify";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Kind {
        CLASS_NAME_KIND,
        PACKAGE_NAME_KIND,
        CLASS_OR_PACKAGE_NAME_KIND,
        CLASS_FQ_NAME_KIND,
        CLASS_FQ_OR_PACKAGE_NAME_KIND,
        CLASS_IN_QUALIFIED_NEW_KIND;

    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        public ResolveResult @NotNull [] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                OurGenericsResolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                OurGenericsResolver.$$$reportNull$$$0(1);
            }
            PsiJavaCodeReferenceElementImpl referenceElement = (PsiJavaCodeReferenceElementImpl)ref;
            Kind kind = referenceElement.getKindEnum(containingFile);
            ResolveResult[] result2 = referenceElement.resolve(kind, containingFile);
            if (incompleteCode && result2.length == 0 && kind != Kind.CLASS_FQ_NAME_KIND && kind != Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND) {
                VariableResolverProcessor processor = new VariableResolverProcessor(referenceElement, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, referenceElement, null, true);
                result2 = processor.getResult();
                if (result2.length == 0 && kind == Kind.CLASS_NAME_KIND) {
                    result2 = referenceElement.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                }
            }
            if (result2.length == 0 && (kind == Kind.CLASS_OR_PACKAGE_NAME_KIND || kind == Kind.CLASS_NAME_KIND)) {
                String qualifiedName = referenceElement.getClassNameText();
                result2 = PsiJavaCodeReferenceElementImpl.tryClassResult(qualifiedName, referenceElement);
            }
            JavaResolveUtil.substituteResults(referenceElement, (JavaResolveResult[])result2);
            if (result2 == null) {
                OurGenericsResolver.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

