/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.lexer;

import com.intellij.lang.java.lexer.BasicJavaLexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.source.tree.JavaDocElementTypeFactory;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JavaLexer
extends BasicJavaLexer {
    private static final Set<String> KEYWORDS = ContainerUtil.immutableSet("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "non-sealed");
    private static final Set<CharSequence> JAVA9_KEYWORDS = CollectionFactory.createCharSequenceSet(Arrays.asList("open", "module", "requires", "exports", "opens", "uses", "provides", "transitive", "to", "with"));

    public JavaLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(0);
        }
        super(level, JavaDocElementTypeFactory.INSTANCE);
    }

    public static boolean isKeyword(@NotNull String id, @NotNull LanguageLevel level) {
        if (id == null) {
            JavaLexer.$$$reportNull$$$0(1);
        }
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(2);
        }
        return KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_1_4) && "assert".equals(id) || level.isAtLeast(LanguageLevel.JDK_1_5) && "enum".equals(id);
    }

    public static boolean isSoftKeyword(@NotNull CharSequence id, @NotNull LanguageLevel level) {
        if (id == null) {
            JavaLexer.$$$reportNull$$$0(3);
        }
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(4);
        }
        return level.isAtLeast(LanguageLevel.JDK_1_9) && JAVA9_KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_10) && "var".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_16) && "record".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_14) && "yield".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_17) && ("sealed".contentEquals(id) || "permits".contentEquals(id)) || level.isAtLeast(LanguageLevel.JDK_20_PREVIEW) && "when".contentEquals(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/java/lexer/JavaLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeyword";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSoftKeyword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

