/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J>\u0010\u001c\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001d*\u00020 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001f2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkSupertypes", "checkParameterBounds", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "visitedTypes", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,265:1\n28#2:266\n28#2:268\n28#2:269\n28#2:270\n49#2:271\n28#2:273\n28#2:274\n28#2:275\n26#3:267\n1#4:272\n45#5:276\n45#5:277\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n48#1:266\n73#1:268\n93#1:269\n112#1:270\n113#1:271\n156#1:273\n181#1:274\n206#1:275\n54#1:267\n236#1:276\n237#1:277\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration, reporter, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration, reporter, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration, reporter, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration, reporter, context2);
        this.checkParameterBounds(declaration, reporter, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(classVisibility = object2, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes = declaration.getSuperTypeRefs();
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        object = supertypes.iterator();
        while (object.hasNext()) {
            Pair pair;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeClassLikeType supertype;
            FirTypeRef supertypeRef;
            FirTypeRef $this$coneTypeSafe$iv = supertypeRef = (FirTypeRef)object.next();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null || TypeUtilsKt.toRegularClassSymbol(supertype, context2.getSession()) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, supertype, context2, (EffectiveVisibility)classVisibility, null, 4, null) == null) continue;
            FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
            KtSourceElement ktSourceElement = ((FirResolvedTypeRef)supertypeRef).getSource();
            if (ktSourceElement == null) {
                ktSourceElement = declaration.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(classVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter : declaration.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter.getSymbol().getResolvedBounds()) {
                Pair pair;
                if (FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(bound), context2, (EffectiveVisibility)classVisibility, null, 4, null) == null) continue;
                FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
                EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object typeAliasVisibility;
        ConeClassLikeType expandedType = FirDeclarationUtilKt.getExpandedConeType(declaration);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(typeAliasVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Object object2 = expandedType;
        if (object2 == null || (object2 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, (ConeKotlinType)object2, context2, (EffectiveVisibility)typeAliasVisibility, null, 4, null)) == null) {
            return;
        }
        Object object3 = object2;
        FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object3).component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)((Pair)object3).component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final void checkFunction(FirFunction declaration, DiagnosticReporter reporter, CheckerContext context2) {
        boolean isNonLocal;
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object functionVisibility = null;
        Intrinsics.checkNotNull(declaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean bl = isNonLocal = !Intrinsics.areEqual(functionVisibility, EffectiveVisibility.Local.INSTANCE);
        if (!(declaration instanceof FirPropertyAccessor)) {
            Object restrictingVisibility;
            Pair pair;
            if (isNonLocal && !(declaration instanceof FirConstructor) && (pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null)) != null) {
                Pair pair2 = pair;
                boolean bl2 = false;
                FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
                restrictingVisibility = (EffectiveVisibility)pair2.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, (Object)restricting, restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
            for (FirValueParameter valueParameter2 : declaration.getValueParameters()) {
                Pair pair3;
                Object propertyVisibility;
                FirProperty property;
                Pair bl2;
                boolean exposureFound = false;
                if (isNonLocal && (bl2 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null)) != null) {
                    restrictingVisibility = bl2;
                    boolean bl3 = false;
                    FirBasedSymbol restricting = (FirBasedSymbol)((Pair)restrictingVisibility).component1();
                    EffectiveVisibility restrictingVisibility2 = (EffectiveVisibility)((Pair)restrictingVisibility).component2();
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility2, (DiagnosticContext)context2, null, 64, null);
                    exposureFound = true;
                }
                if (exposureFound || ClassMembersKt.getCorrespondingProperty(valueParameter2) == null || property.isLocal()) continue;
                FirMemberDeclaration $this$effectiveVisibility$iv2 = property;
                boolean $i$f$getEffectiveVisibility2 = false;
                Object object2 = $this$effectiveVisibility$iv2.getStatus();
                Object object3 = object2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object2 : null;
                if (object3 == null || (object3 = object3.getEffectiveVisibility()) == null) {
                    object3 = EffectiveVisibility.Local.INSTANCE;
                }
                if (Intrinsics.areEqual(propertyVisibility = object3, EffectiveVisibility.Local.INSTANCE) || (pair3 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(property.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null)) == null) continue;
                object2 = pair3;
                boolean bl4 = false;
                FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object2).component1();
                EffectiveVisibility restrictingVisibility3 = (EffectiveVisibility)((Pair)object2).component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility3, (DiagnosticContext)context2, null, 64, null);
            }
        }
        if (isNonLocal) {
            FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
            this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null, reporter, context2);
        }
    }

    private final void checkProperty(FirProperty declaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object propertyVisibility;
        if (Intrinsics.areEqual(DeclarationAttributesKt.getFromPrimaryConstructor(declaration), true)) {
            return;
        }
        if (declaration.isLocal()) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(propertyVisibility = object2, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null);
        if (pair != null) {
            object = pair;
            boolean bl = false;
            FirBasedSymbol restricting = (FirBasedSymbol)((Pair)object).component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)((Pair)object).component2();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
        FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
        this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration, reporter, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual(memberVisibility = object, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, receiverParameterType, context2, (EffectiveVisibility)memberVisibility, null, 4, null);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base, Set<ConeKotlinType> visitedTypes) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> $this$effectiveVisibility$iv;
        Object object;
        ConeClassLikeType coneClassLikeType;
        if (!visitedTypes.add($this$findVisibilityExposure)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$findVisibilityExposure;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = (ConeClassLikeType)$this$findVisibilityExposure;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = ((ConeFlexibleType)$this$findVisibilityExposure).getLowerBound();
            coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType == null) {
                return null;
            }
        } else {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        object = classSymbol;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base, TypeComponentsKt.getTypeContext(context2.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return TuplesKt.to(classSymbol, effectiveVisibility);
                }
            }
        }
        object = type2.getTypeArguments();
        int n = ((ConeTypeProjection[])object).length;
        for (int i = 0; i < n; ++i) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> it;
            Object object2;
            int index = i;
            ConeTypeProjection it2 = object[i];
            ConeTypeProjection coneTypeProjection = it2;
            if (coneTypeProjection instanceof ConeClassLikeType) {
                object2 = this.findVisibilityExposure((ConeKotlinType)it2, context2, base, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                object2 = this.findVisibilityExposure(((ConeKotlinTypeProjection)it2).getType(), context2, base, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeStarProjection) {
                Object object3;
                block20: {
                    Object object4;
                    List<FirResolvedTypeRef> list;
                    FirTypeParameterSymbol firTypeParameterSymbol;
                    List<FirTypeParameterSymbol> list2;
                    object2 = TypeUtilsKt.toRegularClassSymbol(type2, context2.getSession());
                    if (object2 == null || (list2 = ((FirClassLikeSymbol)object2).getTypeParameterSymbols()) == null || (firTypeParameterSymbol = CollectionsKt.getOrNull(list2, index)) == null || (list = firTypeParameterSymbol.getResolvedBounds()) == null) continue;
                    for (Object it3 : (Iterable)list) {
                        boolean bl = false;
                        if ((it3 = INSTANCE.findVisibilityExposure(((FirResolvedTypeRef)it3).getType(), context2, base, visitedTypes)) == null) continue;
                        object4 = it3;
                        break block20;
                    }
                    object4 = object3 = null;
                }
                if (object3 == null) continue;
                Object it4 = object3;
                boolean bl = false;
                return it4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    static /* synthetic */ Pair findVisibilityExposure$default(FirExposedVisibilityDeclarationChecker firExposedVisibilityDeclarationChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, EffectiveVisibility effectiveVisibility, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        return firExposedVisibilityDeclarationChecker.findVisibilityExposure(coneKotlinType, checkerContext, effectiveVisibility, set);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            try {
                nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

