/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.JsInteropFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%J\u001d\u0010&\u001a\u00020\u001d*\u00060(j\u0002`'2\u0006\u0010\"\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0016J(\u00103\u001a\u0002042\u0006\u0010.\u001a\u00020\u00152\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002002\u0006\u00108\u001a\u000204H\u0002J.\u00109\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u00107\u001a\u0002002\u0006\u00108\u001a\u000204J\u000e\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020\u001aJ\u000e\u0010@\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010A\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001aJ(\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020;2\u0006\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020=2\u0006\u0010F\u001a\u000204H\u0002J\u0010\u0010G\u001a\u0002042\u0006\u0010 \u001a\u00020HH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0018\u0010/\u001a\u000200*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u0018\u00102\u001a\u000200*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00101\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCurrentFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "setCurrentFile", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "addedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getAddedDeclarations", "()Ljava/util/List;", "externalFunToTopLevelMapping", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getExternalFunToTopLevelMapping", "()Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "externalObjectToGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getExternalObjectToGetInstanceFunction", "lower", "", "irFile", "processExternalDeclaration", "declaration", "lowerExternalClass", "klass", "processExternalProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "appendExternalClassReference", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "processExternalConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "processExternalSimpleFunction", "function", "isSetOperator", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isGetOperator", "createJsCodeForFunction", "", "numDefaultParameters", "", "isConstructor", "jsFunctionReference", "processFunctionOrConstructor", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateExternalObjectInstanceGetter", "obj", "generateInstanceCheckForExternalClass", "generateGetClassForExternalClass", "createExternalJsFunction", "originalName", "suffix", "resultType", "jsCode", "referenceTopLevelExternalDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,547:1\n1#2:548\n1734#3,3:549\n1863#3,2:552\n*S KotlinDebug\n*F\n+ 1 ComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering\n*L\n218#1:549,3\n340#1:552,2\n*E\n"})
public final class ComplexExternalDeclarationsToTopLevelFunctionsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    public IrFile currentFile;
    @NotNull
    private final List<IrDeclaration> addedDeclarations;
    @NotNull
    private final Mapping.Delegate<IrFunction, IrSimpleFunction> externalFunToTopLevelMapping;
    @NotNull
    private final Mapping.Delegate<IrClass, IrSimpleFunction> externalObjectToGetInstanceFunction;

    public ComplexExternalDeclarationsToTopLevelFunctionsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.addedDeclarations = new ArrayList();
        this.externalFunToTopLevelMapping = this.context.getMapping().getWasmNestedExternalToNewTopLevelFunction();
        this.externalObjectToGetInstanceFunction = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFile getCurrentFile() {
        IrFile irFile = this.currentFile;
        if (irFile != null) {
            return irFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException("currentFile");
        return null;
    }

    public final void setCurrentFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "<set-?>");
        this.currentFile = irFile;
    }

    @NotNull
    public final List<IrDeclaration> getAddedDeclarations() {
        return this.addedDeclarations;
    }

    @NotNull
    public final Mapping.Delegate<IrFunction, IrSimpleFunction> getExternalFunToTopLevelMapping() {
        return this.externalFunToTopLevelMapping;
    }

    @NotNull
    public final Mapping.Delegate<IrClass, IrSimpleFunction> getExternalObjectToGetInstanceFunction() {
        return this.externalObjectToGetInstanceFunction;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.setCurrentFile(irFile);
        for (IrDeclaration declaration : irFile.getDeclarations()) {
            if (!IrUtilsKt.isEffectivelyExternal(declaration)) continue;
            this.processExternalDeclaration(declaration);
        }
        CollectionsKt.addAll((Collection)irFile.getDeclarations(), (Iterable)this.addedDeclarations);
        this.addedDeclarations.clear();
    }

    public final void processExternalDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrVisitorsKt.acceptVoid(declaration, new IrElementVisitorVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                throw new IllegalStateException(("Unknown external element " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
            }

            public void visitTypeParameter(IrTypeParameter declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
            }

            public void visitValueParameter(IrValueParameter declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrVisitorsKt.acceptChildrenVoid(declaration, this);
                this.this$0.lowerExternalClass(declaration);
            }

            public void visitProperty(IrProperty declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.this$0.processExternalProperty(declaration);
            }

            public void visitConstructor(IrConstructor declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.this$0.processExternalConstructor(declaration);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.this$0.processExternalSimpleFunction(declaration);
            }

            public void visitElement(IrElement element, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitValueParameter(IrValueParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            public void visitClass(IrClass declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            public void visitFunction(IrFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
            }

            public void visitFunction(IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitConstructor(IrConstructor declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
            }

            public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            public void visitEnumEntry(IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitField(IrField declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
            }

            public void visitField(IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            public void visitModuleFragment(IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitProperty(IrProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
            }

            public void visitScript(IrScript declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
            }

            public void visitScript(IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            public void visitTypeAlias(IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitVariable(IrVariable declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
            }

            public void visitVariable(IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            public void visitPackageFragment(IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitFile(IrFile declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
            }

            public void visitFile(IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitExpression(IrExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpression(IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitBody(IrBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBody(IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitExpressionBody(IrExpressionBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExpressionBody(IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitBlockBody(IrBlockBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBlockBody(IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitConstructorCall(IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContainerExpression(IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitBlock(IrBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlock(IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitComposite(IrComposite expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public void visitComposite(IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
            }

            public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitSyntheticBody(IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitBreakContinue(IrBreakContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitBreakContinue(IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreak(IrBreak jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreak(IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitContinue(IrContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitContinue(IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitCall(IrCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCall(IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitFunctionReference(IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitPropertyReference(IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitClassReference(IrClassReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitClassReference(IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitConst(IrConst<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConst(IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConstantValue(IrConstantValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstantValue(IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantObject(IrConstantObject expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantObject(IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantArray(IrConstantArray expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantArray(IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitErrorExpression(IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitGetField(IrGetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitGetField(IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitSetField(IrSetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetField(IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitGetClass(IrGetClass expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetClass(IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitLoop(IrLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
            }

            public void visitLoop(IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
            }

            public void visitWhileLoop(IrWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
            }

            public void visitWhileLoop(IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
            }

            public void visitReturn(IrReturn expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitReturn(IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitThrow(IrThrow expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitThrow(IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitTry(IrTry aTry, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTry(IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitCatch(IrCatch aCatch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitCatch(IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitValueAccess(IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitGetValue(IrGetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitGetValue(IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitSetValue(IrSetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSetValue(IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitVararg(IrVararg expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVararg(IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitSpreadElement(IrSpreadElement spread, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitSpreadElement(IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitWhen(IrWhen expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhen(IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitBranch(IrBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBranch(IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitElseBranch(IrElseBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitElseBranch(IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }
        });
    }

    public final void lowerExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (klass.getKind() == ClassKind.OBJECT) {
            this.generateExternalObjectInstanceGetter(klass);
        }
        if (klass.getKind() != ClassKind.INTERFACE) {
            this.generateInstanceCheckForExternalClass(klass);
            this.generateGetClassForExternalClass(klass);
        }
    }

    public final void processExternalProperty(@NotNull IrProperty property) {
        block4: {
            IrSimpleFunction res2;
            String jsCode;
            IrValueParameter dispatchReceiver;
            Intrinsics.checkNotNullParameter(property, "property");
            if (property.isFakeOverride()) {
                return;
            }
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(property).getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
            String propName = string2;
            IrSimpleFunction irSimpleFunction = property.getGetter();
            if (irSimpleFunction != null) {
                IrSimpleFunction getter2 = irSimpleFunction;
                boolean bl = false;
                dispatchReceiver = getter2.getDispatchReceiverParameter();
                jsCode = dispatchReceiver == null ? "() => " + this.referenceTopLevelExternalDeclaration(property) : "(_this) => _this." + propName;
                res2 = this.createExternalJsFunction(property.getName(), "_$external_prop_getter", getter2.getReturnType(), jsCode);
                if (dispatchReceiver != null) {
                    DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
                }
                this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)getter2), res2);
            }
            IrSimpleFunction irSimpleFunction2 = property.getSetter();
            if (irSimpleFunction2 == null) break block4;
            IrSimpleFunction setter2 = irSimpleFunction2;
            boolean bl = false;
            dispatchReceiver = setter2.getDispatchReceiverParameter();
            jsCode = dispatchReceiver == null ? "(v) => " + this.referenceTopLevelExternalDeclaration(property) + " = v" : "(_this, v) => _this." + propName + " = v";
            res2 = this.createExternalJsFunction(property.getName(), "_$external_prop_setter", setter2.getReturnType(), jsCode);
            if (dispatchReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
            }
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "v", setter2.getValueParameters().get(0).getType(), null, 4, null);
            this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)setter2), res2);
        }
    }

    private final void appendExternalClassReference(StringBuilder $this$appendExternalClassReference, IrClass klass) {
        StringBuilder stringBuilder;
        IrDeclarationParent parent2 = klass.getParent();
        if (parent2 instanceof IrClass) {
            if (IrUtilsKt.isInterface((IrClass)parent2)) {
                $this$appendExternalClassReference.append("({})");
                return;
            }
            this.appendExternalClassReference($this$appendExternalClassReference, (IrClass)parent2);
            if (klass.isCompanion()) {
                return;
            }
            $this$appendExternalClassReference.append('.');
            stringBuilder = $this$appendExternalClassReference.append(AnnotationUtilsKt.getJsNameOrKotlinName(klass));
        } else {
            stringBuilder = $this$appendExternalClassReference.append(this.referenceTopLevelExternalDeclaration(klass));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processExternalConstructor(@NotNull IrConstructor constructor2) {
        void $this$processExternalConstructor_u24lambda_u242;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        IrClass klass = AdditionalIrUtilsKt.getConstructedClass(constructor2);
        if (IrUtilsKt.isInterface(klass)) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = true;
        IrType irType = IrUtilsKt.getDefaultType(klass);
        Name name2 = klass.getName();
        IrFunction irFunction = constructor2;
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        boolean bl2 = false;
        this.appendExternalClassReference((StringBuilder)$this$processExternalConstructor_u24lambda_u242, klass);
        Unit unit = Unit.INSTANCE;
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        complexExternalDeclarationsToTopLevelFunctionsLowering2.processFunctionOrConstructor(irFunction, name2, irType, bl, string2);
    }

    public final void processExternalSimpleFunction(@NotNull IrSimpleFunction function2) {
        String string2;
        Intrinsics.checkNotNullParameter(function2, "function");
        if (AnnotationsKt.getWasmImportDescriptor(function2) != null) {
            return;
        }
        String jsFun = AnnotationsKt.getJsFunAnnotation(function2);
        if (jsFun != null) {
            boolean bl;
            block11: {
                Iterable $this$all$iv = function2.getValueParameters();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (it.getDefaultValue() == null && it.getVarargElementType() == null) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl && AnnotationUtilsKt.getJsQualifier(this.getCurrentFile()) == null && AnnotationUtilsKt.getJsModule(this.getCurrentFile()) == null) {
                return;
            }
        }
        if (function2.isFakeOverride()) {
            return;
        }
        if (jsFun != null) {
            string2 = '(' + jsFun + ')';
        } else if (AdditionalIrUtilsKt.isTopLevelDeclaration(function2)) {
            string2 = this.referenceTopLevelExternalDeclaration(function2);
        } else {
            String string3 = AnnotationUtilsKt.getJsNameOrKotlinName(function2).getIdentifier();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "getIdentifier(...)");
        }
        String jsFunctionReference = string2;
        this.processFunctionOrConstructor(function2, function2.getName(), function2.getReturnType(), false, jsFunctionReference);
    }

    private final boolean isSetOperator(IrFunction $this$isSetOperator) {
        return $this$isSetOperator instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isSetOperator).isOperator() && Intrinsics.areEqual($this$isSetOperator.getName().asString(), "set");
    }

    private final boolean isGetOperator(IrFunction $this$isGetOperator) {
        return $this$isGetOperator instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isGetOperator).isOperator() && Intrinsics.areEqual($this$isGetOperator.getName().asString(), "get");
    }

    private final String createJsCodeForFunction(IrFunction function2, int numDefaultParameters, boolean isConstructor, String jsFunctionReference) {
        int it;
        int n;
        StringBuilder stringBuilder;
        IrValueParameter dispatchReceiver = function2.getDispatchReceiverParameter();
        int numValueParameters = function2.getValueParameters().size();
        StringBuilder $this$createJsCodeForFunction_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createJsCodeForFunction_u24lambda_u246.append("(");
        if (dispatchReceiver != null) {
            $this$createJsCodeForFunction_u24lambda_u246.append("_this, ");
        }
        JsInteropFunctionsLoweringKt.appendParameterList$default($this$createJsCodeForFunction_u24lambda_u246, numValueParameters, null, numDefaultParameters == 0, 2, null);
        JsInteropFunctionsLoweringKt.appendParameterList($this$createJsCodeForFunction_u24lambda_u246, numDefaultParameters, "isDefault", true);
        $this$createJsCodeForFunction_u24lambda_u246.append(") => ");
        if (isConstructor) {
            $this$createJsCodeForFunction_u24lambda_u246.append("new ");
        }
        if (dispatchReceiver != null) {
            $this$createJsCodeForFunction_u24lambda_u246.append("_this.");
        }
        $this$createJsCodeForFunction_u24lambda_u246.append(jsFunctionReference);
        $this$createJsCodeForFunction_u24lambda_u246.append("(");
        int numNonDefaultParamters = numValueParameters - numDefaultParameters;
        for (n = 0; n < numNonDefaultParamters; ++n) {
            it = n;
            boolean bl2 = false;
            if (AdditionalIrUtilsKt.isVararg(function2.getValueParameters().get(it))) {
                $this$createJsCodeForFunction_u24lambda_u246.append("...");
            }
            $this$createJsCodeForFunction_u24lambda_u246.append("" + 'p' + it);
            if (numDefaultParameters == 0 && it + 1 >= numNonDefaultParamters) continue;
            $this$createJsCodeForFunction_u24lambda_u246.append(", ");
        }
        for (n = 0; n < numDefaultParameters; ++n) {
            it = n;
            boolean bl3 = false;
            StringBuilder stringBuilder2 = AdditionalIrUtilsKt.isVararg(function2.getValueParameters().get(numNonDefaultParamters + it)) ? $this$createJsCodeForFunction_u24lambda_u246.append("...") : $this$createJsCodeForFunction_u24lambda_u246.append("isDefault" + it + " ? undefined : ");
            $this$createJsCodeForFunction_u24lambda_u246.append("" + 'p' + (numNonDefaultParamters + it) + ", ");
        }
        $this$createJsCodeForFunction_u24lambda_u246.append(")");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public final void processFunctionOrConstructor(@NotNull IrFunction function2, @NotNull Name name2, @NotNull IrType returnType, boolean isConstructor, @NotNull String jsFunctionReference) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        Intrinsics.checkNotNullParameter(jsFunctionReference, "jsFunctionReference");
        IrValueParameter dispatchReceiver = function2.getDispatchReceiverParameter();
        int numDefaultParameters = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.access$numDefaultParametersForExternalFunction(function2);
        String jsCode = this.isSetOperator(function2) ? "(_this, i, value) => _this[i] = value" : (this.isGetOperator(function2) ? "(_this, i) => _this[i]" : this.createJsCodeForFunction(function2, numDefaultParameters, isConstructor, jsFunctionReference));
        IrSimpleFunction res2 = this.createExternalJsFunction(name2, "_$external_fun", returnType, jsCode);
        if (dispatchReceiver != null) {
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
        }
        Iterable $this$forEach$iv = function2.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter irValueParameter;
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            IrValueParameter $this$processFunctionOrConstructor_u24lambda_u248_u24lambda_u247 = irValueParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, it.getName(), it.getType(), null, 4, null);
            boolean bl2 = false;
            $this$processFunctionOrConstructor_u24lambda_u248_u24lambda_u247.setVarargElementType(it.getVarargElementType());
        }
        int n = 0;
        while (n < numDefaultParameters) {
            int it = n++;
            boolean bl = false;
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "isDefault" + it, this.context.getIrBuiltIns().getIntType(), null, 4, null);
        }
        this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)function2), res2);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateExternalObjectInstanceGetter(@NotNull IrClass obj) {
        void $this$generateExternalObjectInstanceGetter_u24lambda_u2410;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(obj, "obj");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        IrType irType = IrUtilsKt.getDefaultType(obj);
        String string2 = "_$external_object_getInstance";
        Name name2 = obj.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrDeclaration irDeclaration2 = obj;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
        boolean bl = false;
        $this$generateExternalObjectInstanceGetter_u24lambda_u2410.append("() => ");
        this.appendExternalClassReference((StringBuilder)$this$generateExternalObjectInstanceGetter_u24lambda_u2410, obj);
        Unit unit = Unit.INSTANCE;
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        delegate.set((IrClass)irDeclaration2, complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string2, irType, string3));
    }

    /*
     * WARNING - void declaration
     */
    public final void generateInstanceCheckForExternalClass(@NotNull IrClass klass) {
        void it;
        Object $this$generateInstanceCheckForExternalClass_u24lambda_u2411;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Object object = new StringBuilder();
        StringBuilder stringBuilder = object;
        IrType irType = this.context.getIrBuiltIns().getBooleanType();
        String string2 = "_$external_class_instanceof";
        Name name2 = klass.getName();
        Object object2 = this;
        IrDeclaration irDeclaration2 = klass;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate = this.context.getMapping().getWasmExternalClassToInstanceCheck();
        boolean bl = false;
        String jsPrimitiveType = AnnotationsKt.getJsPrimitiveType(klass);
        if (jsPrimitiveType != null) {
            ((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2411).append("(x) => typeof x === '" + jsPrimitiveType + '\'');
        } else {
            ((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2411).append("(x) => x instanceof ");
            this.appendExternalClassReference((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2411, klass);
        }
        Unit unit = Unit.INSTANCE;
        String string3 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        $this$generateInstanceCheckForExternalClass_u24lambda_u2411 = object = ((ComplexExternalDeclarationsToTopLevelFunctionsLowering)object2).createExternalJsFunction(name2, string2, irType, string3);
        boolean bl2 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)it, "x", this.context.getIrBuiltIns().getAnyType(), null, 4, null);
        object2 = Unit.INSTANCE;
        delegate.set((IrClass)irDeclaration2, (IrSimpleFunction)object);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateGetClassForExternalClass(@NotNull IrClass klass) {
        void $this$generateGetClassForExternalClass_u24lambda_u2413;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(klass, "klass");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        IrType irType = IrTypesKt.makeNullable(this.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType());
        String string2 = "_$external_class_get";
        Name name2 = klass.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrDeclaration irDeclaration2 = klass;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate = this.context.getMapping().getWasmGetJsClass();
        boolean bl = false;
        $this$generateGetClassForExternalClass_u24lambda_u2413.append("() => ");
        this.appendExternalClassReference((StringBuilder)$this$generateGetClassForExternalClass_u24lambda_u2413, klass);
        Unit unit = Unit.INSTANCE;
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        delegate.set((IrClass)irDeclaration2, complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string2, irType, string3));
    }

    private final IrSimpleFunction createExternalJsFunction(Name originalName, String suffix, IrType resultType, String jsCode) {
        IrSimpleFunction res2 = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this.context, originalName, suffix, resultType, jsCode);
        res2.setParent(this.getCurrentFile());
        ((Collection)this.addedDeclarations).add(res2);
        return res2;
    }

    private final String referenceTopLevelExternalDeclaration(IrDeclarationWithName declaration) {
        String string2;
        String string3;
        String module2;
        String it;
        String name2 = null;
        name2 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).getIdentifier();
        String qualifier = AnnotationUtilsKt.getJsQualifier(this.getCurrentFile());
        String string4 = AnnotationUtilsKt.getJsModule(this.getCurrentFile());
        if (string4 == null) {
            String string5 = AnnotationUtilsKt.getJsModule(declaration);
            if (string5 != null) {
                String string6;
                it = string6 = string5;
                boolean bl = false;
                name2 = declaration instanceof IrClass && IrUtilsKt.isObject((IrClass)declaration) ? null : "default";
                string4 = string6;
            } else {
                string4 = module2 = null;
            }
        }
        if (qualifier == null && module2 == null) {
            String string7 = name2;
            Intrinsics.checkNotNull(string7);
            return string7;
        }
        JsModuleAndQualifierReference qualifieReference = new JsModuleAndQualifierReference(module2, qualifier);
        ((Collection)this.context.getJsModuleAndQualifierReferences()).add(qualifieReference);
        StringBuilder stringBuilder = new StringBuilder().append(qualifieReference.getJsVariableName());
        String string8 = name2;
        if (string8 != null) {
            it = string8;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            string3 = '.' + it;
            stringBuilder = stringBuilder2;
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = "";
        }
        return stringBuilder.append(string2).toString();
    }
}

