/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelTypeAliasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTopLevelTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirTopLevelTypeAliasChecker INSTANCE = new FirTopLevelTypeAliasChecker();

    private FirTopLevelTypeAliasChecker() {
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirTypeRef expandedTypeRef;
        ConeKotlinType fullyExpandedType2;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!FirHelpersKt.isTopLevel(context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getTOPLEVEL_TYPEALIASES_ONLY(), (DiagnosticContext)context2, null, 8, null);
        }
        if (FirTopLevelTypeAliasChecker.check$containsTypeParameter(context2, fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(expandedTypeRef = declaration.getExpandedTypeRef()), context2.getSession())) || fullyExpandedType2 instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_SHOULD_EXPAND_TO_CLASS(), (Object)FirTypeUtilsKt.getConeType(expandedTypeRef), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private static final boolean check$containsTypeParameter(CheckerContext $context, ConeKotlinType type2) {
        ConeSimpleKotlinType unwrapped = ConeTypesKt.unwrapDefinitelyNotNull(ConeTypeUtilsKt.lowerBoundIfFlexible(type2));
        if (unwrapped instanceof ConeTypeParameterType) {
            return true;
        }
        if (unwrapped instanceof ConeClassLikeType && LookupTagUtilsKt.toSymbol(((ConeClassLikeType)unwrapped).getLookupTag(), $context.getSession()) instanceof FirTypeAliasSymbol) {
            for (ConeTypeProjection typeArgument : unwrapped.getTypeArguments()) {
                ConeKotlinType typeArgumentType;
                ConeKotlinType coneKotlinType = typeArgument instanceof ConeKotlinType ? (ConeKotlinType)typeArgument : null;
                if (coneKotlinType == null) {
                    ConeKotlinTypeProjection coneKotlinTypeProjection = typeArgument instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)typeArgument : null;
                    coneKotlinType = coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
                }
                if ((typeArgumentType = coneKotlinType) == null || !FirTopLevelTypeAliasChecker.check$containsTypeParameter($context, typeArgumentType)) continue;
                return true;
            }
        }
        return false;
    }
}

