/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.incremental.storage.RelativeFileToPathConverter;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/build/JvmBuildMetaInfo;", "Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "converter", "Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;)V", "argumentsListForSpecialCheck", "", "", "getArgumentsListForSpecialCheck", "()Ljava/util/List;", "excludedProperties", "getExcludedProperties", "checkIfPlatformSpecificCompilerArgumentWasChanged", "", "key", "currentValue", "previousValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "createPropertiesMapFromCompilerArguments", "", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nJvmBuildMetaInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBuildMetaInfo.kt\norg/jetbrains/kotlin/build/JvmBuildMetaInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class JvmBuildMetaInfo
extends BuildMetaInfo {
    public JvmBuildMetaInfo(@Nullable RelativeFileToPathConverter converter) {
        super(converter);
    }

    @Override
    @Nullable
    public Boolean checkIfPlatformSpecificCompilerArgumentWasChanged(@NotNull String key, @NotNull String currentValue, @NotNull String previousValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(currentValue, "currentValue");
        Intrinsics.checkNotNullParameter(previousValue, "previousValue");
        if (Intrinsics.areEqual(key, "METADATA_VERSION_STRING")) {
            int[] previousVersionIntArray;
            int[] currentVersionIntArray;
            if (!(currentVersionIntArray != null ? (currentVersionIntArray = BinaryVersion.Companion.parseVersionArray(currentValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray = new int[]{currentVersionIntArray[0], currentVersionIntArray[1], currentVersionIntArray[2]};
            JvmMetadataVersion currentVersion = new JvmMetadataVersion(nArray);
            if (!(previousVersionIntArray != null ? (previousVersionIntArray = BinaryVersion.Companion.parseVersionArray(previousValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray2 = new int[]{previousVersionIntArray[0], previousVersionIntArray[1], previousVersionIntArray[2]};
            JvmMetadataVersion previousVersion = new JvmMetadataVersion(nArray2);
            return !Intrinsics.areEqual(currentVersion, previousVersion);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> createPropertiesMapFromCompilerArguments(@NotNull CommonCompilerArguments args) {
        JvmMetadataVersion jvmMetadataVersion;
        int[] metadataVersionArray;
        int[] nArray;
        Intrinsics.checkNotNullParameter(args, "args");
        Map resultMap = new LinkedHashMap();
        String string2 = args.getMetadataVersion();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            nArray = BinaryVersion.Companion.parseVersionArray(it);
        } else {
            nArray = null;
        }
        if (metadataVersionArray != null) {
            int[] p0 = metadataVersionArray = nArray;
            boolean bl = false;
            jvmMetadataVersion = new JvmMetadataVersion(p0);
        } else {
            jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
        }
        JvmMetadataVersion metadataVersion = jvmMetadataVersion;
        String metadataVersionString = metadataVersion.toString();
        resultMap.put("METADATA_VERSION_STRING", metadataVersionString);
        return MapsKt.plus(super.createPropertiesMapFromCompilerArguments(args), resultMap);
    }

    @Override
    @NotNull
    public List<String> getExcludedProperties() {
        String[] stringArray = new String[]{"excludedProperties", "backendThreads", "buildFile", "classpath", "declarationsOutputPath", "defaultScriptExtension", "enableDebugMode", "expression", "internalArguments", "profileCompilerCommand", "repeatCompileModules", "scriptResolverEnvironment", "scriptTemplates", "suppressDeprecatedJvmTargetWarning", "useFastJarFileSystem"};
        return CollectionsKt.plus((Collection)super.getExcludedProperties(), (Iterable)CollectionsKt.listOf(stringArray));
    }

    @Override
    @NotNull
    public List<String> getArgumentsListForSpecialCheck() {
        String[] stringArray = new String[]{"allowNoSourceFiles", "allowUnstableDependencies", "enableJvmPreview", "suppressMissingBuiltinsError"};
        return CollectionsKt.plus((Collection)super.getArgumentsListForSpecialCheck(), (Iterable)CollectionsKt.listOf(stringArray));
    }
}

