/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.BinaryFormat;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.KonanTargetExtenstionsKt$WhenMappings;
import org.jetbrains.kotlin.konan.target.SanitizerKind;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006 "}, d2={"supportsGrandCentralDispatch", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getSupportsGrandCentralDispatch", "(Lorg/jetbrains/kotlin/konan/target/KonanTarget;)Z", "binaryFormat", "Lorg/jetbrains/kotlin/konan/target/BinaryFormat;", "customArgsForKonanSources", "", "", "hasAddressDependencyInMemoryModel", "hasFoundationFramework", "hasUIKitFramework", "needSmallBinary", "pointerBits", "", "suportsMemMem", "supportedSanitizers", "Lorg/jetbrains/kotlin/konan/target/SanitizerKind;", "supports64BitAtomics", "supports64BitMulOverflow", "supportsCodeCoverage", "supportsCoreSymbolication", "supportsExceptions", "supportsGccUnwind", "supportsIosCrashLog", "supportsLibBacktrace", "supportsMimallocAllocator", "supportsObjcInterop", "supportsThreads", "supportsUnalignedAccess", "supportsWinAPIUnwind", "kotlin-native-utils"})
public final class KonanTargetExtenstionsKt {
    @Nullable
    public static final BinaryFormat binaryFormat(@NotNull KonanTarget $this$binaryFormat) {
        BinaryFormat binaryFormat;
        Intrinsics.checkNotNullParameter($this$binaryFormat, "$this$binaryFormat");
        switch (KonanTargetExtenstionsKt$WhenMappings.$EnumSwitchMapping$0[$this$binaryFormat.getFamily().ordinal()]) {
            case 1: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 2: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 3: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 4: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 5: {
                binaryFormat = BinaryFormat.ELF;
                break;
            }
            case 6: {
                binaryFormat = BinaryFormat.ELF;
                break;
            }
            case 7: {
                binaryFormat = BinaryFormat.PE_COFF;
                break;
            }
            case 8: 
            case 9: {
                binaryFormat = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return binaryFormat;
    }

    public static final int pointerBits(@NotNull KonanTarget $this$pointerBits) {
        int n;
        Intrinsics.checkNotNullParameter($this$pointerBits, "$this$pointerBits");
        switch (KonanTargetExtenstionsKt$WhenMappings.$EnumSwitchMapping$1[$this$pointerBits.getArchitecture().ordinal()]) {
            case 1: {
                n = 64;
                break;
            }
            case 2: {
                n = 32;
                break;
            }
            case 3: {
                if (Intrinsics.areEqual($this$pointerBits, KonanTarget.WATCHOS_ARM64.INSTANCE)) {
                    n = 32;
                    break;
                }
                n = 64;
                break;
            }
            case 4: {
                n = 32;
                break;
            }
            case 5: {
                n = 32;
                break;
            }
            case 6: {
                n = 32;
                break;
            }
            case 7: {
                n = 32;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public static final boolean supportsCodeCoverage(@NotNull KonanTarget $this$supportsCodeCoverage) {
        Intrinsics.checkNotNullParameter($this$supportsCodeCoverage, "$this$supportsCodeCoverage");
        return false;
    }

    public static final boolean supportsMimallocAllocator(@NotNull KonanTarget $this$supportsMimallocAllocator) {
        Intrinsics.checkNotNullParameter($this$supportsMimallocAllocator, "$this$supportsMimallocAllocator");
        KonanTarget konanTarget = $this$supportsMimallocAllocator;
        return konanTarget instanceof KonanTarget.LINUX_X64 ? true : (konanTarget instanceof KonanTarget.MINGW_X86 ? true : (konanTarget instanceof KonanTarget.MINGW_X64 ? true : (konanTarget instanceof KonanTarget.MACOS_X64 ? true : (konanTarget instanceof KonanTarget.MACOS_ARM64 ? true : (konanTarget instanceof KonanTarget.LINUX_ARM64 ? true : (konanTarget instanceof KonanTarget.LINUX_ARM32_HFP ? true : (konanTarget instanceof KonanTarget.ANDROID_X64 ? true : (konanTarget instanceof KonanTarget.ANDROID_ARM64 ? true : (konanTarget instanceof KonanTarget.IOS_ARM32 ? true : (konanTarget instanceof KonanTarget.IOS_ARM64 ? true : (konanTarget instanceof KonanTarget.IOS_X64 ? true : (konanTarget instanceof KonanTarget.IOS_SIMULATOR_ARM64 ? true : (konanTarget instanceof KonanTarget.WATCHOS_ARM32 || konanTarget instanceof KonanTarget.WATCHOS_ARM64 || konanTarget instanceof KonanTarget.WATCHOS_SIMULATOR_ARM64 || konanTarget instanceof KonanTarget.WATCHOS_X64 || konanTarget instanceof KonanTarget.WATCHOS_X86 || konanTarget instanceof KonanTarget.TVOS_ARM64 || konanTarget instanceof KonanTarget.TVOS_SIMULATOR_ARM64 || konanTarget instanceof KonanTarget.TVOS_X64 || konanTarget instanceof KonanTarget.ANDROID_X86 || konanTarget instanceof KonanTarget.ANDROID_ARM32 ? false : (konanTarget instanceof KonanTarget.LINUX_MIPS32 || konanTarget instanceof KonanTarget.LINUX_MIPSEL32 ? false : (konanTarget instanceof KonanTarget.WASM32 || konanTarget instanceof KonanTarget.ZEPHYR ? false : false)))))))))))))));
    }

    public static final boolean supportsLibBacktrace(@NotNull KonanTarget $this$supportsLibBacktrace) {
        Intrinsics.checkNotNullParameter($this$supportsLibBacktrace, "$this$supportsLibBacktrace");
        return $this$supportsLibBacktrace.getFamily().isAppleFamily() || $this$supportsLibBacktrace.getFamily() == Family.LINUX && !CollectionsKt.listOf(Architecture.MIPS32, Architecture.MIPSEL32).contains((Object)$this$supportsLibBacktrace.getArchitecture()) || $this$supportsLibBacktrace.getFamily() == Family.ANDROID;
    }

    public static final boolean supportsCoreSymbolication(@NotNull KonanTarget $this$supportsCoreSymbolication) {
        Intrinsics.checkNotNullParameter($this$supportsCoreSymbolication, "$this$supportsCoreSymbolication");
        return CollectionsKt.listOf(KonanTarget.MACOS_X64.INSTANCE, KonanTarget.MACOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.IOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.TVOS_X64.INSTANCE, KonanTarget.TVOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_X86.INSTANCE, KonanTarget.WATCHOS_X64.INSTANCE, KonanTarget.WATCHOS_SIMULATOR_ARM64.INSTANCE).contains($this$supportsCoreSymbolication);
    }

    public static final boolean supportsGccUnwind(@NotNull KonanTarget $this$supportsGccUnwind) {
        Intrinsics.checkNotNullParameter($this$supportsGccUnwind, "$this$supportsGccUnwind");
        return $this$supportsGccUnwind.getFamily() == Family.ANDROID || $this$supportsGccUnwind.getFamily() == Family.LINUX || $this$supportsGccUnwind instanceof KonanTarget.MINGW_X86;
    }

    public static final boolean supportsWinAPIUnwind(@NotNull KonanTarget $this$supportsWinAPIUnwind) {
        Intrinsics.checkNotNullParameter($this$supportsWinAPIUnwind, "$this$supportsWinAPIUnwind");
        return $this$supportsWinAPIUnwind instanceof KonanTarget.MINGW_X64;
    }

    public static final boolean supportsThreads(@NotNull KonanTarget $this$supportsThreads) {
        Intrinsics.checkNotNullParameter($this$supportsThreads, "$this$supportsThreads");
        KonanTarget konanTarget = $this$supportsThreads;
        return konanTarget instanceof KonanTarget.WASM32 ? false : !(konanTarget instanceof KonanTarget.ZEPHYR);
    }

    public static final boolean supportsExceptions(@NotNull KonanTarget $this$supportsExceptions) {
        Intrinsics.checkNotNullParameter($this$supportsExceptions, "$this$supportsExceptions");
        KonanTarget konanTarget = $this$supportsExceptions;
        return konanTarget instanceof KonanTarget.WASM32 ? false : !(konanTarget instanceof KonanTarget.ZEPHYR);
    }

    public static final boolean suportsMemMem(@NotNull KonanTarget $this$suportsMemMem) {
        Intrinsics.checkNotNullParameter($this$suportsMemMem, "$this$suportsMemMem");
        KonanTarget konanTarget = $this$suportsMemMem;
        return konanTarget instanceof KonanTarget.WASM32 ? false : (konanTarget instanceof KonanTarget.MINGW_X86 ? false : (konanTarget instanceof KonanTarget.MINGW_X64 ? false : !(konanTarget instanceof KonanTarget.ZEPHYR)));
    }

    public static final boolean supportsObjcInterop(@NotNull KonanTarget $this$supportsObjcInterop) {
        Intrinsics.checkNotNullParameter($this$supportsObjcInterop, "$this$supportsObjcInterop");
        return $this$supportsObjcInterop.getFamily().isAppleFamily();
    }

    public static final boolean hasFoundationFramework(@NotNull KonanTarget $this$hasFoundationFramework) {
        Intrinsics.checkNotNullParameter($this$hasFoundationFramework, "$this$hasFoundationFramework");
        return $this$hasFoundationFramework.getFamily().isAppleFamily();
    }

    public static final boolean hasUIKitFramework(@NotNull KonanTarget $this$hasUIKitFramework) {
        Intrinsics.checkNotNullParameter($this$hasUIKitFramework, "$this$hasUIKitFramework");
        return $this$hasUIKitFramework.getFamily() == Family.IOS || $this$hasUIKitFramework.getFamily() == Family.TVOS;
    }

    public static final boolean supports64BitMulOverflow(@NotNull KonanTarget $this$supports64BitMulOverflow) {
        Intrinsics.checkNotNullParameter($this$supports64BitMulOverflow, "$this$supports64BitMulOverflow");
        KonanTarget konanTarget = $this$supports64BitMulOverflow;
        return konanTarget instanceof KonanTarget.MINGW_X86 ? false : (konanTarget instanceof KonanTarget.LINUX_ARM32_HFP ? false : (konanTarget instanceof KonanTarget.LINUX_MIPS32 ? false : (konanTarget instanceof KonanTarget.LINUX_MIPSEL32 ? false : (konanTarget instanceof KonanTarget.WASM32 ? false : (konanTarget instanceof KonanTarget.ZEPHYR ? false : (konanTarget instanceof KonanTarget.ANDROID_ARM32 ? false : !(konanTarget instanceof KonanTarget.ANDROID_X86)))))));
    }

    public static final boolean supportsIosCrashLog(@NotNull KonanTarget $this$supportsIosCrashLog) {
        Intrinsics.checkNotNullParameter($this$supportsIosCrashLog, "$this$supportsIosCrashLog");
        KonanTarget konanTarget = $this$supportsIosCrashLog;
        return Intrinsics.areEqual(konanTarget, KonanTarget.IOS_ARM32.INSTANCE) ? true : (Intrinsics.areEqual(konanTarget, KonanTarget.IOS_ARM64.INSTANCE) ? true : (Intrinsics.areEqual(konanTarget, KonanTarget.WATCHOS_ARM32.INSTANCE) ? true : (Intrinsics.areEqual(konanTarget, KonanTarget.WATCHOS_ARM64.INSTANCE) ? true : Intrinsics.areEqual(konanTarget, KonanTarget.TVOS_ARM64.INSTANCE))));
    }

    public static final boolean supports64BitAtomics(@NotNull KonanTarget $this$supports64BitAtomics) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$supports64BitAtomics, "$this$supports64BitAtomics");
        switch (KonanTargetExtenstionsKt$WhenMappings.$EnumSwitchMapping$2[$this$supports64BitAtomics.getArchitecture().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl && Intrinsics.areEqual($this$supports64BitAtomics, KonanTarget.WATCHOS_ARM64.INSTANCE) ^ true && Intrinsics.areEqual($this$supports64BitAtomics, KonanTarget.WATCHOS_X86.INSTANCE) ^ true;
    }

    public static final boolean supportsUnalignedAccess(@NotNull KonanTarget $this$supportsUnalignedAccess) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$supportsUnalignedAccess, "$this$supportsUnalignedAccess");
        switch (KonanTargetExtenstionsKt$WhenMappings.$EnumSwitchMapping$3[$this$supportsUnalignedAccess.getArchitecture().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl && Intrinsics.areEqual($this$supportsUnalignedAccess, KonanTarget.WATCHOS_ARM64.INSTANCE) ^ true;
    }

    public static final boolean needSmallBinary(@NotNull KonanTarget $this$needSmallBinary) {
        Intrinsics.checkNotNullParameter($this$needSmallBinary, "$this$needSmallBinary");
        return $this$needSmallBinary.getFamily() == Family.WATCHOS ? true : ($this$needSmallBinary.getFamily().isAppleFamily() ? $this$needSmallBinary.getArchitecture() == Architecture.ARM32 : false);
    }

    @NotNull
    public static final List<SanitizerKind> supportedSanitizers(@NotNull KonanTarget $this$supportedSanitizers) {
        Intrinsics.checkNotNullParameter($this$supportedSanitizers, "$this$supportedSanitizers");
        KonanTarget konanTarget = $this$supportedSanitizers;
        return konanTarget instanceof KonanTarget.LINUX_X64 ? CollectionsKt.listOf(SanitizerKind.ADDRESS) : (konanTarget instanceof KonanTarget.MACOS_X64 ? CollectionsKt.listOf(SanitizerKind.THREAD) : CollectionsKt.emptyList());
    }

    public static final boolean hasAddressDependencyInMemoryModel(@NotNull KonanTarget $this$hasAddressDependencyInMemoryModel) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$hasAddressDependencyInMemoryModel, "$this$hasAddressDependencyInMemoryModel");
        switch (KonanTargetExtenstionsKt$WhenMappings.$EnumSwitchMapping$4[$this$hasAddressDependencyInMemoryModel.getArchitecture().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean getSupportsGrandCentralDispatch(@NotNull KonanTarget $this$supportsGrandCentralDispatch) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$supportsGrandCentralDispatch, "$this$supportsGrandCentralDispatch");
        switch (KonanTargetExtenstionsKt$WhenMappings.$EnumSwitchMapping$5[$this$supportsGrandCentralDispatch.getFamily().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final List<String> customArgsForKonanSources(@NotNull KonanTarget $this$customArgsForKonanSources) {
        Intrinsics.checkNotNullParameter($this$customArgsForKonanSources, "$this$customArgsForKonanSources");
        KonanTarget konanTarget = $this$customArgsForKonanSources;
        return Intrinsics.areEqual(konanTarget, KonanTarget.WASM32.INSTANCE) ? CollectionsKt.listOf("KONAN_NO_FFI=1", "KONAN_INTERNAL_DLMALLOC=1", "KONAN_INTERNAL_SNPRINTF=1", "KONAN_INTERNAL_NOW=1", "KONAN_NO_CTORS_SECTION=1", "KONAN_NO_BACKTRACE=1", "KONAN_NO_EXTERNAL_CALLS_CHECKER=1") : (konanTarget instanceof KonanTarget.ZEPHYR ? CollectionsKt.listOf("KONAN_NO_FFI=1", "KONAN_NO_MATH=1", "KONAN_INTERNAL_SNPRINTF=1", "KONAN_INTERNAL_NOW=1", "KONAN_NO_CTORS_SECTION=1", "KONAN_NO_BACKTRACE=1") : CollectionsKt.emptyList());
    }
}

