/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.DiagnosticCollectorComponents;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.ControlFlowAnalysisDiagnosticComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.DeclarationCheckersDiagnosticComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.ErrorNodeDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.ExpressionCheckersDiagnosticComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.ReportCommitterDiagnosticComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.TypeCheckersDiagnosticComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/DiagnosticComponentsFactory;", "", "()V", "createAllDiagnosticComponents", "Lorg/jetbrains/kotlin/fir/analysis/collectors/DiagnosticCollectorComponents;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class DiagnosticComponentsFactory {
    @NotNull
    public static final DiagnosticComponentsFactory INSTANCE = new DiagnosticComponentsFactory();

    private DiagnosticComponentsFactory() {
    }

    @NotNull
    public final DiagnosticCollectorComponents createAllDiagnosticComponents(@NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        AbstractDiagnosticCollectorComponent[] abstractDiagnosticCollectorComponentArray = new AbstractDiagnosticCollectorComponent[]{new DeclarationCheckersDiagnosticComponent(session, reporter, null, 4, null), new ExpressionCheckersDiagnosticComponent(session, reporter, null, 4, null), new TypeCheckersDiagnosticComponent(session, reporter, null, 4, null), new ErrorNodeDiagnosticCollectorComponent(session, reporter), new ControlFlowAnalysisDiagnosticComponent(session, reporter, null, 4, null)};
        List<AbstractDiagnosticCollectorComponent> regularComponents = CollectionsKt.listOf(abstractDiagnosticCollectorComponentArray);
        return new DiagnosticCollectorComponents(regularComponents, new ReportCommitterDiagnosticComponent(session, reporter));
    }
}

