/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirPropertyInitializationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirPropertyInitializationChecker INSTANCE = new FirPropertyInitializationChecker();

    private FirPropertyInitializationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Set declaredLater = new LinkedHashSet();
        FirVisitorVoid visitor2 = new FirVisitorVoid(declaredLater, reporter, context){
            final /* synthetic */ Set<FirPropertySymbol> $declaredLater;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            {
                this.$declaredLater = $declaredLater;
                this.$reporter = $reporter;
                this.$context = $context;
            }

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                element.acceptChildren(this);
            }

            public void visitConstructor(@NotNull FirConstructor constructor2) {
                Intrinsics.checkNotNullParameter(constructor2, "constructor");
            }

            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
                Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            }

            public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor) {
                Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
            }

            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction2) {
                Intrinsics.checkNotNullParameter(anonymousFunction2, "anonymousFunction");
            }

            public void visitRegularClass(@NotNull FirRegularClass regularClass) {
                Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            }

            public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
                Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            }

            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment) {
                Intrinsics.checkNotNullParameter(variableAssignment, "variableAssignment");
                variableAssignment.acceptChildren(this);
                FirReference firReference = FirExpressionUtilKt.getCalleeReference(variableAssignment);
                FirCallableSymbol firCallableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
                FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol propertySymbol = firPropertySymbol;
                if (!this.$declaredLater.contains(propertySymbol)) {
                    return;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)variableAssignment.getLValue().getSource(), FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION(), (Object)propertySymbol, (DiagnosticContext)this.$context, null, 16, null);
            }
        };
        for (FirDeclaration member2 : CollectionsKt.asReversed(declaration.getDeclarations())) {
            if (!((Collection)declaredLater).isEmpty()) {
                member2.accept(visitor2);
            }
            if (!(member2 instanceof FirProperty)) continue;
            declaredLater.add(((FirProperty)member2).getSymbol());
        }
    }
}

