/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0011*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "jvm8builtInReplacements", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "coerceIfPossible", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "toType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceWithCallTo", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "replacement", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmBuiltInsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBuiltInsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltInsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class JvmBuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Map<Pair<String, String>, IrSimpleFunctionSymbol> jvm8builtInReplacements;

    public JvmBuiltInsLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        Pair[] pairArray = new Pair[]{TuplesKt.to(TuplesKt.to("kotlin.UInt", "compareTo"), this.context.getIr().getSymbols().getCompareUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "div"), this.context.getIr().getSymbols().getDivideUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "rem"), this.context.getIr().getSymbols().getRemainderUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "toString"), this.context.getIr().getSymbols().getToUnsignedStringInt()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "compareTo"), this.context.getIr().getSymbols().getCompareUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "div"), this.context.getIr().getSymbols().getDivideUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "rem"), this.context.getIr().getSymbols().getRemainderUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "toString"), this.context.getIr().getSymbols().getToUnsignedStringLong())};
        this.jvm8builtInReplacements = MapsKt.mapOf(pairArray);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformerVoidWithContext transformer2 = new IrElementTransformerVoidWithContext(this){
            final /* synthetic */ JvmBuiltInsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                expression2.transformChildren(this, null);
                IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                if (this.this$0.getContext().getState().getTarget().compareTo((Enum)JvmTarget.JVM_1_8) >= 0) {
                    IrSimpleFunctionSymbol jvm8Replacement;
                    String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(callee.getParent()).asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "callee.parent.fqNameForIrSerialization.asString()");
                    String parentClassName = string2;
                    String string3 = callee.getName().asString();
                    Intrinsics.checkNotNullExpressionValue(string3, "callee.name.asString()");
                    String functionName = string3;
                    if (Intrinsics.areEqual(parentClassName, "kotlin.CompareToKt") && Intrinsics.areEqual(functionName, "compareTo")) {
                        IrExpression irExpression2 = expression2.getValueArgument(0);
                        Intrinsics.checkNotNull(irExpression2);
                        IrType operandType = irExpression2.getType();
                        if (IrTypePredicatesKt.isUInt(operandType)) {
                            return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, this.this$0.getContext().getIr().getSymbols().getCompareUnsignedInt());
                        }
                        if (IrTypePredicatesKt.isULong(operandType)) {
                            return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, this.this$0.getContext().getIr().getSymbols().getCompareUnsignedLong());
                        }
                    }
                    if ((jvm8Replacement = (IrSimpleFunctionSymbol)JvmBuiltInsLowering.access$getJvm8builtInReplacements$p(this.this$0).get(TuplesKt.to(parentClassName, functionName))) != null) {
                        return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, jvm8Replacement);
                    }
                }
                if (VarargLoweringKt.isArrayOf(callee)) {
                    irExpression = expression2.getValueArgument(0);
                    if (irExpression == null) {
                        throw new AssertionError((Object)("Argument #0 expected: " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null)));
                    }
                } else if (VarargLoweringKt.isEmptyArray(callee)) {
                    JvmBackendContext jvmBackendContext = this.this$0.getContext();
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull(scopeWithIr);
                    irExpression = IrArrayBuilderKt.irArrayOf$default(JvmIrBuilderKt.createJvmIrBuilder(jvmBackendContext, scopeWithIr, (IrElement)expression2), expression2.getType(), null, 2, null);
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }
        };
        irFile.transformChildren(transformer2, null);
    }

    private final IrExpression replaceWithCallTo(IrCall $this$replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        IrExpression irExpression;
        IrExpression it;
        IrCallImpl irCallImpl;
        IrType expectedType = $this$replaceWithCallTo.getType();
        IrType intrinsicCallType = ((IrSimpleFunction)replacement.getOwner()).getReturnType();
        IrCallImpl newCall2 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$replaceWithCallTo.getStartOffset(), $this$replaceWithCallTo.getEndOffset(), intrinsicCallType, replacement, 0, 0, null, null, 240, null);
        boolean bl = false;
        Ref.IntRef valueArgumentOffset = new Ref.IntRef();
        IrExpression irExpression2 = $this$replaceWithCallTo.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl2 = false;
            if (!JvmBuiltInsLowering.replaceWithCallTo$lambda$2$tryToAddCoercedArgument(this, replacement, valueArgumentOffset, newCall2, it)) {
                return $this$replaceWithCallTo;
            }
        }
        IrExpression irExpression3 = $this$replaceWithCallTo.getDispatchReceiver();
        if (irExpression3 != null) {
            it = irExpression3;
            boolean bl3 = false;
            if (!JvmBuiltInsLowering.replaceWithCallTo$lambda$2$tryToAddCoercedArgument(this, replacement, valueArgumentOffset, newCall2, it)) {
                return $this$replaceWithCallTo;
            }
        }
        int n = $this$replaceWithCallTo.getValueArgumentsCount();
        for (int index2 = 0; index2 < n; ++index2) {
            IrExpression irExpression4 = $this$replaceWithCallTo.getValueArgument(index2);
            Intrinsics.checkNotNull(irExpression4);
            if (JvmBuiltInsLowering.replaceWithCallTo$lambda$2$tryToAddCoercedArgument(this, replacement, valueArgumentOffset, newCall2, irExpression4)) continue;
            return $this$replaceWithCallTo;
        }
        IrCallImpl intrinsicCall = irCallImpl;
        if (IrTypePredicatesKt.isInt(intrinsicCallType) || IrTypePredicatesKt.isLong(intrinsicCallType)) {
            irExpression = this.coerceIfPossible(intrinsicCall, expectedType);
            if (irExpression == null) {
                throw new AssertionError((Object)("Can't coerce '" + RenderIrElementKt.render(intrinsicCallType) + "' to '" + RenderIrElementKt.render(expectedType) + '\''));
            }
        } else {
            irExpression = intrinsicCall;
        }
        return irExpression;
    }

    private final IrExpression coerceIfPossible(IrExpression $this$coerceIfPossible, IrType toType) {
        IrExpression irExpression;
        Type toJvmType;
        Type fromJvmType = IrTypeMapper.mapType$default(this.context.getDefaultTypeMapper(), $this$coerceIfPossible.getType(), null, null, false, 14, null);
        if (!Intrinsics.areEqual(fromJvmType, toJvmType = IrTypeMapper.mapType$default(this.context.getDefaultTypeMapper(), toType, null, null, false, 14, null))) {
            irExpression = null;
        } else {
            IrCallImpl irCallImpl;
            IrCallImpl call2 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$coerceIfPossible.getStartOffset(), $this$coerceIfPossible.getEndOffset(), toType, this.context.getIr().getSymbols().getUnsafeCoerceIntrinsic(), 0, 0, null, null, 240, null);
            boolean bl = false;
            call2.putTypeArgument(0, $this$coerceIfPossible.getType());
            call2.putTypeArgument(1, toType);
            call2.putValueArgument(0, $this$coerceIfPossible);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    private static final boolean replaceWithCallTo$lambda$2$tryToAddCoercedArgument(JvmBuiltInsLowering this$0, IrSimpleFunctionSymbol $replacement, Ref.IntRef valueArgumentOffset, IrCallImpl $newCall, IrExpression expr) {
        IrExpression irExpression = this$0.coerceIfPossible(expr, ((IrSimpleFunction)$replacement.getOwner()).getValueParameters().get(valueArgumentOffset.element).getType());
        if (irExpression == null) {
            return false;
        }
        IrExpression coercedExpr = irExpression;
        int n = valueArgumentOffset.element;
        valueArgumentOffset.element = n + 1;
        $newCall.putValueArgument(n, coercedExpr);
        return true;
    }

    public static final /* synthetic */ IrExpression access$replaceWithCallTo(JvmBuiltInsLowering $this, IrCall $receiver, IrSimpleFunctionSymbol replacement) {
        return $this.replaceWithCallTo($receiver, replacement);
    }

    public static final /* synthetic */ Map access$getJvm8builtInReplacements$p(JvmBuiltInsLowering $this) {
        return $this.jvm8builtInReplacements;
    }
}

