/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\b\u0000\u0018\u0000 E2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001EB\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB-\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rB5\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0013J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020,J\u0006\u00107\u001a\u00020\fJ\u0006\u00108\u001a\u00020\fJ\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0005J\b\u0010<\u001a\u000205H\u0002J\u0012\u0010=\u001a\u0002052\b\u0010>\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0011H\u0016J\u0012\u0010B\u001a\u0002052\b\u0010C\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010D\u001a\u00020\fH\u0016R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010$\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010%j\u0004\u0018\u0001`&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001d\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "exception", "stackTrace", "", "", "(Ljava/lang/Throwable;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/Map;Ljava/util/List;)V", "cause", "getCause", "()Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "causeProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exceptionFqName", "exceptionHierarchy", "", "getFields", "()Ljava/util/Map;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "message", "getMessage", "()Ljava/lang/String;", "messageProperty", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "superWrapperClass", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "upValues", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getUpValues", "copyFieldsFrom", "", "wrapper", "getFullDescription", "getShortDescription", "isSubtypeOf", "", "ancestor", "recalculateCauseAndMessage", "setCause", "causeValue", "setField", "symbol", "state", "setMessage", "messageValue", "toString", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nExceptionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1313#2,2:156\n1#3:158\n1747#4,3:159\n*S KotlinDebug\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState\n*L\n55#1:156,2\n81#1:159,3\n*E\n"})
public final class ExceptionState
extends Throwable
implements Complex,
StateWithClosure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @NotNull
    private final Map<IrSymbol, Variable> upValues;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;
    private String exceptionFqName;
    @NotNull
    private final List<String> exceptionHierarchy;
    @NotNull
    private final IrProperty messageProperty;
    @NotNull
    private final IrProperty causeProperty;
    @NotNull
    private final List<String> stackTrace;

    private ExceptionState(IrClass irClass2, Map<IrSymbol, State> fields2, List<String> stackTrace) {
        this.irClass = irClass2;
        this.fields = fields2;
        this.upValues = new LinkedHashMap();
        this.exceptionHierarchy = new ArrayList();
        this.messageProperty = UtilsKt.getOriginalPropertyByName(this.getIrClass(), "message");
        this.causeProperty = UtilsKt.getOriginalPropertyByName(this.getIrClass(), "cause");
        this.stackTrace = CollectionsKt.reversed((Iterable)stackTrace);
        if (this.exceptionFqName == null) {
            this.exceptionFqName = this.irClassFqName();
        }
        if (!this.getFields().containsKey(this.messageProperty.getSymbol())) {
            this.setMessage(null);
        }
        if (!this.getFields().containsKey(this.causeProperty.getSymbol())) {
            this.setCause(null);
        }
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public Map<IrSymbol, Variable> getUpValues() {
        return this.upValues;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    @Override
    @Nullable
    public String getMessage() {
        State state = this.getField(this.messageProperty.getSymbol());
        return state != null ? StateKt.asStringOrNull(state) : null;
    }

    @Override
    @Nullable
    public ExceptionState getCause() {
        State state = this.getField(this.causeProperty.getSymbol());
        return state instanceof ExceptionState ? (ExceptionState)state : null;
    }

    public ExceptionState(@NotNull IrClass irClass2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(environment, "environment");
        this(irClass2, new LinkedHashMap(), environment.getCallStack$ir_interpreter().getStackTrace());
    }

    public ExceptionState(@NotNull Throwable exception, @NotNull IrClass irClass2, @NotNull List<String> stackTrace, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(exception, "exception");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(stackTrace, "stackTrace");
        Intrinsics.checkNotNullParameter(environment, "environment");
        this(irClass2, ExceptionState.Companion.evaluateFields(exception, irClass2, environment), CollectionsKt.plus((Collection)stackTrace, (Iterable)ExceptionState.Companion.evaluateAdditionalStackTrace(exception, environment)));
        this.setCause(null);
        if (!Intrinsics.areEqual(irClass2.getName().asString(), exception.getClass().getSimpleName())) {
            String string2 = exception.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string2, "exception::class.java.name");
            this.exceptionFqName = string2;
            Collection collection = this.exceptionHierarchy;
            String string3 = this.exceptionFqName;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string3 = null;
            }
            collection.add(string3);
            Sequence<Class<?>> $this$forEach$iv = SequencesKt.generateSequence(exception.getClass().getSuperclass(), (Function1)1.INSTANCE);
            boolean $i$f$forEach = false;
            Iterator<Class<?>> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Class<?> element$iv;
                Class<?> it = element$iv = iterator2.next();
                boolean bl = false;
                ((Collection)this.exceptionHierarchy).add(it.getName());
            }
            this.exceptionHierarchy.remove(CollectionsKt.getLastIndex(this.exceptionHierarchy));
        }
    }

    public final void copyFieldsFrom(@NotNull Wrapper wrapper) {
        block0: {
            Intrinsics.checkNotNullParameter(wrapper, "wrapper");
            Object object = wrapper.getValue();
            Throwable throwable = object instanceof Throwable ? (Throwable)object : null;
            if (throwable == null) break block0;
            Throwable it = throwable;
            boolean bl = false;
            this.setMessage(it.getMessage());
            Throwable throwable2 = it.getCause();
            this.setCause(throwable2 instanceof ExceptionState ? (ExceptionState)throwable2 : null);
        }
    }

    @Override
    public void setField(@NotNull IrSymbol symbol2, @NotNull State state) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(state, "state");
        Complex.super.setField(symbol2, state);
        this.recalculateCauseAndMessage();
    }

    /*
     * WARNING - void declaration
     */
    private final void recalculateCauseAndMessage() {
        block4: {
            String string2;
            StringBuilder stringBuilder2;
            block6: {
                block5: {
                    void it;
                    if (this.getMessage() != null || this.getCause() == null) break block4;
                    StringBuilder stringBuilder3 = new StringBuilder();
                    ExceptionState exceptionState = this.getCause();
                    Intrinsics.checkNotNull(exceptionState);
                    String string3 = exceptionState.exceptionFqName;
                    if (string3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                        string3 = null;
                    }
                    stringBuilder2 = stringBuilder3.append(string3);
                    ExceptionState exceptionState2 = this.getCause();
                    Intrinsics.checkNotNull(exceptionState2);
                    string2 = exceptionState2.getMessage();
                    if (string2 == null) break block5;
                    String string4 = string2;
                    StringBuilder stringBuilder4 = stringBuilder2;
                    boolean bl = false;
                    String string5 = ": " + (String)it;
                    stringBuilder2 = stringBuilder4;
                    string2 = string5;
                    if (string5 != null) break block6;
                }
                string2 = "";
            }
            String causeMessage = stringBuilder2.append(string2).toString();
            this.setMessage(causeMessage);
        }
    }

    public final boolean isSubtypeOf(@NotNull IrClass ancestor) {
        Intrinsics.checkNotNullParameter(ancestor, "ancestor");
        if (!((Collection)this.exceptionHierarchy).isEmpty()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.exceptionHierarchy;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        CharSequence charSequence2 = it;
                        String string2 = ancestor.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string2, "ancestor.name.asString()");
                        if (!StringsKt.contains$default(charSequence2, string2, false, 2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return IrUtilsKt.isSubclassOf(this.getIrClass(), ancestor);
    }

    private final void setMessage(String messageValue) {
        IrSymbol irSymbol2 = this.messageProperty.getSymbol();
        IrSimpleFunction irSimpleFunction = this.messageProperty.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        this.setField(irSymbol2, new Primitive<String>(messageValue, irSimpleFunction.getReturnType()));
    }

    private final void setCause(State causeValue) {
        IrSymbol irSymbol2 = this.causeProperty.getSymbol();
        State state = causeValue;
        if (state == null) {
            IrSimpleFunction irSimpleFunction = this.causeProperty.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction);
            state = Primitive.Companion.nullStateOfType(irSimpleFunction.getReturnType());
        }
        this.setField(irSymbol2, state);
    }

    @NotNull
    public final String getShortDescription() {
        String it = this.getMessage();
        boolean bl = false;
        String string2 = it;
        return (string2 != null ? ((CharSequence)string2).length() > 0 : false) ? it : "???";
    }

    @NotNull
    public final String getFullDescription() {
        String it = this.getMessage();
        boolean bl = false;
        String string2 = it;
        String message2 = (string2 != null ? ((CharSequence)string2).length() > 0 : false) ? ": " + it : "";
        String prefix = !((Collection)this.stackTrace).isEmpty() ? "\n\t" : "";
        String postfix = this.stackTrace.size() > 10 ? "\n\t..." : "";
        Object object = this.getCause();
        if (object == null || (object = ((ExceptionState)object).getFullDescription()) == null || (object = StringsKt.replaceFirst$default((String)object, "Exception ", "\nCaused by: ", false, 4, null)) == null) {
            object = "";
        }
        Object causeMessage = object;
        StringBuilder stringBuilder2 = new StringBuilder().append("Exception ");
        String string3 = this.exceptionFqName;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
            string3 = null;
        }
        return stringBuilder2.append(string3).append(message2).append(CollectionsKt.joinToString$default(this.stackTrace.subList(0, Math.min(this.stackTrace.size(), 10)), "\n\t", prefix, postfix, 0, null, null, 56, null)).append((String)causeMessage).toString();
    }

    @Override
    @NotNull
    public String toString() {
        String string2;
        block6: {
            block5: {
                string2 = this.getMessage();
                if (string2 == null) break block5;
                String it = string2;
                boolean bl = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                String string3 = this.exceptionFqName;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                    string3 = null;
                }
                String string4 = stringBuilder2.append(string3).append(": ").append(it).toString();
                string2 = string4;
                if (string4 != null) break block6;
            }
            if ((string2 = this.exceptionFqName) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string2 = null;
            }
        }
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion;", "", "()V", "evaluateAdditionalStackTrace", "", "", "e", "", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "evaluateFields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "exception", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nExceptionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,155:1\n1549#2:156\n1620#2,3:157\n1549#2:163\n1620#2,3:164\n1#3:160\n12474#4,2:161\n*S KotlinDebug\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion\n*L\n119#1:156\n119#1:157,3\n130#1:163\n130#1:164,3\n127#1:161,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<IrSymbol, State> evaluateFields(Throwable exception, IrClass irClass2, IrInterpreterEnvironment environment) {
            Map<IrSymbol, State> map;
            block7: {
                Pair<IrPropertySymbol, Primitive<String>> messageVar;
                block6: {
                    Map<IrSymbol, State> causeVar;
                    Object object;
                    Object object2;
                    Throwable it;
                    List<String> stackTrace = environment.getCallStack$ir_interpreter().getStackTrace();
                    IrProperty messageProperty = UtilsKt.getOriginalPropertyByName(irClass2, "message");
                    IrProperty causeProperty = UtilsKt.getOriginalPropertyByName(irClass2, "cause");
                    IrPropertySymbol irPropertySymbol = messageProperty.getSymbol();
                    String string2 = exception.getMessage();
                    IrSimpleFunction irSimpleFunction = messageProperty.getGetter();
                    Intrinsics.checkNotNull(irSimpleFunction);
                    messageVar = TuplesKt.to(irPropertySymbol, new Primitive<String>(string2, irSimpleFunction.getReturnType()));
                    Throwable throwable = exception.getCause();
                    if (throwable != null) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        it = throwable;
                        boolean bl = false;
                        IrPropertySymbol irPropertySymbol2 = causeProperty.getSymbol();
                        Collection collection2 = stackTrace;
                        StackTraceElement[] stackTraceElementArray = it.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "it.stackTrace");
                        object2 = ArraysKt.reversed((Object[])stackTraceElementArray);
                        Collection collection3 = collection2;
                        IrClass irClass3 = irClass2;
                        Throwable throwable2 = it;
                        IrPropertySymbol irPropertySymbol3 = irPropertySymbol2;
                        boolean $i$f$map = false;
                        void var18_16 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add("at " + it2);
                        }
                        collection = (List)destination$iv$iv;
                        IrInterpreterEnvironment irInterpreterEnvironment = environment;
                        List<String> list2 = CollectionsKt.plus(collection3, (Iterable)collection);
                        IrClass irClass4 = irClass3;
                        Throwable throwable3 = throwable2;
                        object = TuplesKt.to(irPropertySymbol3, new ExceptionState(throwable3, irClass4, list2, irInterpreterEnvironment));
                    } else {
                        object = null;
                    }
                    if ((map = (causeVar = object)) == null) break block6;
                    it = map;
                    boolean bl = false;
                    object2 = new Pair[]{messageVar, it};
                    Map map2 = MapsKt.mutableMapOf(object2);
                    map = map2;
                    if (map2 != null) break block7;
                }
                Pair[] pairArray = new Pair[]{messageVar};
                map = MapsKt.mutableMapOf(pairArray);
            }
            return map;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> evaluateAdditionalStackTrace(Throwable e, IrInterpreterEnvironment environment) {
            boolean bl;
            Object it;
            int $i$f$any;
            Object[] $this$any$iv;
            List additionalStack;
            block7: {
                additionalStack = new ArrayList();
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
                $this$any$iv = stackTraceElementArray;
                $i$f$any = 0;
                for (Object element$iv : $this$any$iv) {
                    it = (StackTraceElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((StackTraceElement)it).getClassName(), "java.lang.invoke.MethodHandle")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl) {
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
                $this$any$iv = stackTraceElementArray;
                int n = $this$any$iv.length;
                for ($i$f$any = 0; $i$f$any < n; ++$i$f$any) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    int index2 = $i$f$any;
                    Object stackTraceElement = $this$any$iv[$i$f$any];
                    if (!Intrinsics.areEqual(((StackTraceElement)stackTraceElement).getMethodName(), "invokeWithArguments")) continue;
                    StackTraceElement[] stackTraceElementArray2 = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue(stackTraceElementArray2, "e.stackTrace");
                    it = CollectionsKt.reversed((Iterable)ArraysKt.slice((Object[])stackTraceElementArray2, RangesKt.until(0, index2)));
                    List list2 = additionalStack;
                    boolean $i$f$map = false;
                    void var11_19 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        StackTraceElement stackTraceElement2 = (StackTraceElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add("at " + it2);
                    }
                    list2.addAll((List)destination$iv$iv);
                    break;
                }
                StackTraceElement[] stackTraceElementArray3 = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray3, "e.stackTrace");
                StackTraceElement it3 = (StackTraceElement)ArraysKt.first((Object[])stackTraceElementArray3);
                boolean bl4 = false;
                String lastNeededValue = it3.getClassName() + '.' + it3.getMethodName();
                block3: for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    StackTraceElement[] stackTraceElementArray4;
                    Intrinsics.checkNotNullExpressionValue(cause.getStackTrace(), "cause.stackTrace");
                    int n2 = stackTraceElementArray4.length;
                    for (int i = 0; i < n2; ++i) {
                        StackTraceElement causeStackTraceElement;
                        int causeStackIndex = i;
                        StackTraceElement it4 = causeStackTraceElement = stackTraceElementArray4[i];
                        boolean bl5 = false;
                        String currentStackTraceValue = it4.getClassName() + '.' + it4.getMethodName();
                        if (!Intrinsics.areEqual(currentStackTraceValue, lastNeededValue)) continue;
                        StackTraceElement[] stackTraceElementArray5 = cause.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray5, "cause.stackTrace");
                        cause.setStackTrace((StackTraceElement[])ArraysKt.reversedArray(ArraysKt.sliceArray((Object[])stackTraceElementArray5, RangesKt.until(0, causeStackIndex))));
                        continue block3;
                    }
                }
            }
            if (environment.getConfiguration().getCollapseStackTraceFromJDK() && !((Collection)additionalStack).isEmpty()) {
                return CollectionsKt.listOf("at <JDK>");
            }
            return additionalStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

