/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterInQualifiedAccess;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0013H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "()V", "typeParameterFromError", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getTypeParameterFromError", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isKClassTypeWithErrorOrNullableArgument", "", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "checkers"})
public final class FirKClassWithIncorrectTypeArgumentChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirKClassWithIncorrectTypeArgumentChecker INSTANCE = new FirKClassWithIncorrectTypeArgumentChecker();

    private FirKClassWithIncorrectTypeArgumentChecker() {
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block4: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (context.getContainingDeclarations().size() > 1) {
                return;
            }
            KtSourceElement ktSourceElement = declaration.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            if (source.getKind() instanceof KtFakeSourceElementKind) {
                return;
            }
            ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef());
            if (!this.isKClassTypeWithErrorOrNullableArgument(returnType2, TypeComponentsKt.getTypeContext(context.getSession()))) {
                return;
            }
            ConeTypeProjection coneTypeProjection = returnType2.getTypeArguments()[0];
            Intrinsics.checkNotNull(coneTypeProjection, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection");
            ConeKotlinType typeArgument = ((ConeKotlinTypeProjection)coneTypeProjection).getType();
            FirTypeParameterSymbol firTypeParameterSymbol = this.getTypeParameterFromError(typeArgument);
            if (firTypeParameterSymbol == null) break block4;
            FirTypeParameterSymbol it = firTypeParameterSymbol;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getKCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE(), (Object)it, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final boolean isKClassTypeWithErrorOrNullableArgument(ConeKotlinType $this$isKClassTypeWithErrorOrNullableArgument, ConeInferenceContext context) {
        ConeTypeProjection coneTypeProjection;
        block10: {
            block9: {
                ConeKotlinType coneKotlinType;
                if (!InferenceUtilsKt.isKClassType($this$isKClassTypeWithErrorOrNullableArgument)) {
                    return false;
                }
                coneTypeProjection = CollectionsKt.singleOrNull(ArraysKt.toList($this$isKClassTypeWithErrorOrNullableArgument.getTypeArguments()));
                if (coneTypeProjection == null) break block9;
                ConeTypeProjection it = coneTypeProjection;
                boolean bl = false;
                ConeTypeProjection coneTypeProjection2 = it;
                if (coneTypeProjection2 instanceof ConeStarProjection) {
                    coneKotlinType = null;
                } else if (coneTypeProjection2 instanceof ConeKotlinTypeProjection) {
                    coneKotlinType = ((ConeKotlinTypeProjection)it).getType();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                coneTypeProjection = coneKotlinType;
                if (coneKotlinType != null) break block10;
            }
            return false;
        }
        ConeTypeProjection argumentType = coneTypeProjection;
        ConeInferenceContext $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u243 = context;
        boolean bl = false;
        FirTypeParameterSymbol firTypeParameterSymbol = INSTANCE.getTypeParameterFromError((ConeKotlinType)argumentType);
        if (firTypeParameterSymbol != null) {
            FirTypeParameterSymbol typeParameterSymbol = firTypeParameterSymbol;
            boolean bl2 = false;
            return $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u243.isNullableType(FirNestedClassifierScopeKt.toConeType(typeParameterSymbol));
        }
        return argumentType instanceof ConeErrorType || $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u243.isNullableType((KotlinTypeMarker)((Object)argumentType));
    }

    private final FirTypeParameterSymbol getTypeParameterFromError(ConeKotlinType $this$typeParameterFromError) {
        ConeErrorType coneErrorType = $this$typeParameterFromError instanceof ConeErrorType ? (ConeErrorType)$this$typeParameterFromError : null;
        ConeDiagnostic coneDiagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess = coneDiagnostic instanceof ConeTypeParameterInQualifiedAccess ? (ConeTypeParameterInQualifiedAccess)coneDiagnostic : null;
        return coneTypeParameterInQualifiedAccess != null ? coneTypeParameterInQualifiedAccess.getSymbol() : null;
    }
}

