/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.deserialization.AbstractFirDeserializedSymbolProvider;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.deserialization.PackagePartsCacheData;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmFlags;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0013H\u0014J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014R9\u0010\r\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/OptionalAnnotationClassesProvider;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleDataProvider", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "packagePartProvider", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "defaultDeserializationOrigin", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;)V", "optionalAnnotationClassesAndPackages", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "", "Lorg/jetbrains/kotlin/name/FqName;", "getOptionalAnnotationClassesAndPackages", "()Lkotlin/Pair;", "optionalAnnotationClassesAndPackages$delegate", "Lkotlin/Lazy;", "getPackagePartProvider", "()Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "computePackagePartsInfos", "", "Lorg/jetbrains/kotlin/fir/deserialization/PackagePartsCacheData;", "packageFqName", "extractClassMetadata", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolProvider$ClassMetadataFindResult;", "classId", "parentContext", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "getPackage", "fqName", "isNewPlaceForBodyGeneration", "", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "java"})
public final class OptionalAnnotationClassesProvider
extends AbstractFirDeserializedSymbolProvider {
    @NotNull
    private final PackagePartProvider packagePartProvider;
    @NotNull
    private final Lazy optionalAnnotationClassesAndPackages$delegate;

    public OptionalAnnotationClassesProvider(@NotNull FirSession session2, @NotNull ModuleDataProvider moduleDataProvider, @NotNull FirKotlinScopeProvider kotlinScopeProvider, @NotNull PackagePartProvider packagePartProvider, @NotNull FirDeclarationOrigin defaultDeserializationOrigin) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(moduleDataProvider, "moduleDataProvider");
        Intrinsics.checkNotNullParameter(kotlinScopeProvider, "kotlinScopeProvider");
        Intrinsics.checkNotNullParameter(packagePartProvider, "packagePartProvider");
        Intrinsics.checkNotNullParameter(defaultDeserializationOrigin, "defaultDeserializationOrigin");
        super(session2, moduleDataProvider, kotlinScopeProvider, defaultDeserializationOrigin, BuiltInSerializerProtocol.INSTANCE);
        this.packagePartProvider = packagePartProvider;
        this.optionalAnnotationClassesAndPackages$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<Pair<? extends Map<ClassId, ClassData>, ? extends Set<FqName>>>(this){
            final /* synthetic */ OptionalAnnotationClassesProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Pair<Map<ClassId, ClassData>, Set<FqName>> invoke() {
                Map optionalAnnotationClasses = new LinkedHashMap<K, V>();
                Set optionalAnnotationPackages = new LinkedHashSet<E>();
                for (ClassData klass : this.this$0.getPackagePartProvider().getAllOptionalAnnotationClasses()) {
                    ClassId classId = NameResolverUtilKt.getClassId(klass.getNameResolver(), klass.getClassProto().getFqName());
                    optionalAnnotationClasses.put(classId, klass);
                    FqName fqName2 = classId.getPackageFqName();
                    Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
                    optionalAnnotationPackages.add(fqName2);
                }
                return new Pair<Map<ClassId, ClassData>, Set<FqName>>(optionalAnnotationClasses, optionalAnnotationPackages);
            }
        });
    }

    public /* synthetic */ OptionalAnnotationClassesProvider(FirSession firSession, ModuleDataProvider moduleDataProvider, FirKotlinScopeProvider firKotlinScopeProvider, PackagePartProvider packagePartProvider, FirDeclarationOrigin firDeclarationOrigin, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            firDeclarationOrigin = FirDeclarationOrigin.Library.INSTANCE;
        }
        this(firSession, moduleDataProvider, firKotlinScopeProvider, packagePartProvider, firDeclarationOrigin);
    }

    @NotNull
    public final PackagePartProvider getPackagePartProvider() {
        return this.packagePartProvider;
    }

    private final Pair<Map<ClassId, ClassData>, Set<FqName>> getOptionalAnnotationClassesAndPackages() {
        Lazy lazy = this.optionalAnnotationClassesAndPackages$delegate;
        return (Pair)lazy.getValue();
    }

    @Override
    @NotNull
    protected List<PackagePartsCacheData> computePackagePartsInfos(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    protected AbstractFirDeserializedSymbolProvider.ClassMetadataFindResult extractClassMetadata(@NotNull ClassId classId, @Nullable FirDeserializationContext parentContext) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        ClassData classData = this.getOptionalAnnotationClassesAndPackages().getFirst().get(classId);
        if (classData == null) {
            return null;
        }
        ClassData optionalAnnotationClass = classData;
        return new AbstractFirDeserializedSymbolProvider.ClassMetadataFindResult.Metadata(optionalAnnotationClass.getNameResolver(), optionalAnnotationClass.getClassProto(), null, (FirModuleData)CollectionsKt.last((Iterable)this.getModuleDataProvider().getAllModuleData()), null, null);
    }

    @Override
    protected boolean isNewPlaceForBodyGeneration(@NotNull ProtoBuf.Class classProto) {
        Intrinsics.checkNotNullParameter(classProto, "classProto");
        Flags.BooleanFlagField booleanFlagField = JvmFlags.INSTANCE.getIS_COMPILED_IN_JVM_DEFAULT_MODE();
        Integer n = classProto.getExtension(JvmProtoBuf.jvmClassFlags);
        Intrinsics.checkNotNullExpressionValue(n, "classProto.getExtension(JvmProtoBuf.jvmClassFlags)");
        Boolean bl = booleanFlagField.get(((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue(bl, "JvmFlags.IS_COMPILED_IN_\u2026mProtoBuf.jvmClassFlags))");
        return bl;
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return this.getOptionalAnnotationClassesAndPackages().getSecond().contains(fqName2) ? fqName2 : null;
    }
}

