/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jvm.abi.JvmAbiMetadataProcessorKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.Flag;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClass;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmPackage;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.JvmExtensionsKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.JvmMetadataUtil;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\u001c\u0010\b\u001a\u00020\u00012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u001a\f\u0010\r\u001a\u00020\f*\u00020\u000eH\u0002\u001a\f\u0010\r\u001a\u00020\f*\u00020\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\f*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"abiMetadataProcessor", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "annotationVisitor", "isPrivateDeclaration", "", "flags", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/Flags;", "kotlinClassHeaderVisitor", "body", "Lkotlin/Function1;", "Lkotlin/Metadata;", "", "removePrivateDeclarations", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmClass;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmPackage;", "visitKotlinMetadata", "header", "jvm-abi-gen"})
@SourceDebugExtension(value={"SMAP\nJvmAbiMetadataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n13579#2,2:155\n13579#2,2:157\n*S KotlinDebug\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n*L\n115#1:155,2\n121#1:157,2\n*E\n"})
public final class JvmAbiMetadataProcessorKt {
    @NotNull
    public static final AnnotationVisitor abiMetadataProcessor(@NotNull AnnotationVisitor annotationVisitor) {
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"annotationVisitor");
        return JvmAbiMetadataProcessorKt.kotlinClassHeaderVisitor((Function1<? super Metadata, Unit>)((Function1)new Function1<Metadata, Unit>(annotationVisitor){
            final /* synthetic */ AnnotationVisitor $annotationVisitor;
            {
                this.$annotationVisitor = $annotationVisitor;
                super(1);
            }

            public final void invoke(@NotNull Metadata header) {
                KmPackage pkg;
                Metadata metadata;
                KotlinClassMetadata metadata2;
                int[] metadataVersion;
                int[] nArray;
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                int[] v = nArray = header.mv();
                boolean bl = false;
                Integer n = ArraysKt.getOrNull((int[])v, (int)0);
                int major = n != null ? n : 0;
                Integer n2 = ArraysKt.getOrNull((int[])v, (int)1);
                int minor = n2 != null ? n2 : 0;
                int[] nArray2 = (int[])(major > 1 || major == 1 && minor >= 4 ? nArray : null);
                if (nArray2 == null) {
                    nArray = new int[]{1, 4};
                    nArray2 = metadataVersion = nArray;
                }
                if ((metadata2 = KotlinClassMetadata.Companion.read(header)) instanceof KotlinClassMetadata.Class) {
                    KmClass klass = ((KotlinClassMetadata.Class)metadata2).toKmClass();
                    JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(klass);
                    metadata = KotlinClassMetadata.Companion.writeClass(klass, metadataVersion, header.xi()).getAnnotationData();
                } else if (metadata2 instanceof KotlinClassMetadata.FileFacade) {
                    pkg = ((KotlinClassMetadata.FileFacade)metadata2).toKmPackage();
                    JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(pkg);
                    metadata = KotlinClassMetadata.Companion.writeFileFacade(pkg, metadataVersion, header.xi()).getAnnotationData();
                } else if (metadata2 instanceof KotlinClassMetadata.MultiFileClassPart) {
                    pkg = ((KotlinClassMetadata.MultiFileClassPart)metadata2).toKmPackage();
                    JvmAbiMetadataProcessorKt.access$removePrivateDeclarations(pkg);
                    metadata = KotlinClassMetadata.Companion.writeMultiFileClassPart(pkg, ((KotlinClassMetadata.MultiFileClassPart)metadata2).getFacadeClassName(), metadataVersion, header.xi()).getAnnotationData();
                } else {
                    metadata = header;
                }
                Metadata newHeader = metadata;
                JvmAbiMetadataProcessorKt.access$visitKotlinMetadata(this.$annotationVisitor, newHeader);
            }
        }));
    }

    private static final AnnotationVisitor kotlinClassHeaderVisitor(Function1<? super Metadata, Unit> body) {
        return new AnnotationVisitor(body){
            private int kind;
            @NotNull
            private int[] metadataVersion;
            @NotNull
            private List<String> data1;
            @NotNull
            private List<String> data2;
            @Nullable
            private String extraString;
            @Nullable
            private String packageName;
            private int extraInt;
            final /* synthetic */ Function1<Metadata, Unit> $body;
            {
                this.$body = $body;
                super(589824);
                this.kind = 1;
                this.metadataVersion = new int[0];
                this.data1 = new ArrayList<E>();
                this.data2 = new ArrayList<E>();
            }

            public final int getKind() {
                return this.kind;
            }

            public final void setKind(int n) {
                this.kind = n;
            }

            @NotNull
            public final int[] getMetadataVersion() {
                return this.metadataVersion;
            }

            public final void setMetadataVersion(@NotNull int[] nArray) {
                Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
                this.metadataVersion = nArray;
            }

            @NotNull
            public final List<String> getData1() {
                return this.data1;
            }

            public final void setData1(@NotNull List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data1 = list;
            }

            @NotNull
            public final List<String> getData2() {
                return this.data2;
            }

            public final void setData2(@NotNull List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data2 = list;
            }

            @Nullable
            public final String getExtraString() {
                return this.extraString;
            }

            public final void setExtraString(@Nullable String string) {
                this.extraString = string;
            }

            @Nullable
            public final String getPackageName() {
                return this.packageName;
            }

            public final void setPackageName(@Nullable String string) {
                this.packageName = string;
            }

            public final int getExtraInt() {
                return this.extraInt;
            }

            public final void setExtraInt(int n) {
                this.extraInt = n;
            }

            public void visit(@NotNull String name, @Nullable Object value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                switch (name) {
                    case "k": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.kind = (Integer)value;
                        break;
                    }
                    case "xi": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.extraInt = (Integer)value;
                        break;
                    }
                    case "mv": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.IntArray");
                        this.metadataVersion = (int[])value;
                        break;
                    }
                    case "xs": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.extraString = (String)value;
                        break;
                    }
                    case "pn": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.packageName = (String)value;
                    }
                }
            }

            @Nullable
            public AnnotationVisitor visitArray(@NotNull String name) {
                List<String> list;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"d1")) {
                    list = this.data1;
                } else if (Intrinsics.areEqual((Object)string, (Object)"d2")) {
                    list = this.data2;
                } else {
                    return null;
                }
                List<String> destination = list;
                return new AnnotationVisitor(destination){
                    final /* synthetic */ List<String> $destination;
                    {
                        this.$destination = $destination;
                        super(589824);
                    }

                    public void visit(@Nullable String name, @Nullable Object value) {
                        Collection collection = this.$destination;
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)value);
                    }
                };
            }

            public void visitEnd() {
                Collection $this$toTypedArray$iv = this.data1;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = this.data2;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                this.$body.invoke((Object)JvmMetadataUtil.Metadata(this.kind, this.metadataVersion, thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), this.extraString, this.packageName, this.extraInt));
            }
        };
    }

    private static final void visitKotlinMetadata(AnnotationVisitor $this$visitKotlinMetadata, Metadata header) {
        String it;
        String element$iv;
        int n;
        int n2;
        boolean $i$f$forEach;
        String[] $this$forEach$iv;
        AnnotationVisitor annotationVisitor;
        $this$visitKotlinMetadata.visit("k", (Object)header.k());
        $this$visitKotlinMetadata.visit("mv", (Object)header.mv());
        if (!(header.d1().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u241 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d1");
            boolean bl = false;
            $this$forEach$iv = header.d1();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl2 = false;
                $this$visitKotlinMetadata_u24lambda_u241.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u241.visitEnd();
        }
        if (!(header.d2().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u243 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d2");
            boolean bl = false;
            $this$forEach$iv = header.d2();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl3 = false;
                $this$visitKotlinMetadata_u24lambda_u243.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u243.visitEnd();
        }
        if (((CharSequence)header.xs()).length() > 0) {
            $this$visitKotlinMetadata.visit("xs", (Object)header.xs());
        }
        if (((CharSequence)header.pn()).length() > 0) {
            $this$visitKotlinMetadata.visit("pn", (Object)header.pn());
        }
        if (header.xi() != 0) {
            $this$visitKotlinMetadata.visit("xi", (Object)header.xi());
        }
        $this$visitKotlinMetadata.visitEnd();
    }

    private static final void removePrivateDeclarations(KmClass $this$removePrivateDeclarations) {
        $this$removePrivateDeclarations.getConstructors().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$4(removePrivateDeclarations.1.INSTANCE, arg_0));
        $this$removePrivateDeclarations.getFunctions().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$5(removePrivateDeclarations.2.INSTANCE, arg_0));
        $this$removePrivateDeclarations.getProperties().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$6(removePrivateDeclarations.3.INSTANCE, arg_0));
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final void removePrivateDeclarations(KmPackage $this$removePrivateDeclarations) {
        $this$removePrivateDeclarations.getFunctions().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$7(removePrivateDeclarations.4.INSTANCE, arg_0));
        $this$removePrivateDeclarations.getProperties().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$8(removePrivateDeclarations.5.INSTANCE, arg_0));
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final boolean isPrivateDeclaration(int flags) {
        return Flag.IS_PRIVATE.invoke(flags) || Flag.IS_PRIVATE_TO_THIS.invoke(flags) || Flag.IS_LOCAL.invoke(flags);
    }

    private static final boolean removePrivateDeclarations$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$removePrivateDeclarations(KmClass $receiver) {
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($receiver);
    }

    public static final /* synthetic */ void access$removePrivateDeclarations(KmPackage $receiver) {
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($receiver);
    }

    public static final /* synthetic */ void access$visitKotlinMetadata(AnnotationVisitor $receiver, Metadata header) {
        JvmAbiMetadataProcessorKt.visitKotlinMetadata($receiver, header);
    }

    public static final /* synthetic */ boolean access$isPrivateDeclaration(int flags) {
        return JvmAbiMetadataProcessorKt.isPrivateDeclaration(flags);
    }
}

