/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ResultTypeWithNullableOperatorsChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ResultTypeWithNullableOperatorsChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowNullOperatorsForResult)) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        Name name = resolvedCall2.getResultingDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue(name, "resolvedCall.resultingDescriptor.name");
        Name name2 = name;
        ASTNode operationNode = resolvedCall2.getCall().getCallOperationNode();
        ASTNode aSTNode = operationNode;
        if (Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, KtTokens.SAFE_ACCESS)) {
            Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
            ReceiverParameterDescriptor receiverParameterDescriptor = resultingDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null && (receiverParameterDescriptor = resultingDescriptor.getDispatchReceiverParameter()) == null) {
                return;
            }
            ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            if (ResultClassInReturnTypeCheckerKt.isResultType(kotlinType)) {
                BindingTrace bindingTrace = context.getTrace();
                ASTNode aSTNode2 = operationNode;
                Intrinsics.checkNotNull(aSTNode2);
                bindingTrace.report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(aSTNode2.getPsi(), "?."));
            }
        } else if (Intrinsics.areEqual(name2, ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL.getSpecialFunctionName())) {
            KotlinType kotlinType = resolvedCall2.getResultingDescriptor().getReturnType();
            boolean bl = kotlinType != null ? ResultClassInReturnTypeCheckerKt.isResultType(kotlinType) : false;
            if (bl) {
                context.getTrace().report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "!!"));
            }
        } else if (Intrinsics.areEqual(name2, ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName())) {
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression elvisBinaryExpression = ktBinaryExpression;
            KtExpression ktExpression = elvisBinaryExpression.getLeft();
            if (ktExpression == null) {
                return;
            }
            KtExpression left = ktExpression;
            KotlinType kotlinType = context.getTrace().getType(left);
            if (kotlinType == null) {
                return;
            }
            KotlinType leftType = kotlinType;
            if (ResultClassInReturnTypeCheckerKt.isResultType(leftType)) {
                BindingTrace bindingTrace = context.getTrace();
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "RESULT_CLASS_WITH_NULLAB\u2026ERATOR.on(reportOn, \"?:\")");
                DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            }
            if (left instanceof KtBinaryExpression) {
                KtExpression ktExpression2 = ((KtBinaryExpression)left).getRight();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression lastExpression = ktExpression2;
                KotlinType kotlinType2 = context.getTrace().getType(lastExpression);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType lastExpressionType = kotlinType2;
                if (ResultClassInReturnTypeCheckerKt.isResultType(lastExpressionType)) {
                    BindingTrace bindingTrace = context.getTrace();
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "RESULT_CLASS_WITH_NULLAB\u2026ERATOR.on(reportOn, \"?:\")");
                    DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
                }
            }
        }
    }
}

