/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.SingletonDescriptor;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u001c\u0010\r\u001a\u00020\n2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/kotlin/container/SingletonTypeComponentDescriptor;", "Lorg/jetbrains/kotlin/container/SingletonDescriptor;", "container", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "klass", "Ljava/lang/Class;", "(Lorg/jetbrains/kotlin/container/ComponentContainer;Ljava/lang/Class;)V", "getKlass", "()Ljava/lang/Class;", "createInstance", "", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "createInstanceOf", "getDependencies", "", "Ljava/lang/reflect/Type;", "getRegistrations", "", "toString", ""})
public class SingletonTypeComponentDescriptor
extends SingletonDescriptor {
    @NotNull
    private final Class<?> klass;

    public SingletonTypeComponentDescriptor(@NotNull ComponentContainer container, @NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(klass, "klass");
        super(container);
        this.klass = klass;
    }

    @NotNull
    public final Class<?> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    protected Object createInstance(@NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        return this.createInstanceOf(this.klass, context);
    }

    @Override
    @NotNull
    public Iterable<Type> getRegistrations() {
        return CacheKt.getInfo(this.klass).getRegistrations();
    }

    private final Object createInstanceOf(Class<?> klass, ValueResolveContext context) {
        Object obj;
        ConstructorBinding binding = ResolveKt.bindToConstructor(klass, context);
        this.setState(ComponentState.Initializing);
        for (ValueDescriptor argumentDescriptor : binding.getArgumentDescriptors()) {
            if (!(argumentDescriptor instanceof Closeable) || argumentDescriptor instanceof SingletonDescriptor) continue;
            this.registerDisposableObject((Closeable)((Object)argumentDescriptor));
        }
        Constructor<?> constructor2 = binding.getConstructor();
        List<Object> arguments2 = ResolveKt.computeArguments(binding.getArgumentDescriptors());
        boolean $i$f$runWithUnwrappingInvocationException = false;
        try {
            boolean bl = false;
            Collection $this$toTypedArray$iv = arguments2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            Object obj2 = constructor2.newInstance(Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNull(obj2);
            obj = obj2;
        }
        catch (InvocationTargetException e$iv) {
            Throwable throwable;
            Throwable throwable2;
            Throwable throwable3 = throwable2 = e$iv.getTargetException();
            if (throwable3 == null) {
                throwable = e$iv;
            } else {
                Intrinsics.checkNotNullExpressionValue(throwable3, "e.targetException ?: e");
                throwable = throwable2;
            }
            throw throwable;
        }
        Object instance = obj;
        this.setState(ComponentState.Initialized);
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Type> getDependencies(@NotNull ValueResolveContext context) {
        Collection collection;
        List<SetterInfo> setterInfos;
        List<Type> constructorParameters;
        Intrinsics.checkNotNullParameter(context, "context");
        ClassInfo classInfo2 = CacheKt.getInfo(this.klass);
        ConstructorInfo constructorInfo = classInfo2.getConstructorInfo();
        List<Type> list2 = constructorInfo != null ? constructorInfo.getParameters() : null;
        if (list2 == null) {
            list2 = constructorParameters = CollectionsKt.emptyList();
        }
        if ((setterInfos = classInfo2.getSetterInfos()).isEmpty()) {
            collection = constructorParameters;
        } else {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = setterInfos;
            Collection collection2 = constructorParameters;
            boolean $i$f$flatMap = false;
            void var7_8 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                SetterInfo it = (SetterInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getParameters();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            collection = CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
        }
        return collection;
    }

    @NotNull
    public String toString() {
        return "Singleton: " + this.klass.getSimpleName();
    }
}

