/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "()V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
final class RenameFieldsLowering
implements ClassLoweringPass {
    @Override
    public void lower(@NotNull IrClass irClass2) {
        List<IrField> fields2;
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        List<IrField> $this$sortBy$iv = fields2 = SequencesKt.toMutableList(IrUtilsKt.getFields(irClass2));
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    IrField it = (IrField)a;
                    boolean bl = false;
                    int n = it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2);
                    it = (IrField)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    return ComparisonsKt.compareValues(comparable, it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2));
                }
            });
        }
        HashMap count = new HashMap();
        for (IrField field2 : fields2) {
            int index2;
            Name oldName = field2.getName();
            Integer n = (Integer)count.get(oldName);
            if (n == null) {
                n = 0;
            }
            if ((index2 = ((Number)n).intValue()) != 0 && !field2.getVisibility().isPublicAPI()) {
                Name name = Name.identifier("" + oldName + '$' + index2);
                Intrinsics.checkNotNullExpressionValue(name, "identifier(\"$oldName$$index\")");
                field2.setName(name);
            }
            ((Map)count).put(oldName, index2 + 1);
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

