/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.RangeLiteral;
import org.jetbrains.kotlin.js.translate.expression.RangeType;
import org.jetbrains.kotlin.js.translate.expression.WithIndexInfo;
import org.jetbrains.kotlin.js.translate.expression.WithIndexReceiverType;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"downToFunctionName", "Lorg/jetbrains/kotlin/name/FqName;", "indicesFqName", "intProgressionName", "intRangeName", "rangeToFunctionName", "sequenceFqName", "sequenceWithIndexFqName", "stepFunctionName", "untilFunctionName", "withIndexFqName", "createWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "js.translator"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    @NotNull
    private static final FqName rangeToFunctionName = new FqName("kotlin.Int.rangeTo");
    @NotNull
    private static final FqName untilFunctionName = new FqName("kotlin.ranges.until");
    @NotNull
    private static final FqName downToFunctionName = new FqName("kotlin.ranges.downTo");
    @NotNull
    private static final FqName stepFunctionName = new FqName("kotlin.ranges.step");
    @NotNull
    private static final FqName intRangeName = new FqName("kotlin.ranges.IntRange");
    @NotNull
    private static final FqName intProgressionName = new FqName("kotlin.ranges.IntProgression");
    @NotNull
    private static final FqName withIndexFqName = new FqName("kotlin.collections.withIndex");
    @NotNull
    private static final FqName sequenceWithIndexFqName = new FqName("kotlin.sequences.withIndex");
    @NotNull
    private static final FqName indicesFqName = new FqName("kotlin.collections.indices");
    @NotNull
    private static final FqName sequenceFqName = new FqName("kotlin.sequences.Sequence");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression2, @NotNull TranslationContext context2) {
        JsNode jsNode;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        KtExpression ktExpression2 = expression2.getCondition();
        if (ktExpression2 == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("condition expression should not be null: ", expression2.getText()));
        }
        KtExpression conditionExpression = ktExpression = ktExpression2;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsExpression = Translation.translateAsExpression(conditionExpression, context2, conditionBlock);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsExpression(co\u2026 context, conditionBlock)");
        JsExpression jsCondition = jsExpression;
        KtExpression body2 = expression2.getBody();
        JsStatement jsStatement = body2 != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(body2, context2) : (JsStatement)JsEmpty.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(jsStatement, "if (body != null)\n      \u2026 else\n            JsEmpty");
        JsStatement bodyStatement = jsStatement;
        if (!conditionBlock.isEmpty()) {
            void $this$createWhile_u24lambda_u2d0;
            jsNode = new JsBreak();
            Object object = jsNode;
            Object object2 = JsAstUtils.not(jsCondition);
            boolean bl = false;
            $this$createWhile_u24lambda_u2d0.setSource(expression2);
            Unit unit2 = Unit.INSTANCE;
            JsStatement jsStatement2 = (JsStatement)jsNode;
            JsExpression jsExpression2 = object2;
            JsNode $this$createWhile_u24lambda_u2d1 = jsNode = new JsIf(jsExpression2, jsStatement2);
            boolean bl22 = false;
            ((SourceInfoAwareJsNode)$this$createWhile_u24lambda_u2d1).setSource(expression2);
            JsNode breakIfConditionIsFalseStatement = jsNode;
            $this$createWhile_u24lambda_u2d1 = JsAstUtils.convertToBlock(bodyStatement);
            Intrinsics.checkNotNullExpressionValue($this$createWhile_u24lambda_u2d1, "convertToBlock(bodyStatement)");
            JsNode bodyBlock = $this$createWhile_u24lambda_u2d1;
            jsCondition = new JsBooleanLiteral(true);
            if (doWhile) {
                void $this$createWhile_u24lambda_u2d2;
                JsIf ifStatement;
                JsIf jsIf;
                JsExpression bl22 = context2.defineTemporary(new JsBooleanLiteral(false).source(expression2));
                Intrinsics.checkNotNullExpressionValue(bl22, "context.defineTemporary(\u2026alse).source(expression))");
                JsExpression secondRun = bl22;
                conditionBlock.getStatements().add((JsStatement)breakIfConditionIsFalseStatement);
                JsIf jsIf2 = jsIf = (ifStatement = new JsIf(secondRun, conditionBlock, JsAstUtils.assignment(secondRun, new JsBooleanLiteral(true)).source(expression2).makeStmt()));
                int n = 0;
                List<JsStatement> list2 = ((JsBlock)bodyBlock).getStatements();
                boolean bl3 = false;
                $this$createWhile_u24lambda_u2d2.setSource(expression2);
                object2 = Unit.INSTANCE;
                list2.add(n, jsIf);
            } else {
                conditionBlock.getStatements().add((JsStatement)breakIfConditionIsFalseStatement);
                List<JsStatement> list3 = ((JsBlock)bodyBlock).getStatements();
                object = conditionBlock.getStatements();
                Intrinsics.checkNotNullExpressionValue(object, "conditionBlock.statements");
                list3.addAll(0, (Collection)object);
            }
            bodyStatement = (JsStatement)bodyBlock;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        jsNode = result2.source(expression2);
        Intrinsics.checkNotNullExpressionValue(jsNode, "result.source(expression)");
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context2) {
        Object object;
        JsStatement jsStatement;
        block5: {
            Object parameterName;
            KtDestructuringDeclaration destructuringParameter;
            KtExpression loopParameter;
            Object rangeType;
            KtExpression loopRange;
            block6: {
                WithIndexInfo withIndexCall;
                block4: {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Object object2 = PsiUtils.getLoopRange(expression2);
                    KtExpression it = object2;
                    boolean bl = false;
                    KtExpression ktExpression = KtPsiUtil.deparenthesize(it);
                    Intrinsics.checkNotNull(ktExpression);
                    Object object3 = ktExpression;
                    Intrinsics.checkNotNullExpressionValue(object3, "deparenthesize(it)!!");
                    KtExpression deparenthesized = object3;
                    KtExpression ktExpression2 = deparenthesized instanceof KtStringTemplateExpression ? it : deparenthesized;
                    Intrinsics.checkNotNullExpressionValue(ktExpression2, "getLoopRange(expression)\u2026lse deparenthesized\n    }");
                    loopRange = ktExpression2;
                    object2 = BindingUtils.getTypeForExpression(context2.bindingContext(), loopRange);
                    Intrinsics.checkNotNullExpressionValue(object2, "getTypeForExpression(con\u2026dingContext(), loopRange)");
                    rangeType = object2;
                    KtParameter ktParameter = expression2.getLoopParameter();
                    Intrinsics.checkNotNull(ktParameter);
                    it = ktParameter;
                    Intrinsics.checkNotNullExpressionValue(it, "expression.loopParameter!!");
                    loopParameter = it;
                    destructuringParameter = ((KtParameter)loopParameter).getDestructuringDeclaration();
                    object3 = destructuringParameter == null ? context2.getNameForElement(loopParameter) : JsScope.declareTemporary();
                    Intrinsics.checkNotNullExpressionValue(object3, "if (destructuringParamet\u2026.declareTemporary()\n    }");
                    parameterName = object3;
                    RangeLiteral rangeLiteral = LoopTranslator.translateForExpression$extractForOverRangeLiteral((KotlinType)rangeType, loopRange, context2);
                    withIndexCall = LoopTranslator.translateForExpression$extractWithIndexCall(loopRange, context2, destructuringParameter, (KtParameter)loopParameter);
                    if (rangeLiteral == null) break block4;
                    jsStatement = LoopTranslator.translateForExpression$translateForOverLiteralRange(context2, (JsName)parameterName, expression2, destructuringParameter, (KtParameter)loopParameter, rangeLiteral);
                    break block5;
                }
                if (withIndexCall == null) break block6;
                object = withIndexCall.getReceiverType();
                int n = WhenMappings.$EnumSwitchMapping$1[((Enum)object).ordinal()];
                switch (n) {
                    case 1: {
                        jsStatement = LoopTranslator.translateForExpression$translateForOverArrayWithIndex(context2, expression2, withIndexCall);
                        break block5;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        jsStatement = withIndexCall.getValue() == null && withIndexCall.getReceiverType() == WithIndexReceiverType.COLLECTION ? LoopTranslator.translateForExpression$translateForOverCollectionIndices(context2, expression2, withIndexCall) : LoopTranslator.translateForExpression$translateForOverCollectionWithIndex(context2, expression2, withIndexCall);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            jsStatement = LoopTranslator.translateForExpression$isForOverRange((KotlinType)rangeType) ? LoopTranslator.translateForExpression$translateForOverRange(context2, loopRange, (JsName)parameterName, expression2, destructuringParameter, (KtParameter)loopParameter) : (LoopTranslator.translateForExpression$isForOverArray((KotlinType)rangeType) ? LoopTranslator.translateForExpression$translateForOverArray(context2, loopRange, expression2, destructuringParameter, (KtParameter)loopParameter, (JsName)parameterName) : LoopTranslator.translateForExpression$translateForOverIterator(context2, loopRange, expression2, destructuringParameter, (KtParameter)loopParameter, (JsName)parameterName));
        }
        JsStatement result2 = jsStatement;
        Object $this$translateForExpression_u24lambda_u2d33 = object = result2;
        boolean bl = false;
        $this$translateForExpression_u24lambda_u2d33.setSource(expression2);
        return object;
    }

    private static final boolean translateForExpression$isForOverRange(KotlinType rangeType) {
        ClassifierDescriptor classifierDescriptor = rangeType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        FqName fqn = DescriptorUtilsKt.getFqNameSafe(classifierDescriptor);
        return Intrinsics.areEqual(fqn, intRangeName);
    }

    private static final RangeLiteral translateForExpression$extractForOverRangeLiteral(KotlinType rangeType, KtExpression loopRange, TranslationContext $context) {
        RangeType rangeType2;
        Object object;
        Object object2;
        ExpressionReceiver expressionReceiver;
        Object object3;
        FqName fqn;
        ClassifierDescriptor classifierDescriptor = rangeType.getConstructor().getDeclarationDescriptor();
        FqName fqName2 = fqn = classifierDescriptor == null ? null : DescriptorUtilsKt.getFqNameSafe(classifierDescriptor);
        if (!Intrinsics.areEqual(fqn, intRangeName) && !Intrinsics.areEqual(fqn, intProgressionName)) {
            return null;
        }
        KtElement ktElement = loopRange;
        Object object4 = $context.bindingContext();
        Intrinsics.checkNotNullExpressionValue(object4, "context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, (BindingContext)object4);
        if (resolvedCall2 == null) {
            return null;
        }
        Object resolvedCall3 = resolvedCall2;
        Object step = null;
        if (Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor()), stepFunctionName)) {
            Object object5;
            object4 = resolvedCall3.getCall().getValueArguments().get(0).getArgumentExpression();
            if (object4 == null) {
                return null;
            }
            step = object4;
            object3 = resolvedCall3.getExtensionReceiver();
            ExpressionReceiver expressionReceiver2 = expressionReceiver = object3 instanceof ExpressionReceiver ? (ExpressionReceiver)object3 : null;
            if (expressionReceiver == null) {
                object5 = null;
            } else {
                object3 = expressionReceiver.getExpression();
                KtElement ktElement2 = (KtElement)object3;
                object2 = $context.bindingContext();
                Intrinsics.checkNotNullExpressionValue(object2, "context.bindingContext()");
                object5 = object4 = CallUtilKt.getResolvedCall(ktElement2, (BindingContext)object2);
            }
            if (object4 == null) {
                return null;
            }
            resolvedCall3 = object4;
        }
        object3 = (object2 = resolvedCall3.getExtensionReceiver()) == null ? resolvedCall3.getDispatchReceiver() : object2;
        ExpressionReceiver expressionReceiver3 = expressionReceiver = object3 instanceof ExpressionReceiver ? (ExpressionReceiver)object3 : null;
        if (expressionReceiver == null) {
            return null;
        }
        KtExpression first = expressionReceiver.getExpression();
        object2 = resolvedCall3.getValueArgumentsByIndex();
        if (object2 == null) {
            object = null;
        } else {
            ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)CollectionsKt.firstOrNull(object2);
            if (resolvedValueArgument == null) {
                object = null;
            } else {
                List<ValueArgument> list2 = resolvedValueArgument.getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "arguments");
                ValueArgument valueArgument = CollectionsKt.firstOrNull(list2);
                object = object3 = valueArgument == null ? null : valueArgument.getArgumentExpression();
            }
        }
        if (object3 == null) {
            return null;
        }
        Object second = object3;
        object2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)resolvedCall3.getResultingDescriptor());
        if (Intrinsics.areEqual(object2, rangeToFunctionName)) {
            rangeType2 = RangeType.RANGE_TO;
        } else if (Intrinsics.areEqual(object2, untilFunctionName)) {
            rangeType2 = RangeType.UNTIL;
        } else if (Intrinsics.areEqual(object2, downToFunctionName)) {
            rangeType2 = RangeType.DOWN_TO;
        } else {
            return null;
        }
        RangeType type2 = rangeType2;
        return new RangeLiteral(type2, first, (KtExpression)second, (KtExpression)step);
    }

    private static final boolean translateForExpression$isForOverArray(KotlinType rangeType) {
        return KotlinBuiltIns.isArray(rangeType) || KotlinBuiltIns.isPrimitiveArray(rangeType);
    }

    private static final VariableDescriptor translateForExpression$extractDescriptor(KtDeclaration $this$translateForExpression_u24extractDescriptor, TranslationContext $context) {
        VariableDescriptor variableDescriptor;
        VariableDescriptor variableDescriptor2 = (VariableDescriptor)$context.bindingContext().get(BindingContext.VARIABLE, $this$translateForExpression_u24extractDescriptor);
        if (variableDescriptor2 == null) {
            variableDescriptor = null;
        } else {
            VariableDescriptor variableDescriptor3;
            VariableDescriptor it = variableDescriptor3 = variableDescriptor2;
            boolean bl = false;
            variableDescriptor = !it.getName().isSpecial() ? variableDescriptor3 : null;
        }
        return variableDescriptor;
    }

    private static final WithIndexInfo translateForExpression$extractWithIndexCall(KtExpression loopRange, TranslationContext $context, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter) {
        JsExpression jsExpression;
        WithIndexReceiverType withIndexReceiverType;
        ClassDescriptor classDescriptor2;
        Object object;
        Object object2;
        ClassifierDescriptor classifierDescriptor;
        Pair<VariableDescriptor, VariableDescriptor> pair;
        KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry;
        Object it;
        KtElement ktElement = loopRange;
        Object object3 = $context.bindingContext();
        Intrinsics.checkNotNullExpressionValue(object3, "context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, (BindingContext)object3);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor());
        FqName fqName3 = fqName2;
        if (Intrinsics.areEqual(fqName3, withIndexFqName) ? true : Intrinsics.areEqual(fqName3, sequenceWithIndexFqName)) {
            if (destructuringParameter == null) {
                return null;
            }
            List<KtDestructuringDeclarationEntry> list2 = destructuringParameter.getEntries();
            it = list2;
            boolean classDescriptor2 = false;
            ktDestructuringDeclarationEntry = it.get(0);
            Intrinsics.checkNotNullExpressionValue(ktDestructuringDeclarationEntry, "it[0]");
            VariableDescriptor variableDescriptor = LoopTranslator.translateForExpression$extractDescriptor(ktDestructuringDeclarationEntry, $context);
            ktDestructuringDeclarationEntry = it.get(1);
            Intrinsics.checkNotNullExpressionValue(ktDestructuringDeclarationEntry, "it[1]");
            Pair<VariableDescriptor, VariableDescriptor> pair2 = new Pair<VariableDescriptor, VariableDescriptor>(variableDescriptor, LoopTranslator.translateForExpression$extractDescriptor(ktDestructuringDeclarationEntry, $context));
            pair = pair2;
        } else if (Intrinsics.areEqual(fqName3, indicesFqName)) {
            if (destructuringParameter != null) {
                return null;
            }
            DeclarationDescriptor classDescriptor2 = $context.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, loopParameter);
            Object object4 = it = classDescriptor2 instanceof VariableDescriptor ? (VariableDescriptor)classDescriptor2 : null;
            if (it == null) {
                return null;
            }
            Object varDescriptor = it;
            pair = new Pair<Object, Object>(varDescriptor, null);
        } else {
            return null;
        }
        object3 = pair;
        VariableDescriptor indexDescriptor = (VariableDescriptor)((Pair)object3).component1();
        VariableDescriptor elementDescriptor = (VariableDescriptor)((Pair)object3).component2();
        Object object5 = resolvedCall3.getResultingDescriptor().getExtensionReceiverParameter();
        if (object5 == null) {
            classifierDescriptor = null;
        } else {
            object2 = object5.getType();
            object = ((KotlinType)object2).getConstructor();
            classifierDescriptor = object.getDeclarationDescriptor();
        }
        ktDestructuringDeclarationEntry = classifierDescriptor;
        ClassDescriptor classDescriptor3 = classDescriptor2 = ktDestructuringDeclarationEntry instanceof ClassDescriptor ? (ClassDescriptor)((Object)ktDestructuringDeclarationEntry) : null;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor receiverClass = classDescriptor2;
        if (KotlinBuiltIns.isArrayOrPrimitiveArray(receiverClass)) {
            withIndexReceiverType = WithIndexReceiverType.ARRAY;
        } else if (KotlinBuiltIns.isCollectionOrNullableCollection(receiverClass.getDefaultType())) {
            withIndexReceiverType = WithIndexReceiverType.COLLECTION;
        } else if (KotlinBuiltIns.isIterableOrNullableIterable(receiverClass.getDefaultType())) {
            withIndexReceiverType = WithIndexReceiverType.ITERABLE;
        } else if (Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(receiverClass), sequenceFqName)) {
            withIndexReceiverType = WithIndexReceiverType.SEQUENCE;
        } else {
            return null;
        }
        WithIndexReceiverType receiverType = withIndexReceiverType;
        object2 = resolvedCall3.getExtensionReceiver();
        if (object2 == null) {
            return null;
        }
        object5 = object2;
        Object receiver = object5;
        object = receiver;
        if (object instanceof ExpressionReceiver) {
            jsExpression = Translation.translateAsExpression(((ExpressionReceiver)receiver).getExpression(), $context);
        } else if (object instanceof ImplicitReceiver) {
            jsExpression = $context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver((ReceiverValue)receiver));
        } else {
            return null;
        }
        object2 = jsExpression;
        Intrinsics.checkNotNullExpressionValue(object2, "when (receiver) {\n      \u2026 -> return null\n        }");
        Object arrayExpr = object2;
        return new WithIndexInfo(receiverType, indexDescriptor, elementDescriptor, (JsExpression)arrayExpr);
    }

    private static final JsStatement translateForExpression$translateBody(KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, TranslationContext $context, KtParameter loopParameter, JsName parameterName, JsExpression itemValue) {
        List<JsStatement> list2;
        Iterable<JsStatement> iterable;
        Object object;
        Object loopParameterType;
        Object object2;
        Object object3;
        JsStatement jsStatement;
        KtExpression ktExpression = $expression.getBody();
        if (ktExpression == null) {
            jsStatement = null;
        } else {
            KtExpression ktExpression2;
            KtExpression it = ktExpression2 = ktExpression;
            boolean bl = false;
            jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, $context);
        }
        JsStatement realBody = jsStatement;
        if (itemValue == null && destructuringParameter == null) {
            return realBody;
        }
        JsBlock block = new JsBlock();
        if (destructuringParameter == null) {
            JsExpression jsExpression;
            CallableDescriptor loopParameterDescriptor = (CallableDescriptor)BindingUtils.getDescriptorForElement($context.bindingContext(), loopParameter);
            object3 = loopParameterDescriptor.getReturnType();
            object2 = object3 == null ? (KotlinType)$context.getCurrentModule().getBuiltIns().getAnyType() : object3;
            Intrinsics.checkNotNullExpressionValue(object2, "loopParameterDescriptor.\u2026ntModule.builtIns.anyType");
            loopParameterType = object2;
            object3 = itemValue;
            if (object3 == null) {
                jsExpression = null;
            } else {
                Object object4;
                Object it = object4 = object3;
                boolean bl = false;
                jsExpression = TranslationUtils.coerce($context, (JsExpression)it, (KotlinType)loopParameterType);
            }
            JsExpression coercedItemValue = jsExpression;
            Object $this$translateForExpression_u24translateBody_u24lambda_u2d8 = object3 = JsAstUtils.newVar(parameterName, coercedItemValue);
            boolean bl = false;
            ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateBody_u24lambda_u2d8).setSource($expression.getLoopRange());
            object = object3;
        } else {
            loopParameterType = $context.innerBlock(block);
            Intrinsics.checkNotNullExpressionValue(loopParameterType, "context.innerBlock(block)");
            TranslationContext innerBlockContext = loopParameterType;
            if (itemValue != null) {
                Object $this$translateForExpression_u24translateBody_u24lambda_u2d9 = object3 = JsAstUtils.newVar(parameterName, itemValue);
                boolean bl = false;
                ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateBody_u24lambda_u2d9).setSource($expression.getLoopRange());
                object2 = object3;
                Intrinsics.checkNotNullExpressionValue(object2, "newVar(parameterName, it\u2026 = expression.loopRange }");
                Object parameterStatement = object2;
                innerBlockContext.addStatementToCurrentBlock((JsStatement)parameterStatement);
            }
            object = DestructuringDeclarationTranslator.translate(destructuringParameter, JsAstUtils.pureFqn(parameterName, null), innerBlockContext);
        }
        SourceInfoAwareJsNode sourceInfoAwareJsNode = object;
        Intrinsics.checkNotNullExpressionValue(sourceInfoAwareJsNode, "if (destructuringParamet\u2026ontext)\n                }");
        JsVars currentVarInit = sourceInfoAwareJsNode;
        sourceInfoAwareJsNode = block;
        Collection<JsStatement> collection = ((JsBlock)sourceInfoAwareJsNode).getStatements();
        Intrinsics.checkNotNullExpressionValue(collection, "block.statements");
        collection = collection;
        collection.add(currentVarInit);
        sourceInfoAwareJsNode = block;
        collection = ((JsBlock)sourceInfoAwareJsNode).getStatements();
        Intrinsics.checkNotNullExpressionValue(collection, "block.statements");
        if (realBody instanceof JsBlock) {
            iterable = ((JsBlock)realBody).getStatements();
            Intrinsics.checkNotNullExpressionValue(iterable, "realBody.statements");
            list2 = iterable;
        } else {
            list2 = CollectionsKt.listOfNotNull(realBody);
        }
        iterable = list2;
        CollectionsKt.addAll(collection, iterable);
        return block;
    }

    private static final JsStatement translateForExpression$translateForOverLiteralRange(TranslationContext $context, JsName parameterName, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter, RangeLiteral literal) {
        JsVars jsVars;
        JsExpression jsExpression;
        Enum incrementOperator;
        int n;
        Object object;
        JsBinaryOperation jsBinaryOperation;
        int n2;
        Object it;
        JsExpression jsExpression2;
        Object it2;
        Object object2;
        JsExpression jsExpression3;
        JsBlock startBlock = new JsBlock();
        JsExpression jsExpression4 = Translation.translateAsExpression(literal.getFirst(), $context, startBlock);
        Intrinsics.checkNotNullExpressionValue(jsExpression4, "translateAsExpression(li\u2026rst, context, startBlock)");
        JsExpression leftExpression = jsExpression4;
        JsBlock endBlock = new JsBlock();
        JsExpression jsExpression5 = Translation.translateAsExpression(literal.getSecond(), $context, endBlock);
        Intrinsics.checkNotNullExpressionValue(jsExpression5, "translateAsExpression(li\u2026econd, context, endBlock)");
        JsExpression rightExpression = jsExpression5;
        JsBlock stepBlock = new JsBlock();
        KtExpression ktExpression = literal.getStep();
        if (ktExpression == null) {
            jsExpression3 = null;
        } else {
            it2 = object2 = ktExpression;
            boolean bl = false;
            jsExpression3 = Translation.translateAsExpression((KtExpression)it2, $context, stepBlock);
        }
        JsExpression stepExpression = jsExpression3;
        $context.addStatementsToCurrentBlockFrom(startBlock);
        object2 = $context.cacheExpressionIfNeeded(leftExpression);
        Intrinsics.checkNotNullExpressionValue(object2, "context.cacheExpressionIfNeeded(leftExpression)");
        Object rangeStart = object2;
        $context.addStatementsToCurrentBlockFrom(endBlock);
        it2 = $context.defineTemporary(rightExpression);
        Intrinsics.checkNotNullExpressionValue(it2, "context.defineTemporary(rightExpression)");
        Object rangeEnd = it2;
        $context.addStatementsToCurrentBlockFrom(stepBlock);
        JsExpression bl = stepExpression;
        if (bl == null) {
            jsExpression2 = null;
        } else {
            JsExpression jsExpression6 = bl;
            it = jsExpression6;
            n2 = 0;
            jsExpression2 = $context.defineTemporary((JsExpression)it);
        }
        JsExpression step = jsExpression2;
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, null);
        it = literal.getType();
        n2 = WhenMappings.$EnumSwitchMapping$0[((Enum)it).ordinal()];
        switch (n2) {
            case 1: {
                jsBinaryOperation = JsAstUtils.lessThanEq(parameterName.makeRef(), (JsExpression)rangeEnd);
                break;
            }
            case 2: {
                jsBinaryOperation = JsAstUtils.lessThan(parameterName.makeRef(), (JsExpression)rangeEnd);
                break;
            }
            case 3: {
                jsBinaryOperation = JsAstUtils.greaterThanEq(parameterName.makeRef(), (JsExpression)rangeEnd);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsExpression conditionExpression = jsBinaryOperation.source($expression);
        if (step == null) {
            JsUnaryOperator jsUnaryOperator;
            object = literal.getType();
            n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    jsUnaryOperator = JsUnaryOperator.INC;
                    break;
                }
                case 3: {
                    jsUnaryOperator = JsUnaryOperator.DEC;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            incrementOperator = jsUnaryOperator;
            jsExpression = new JsPostfixOperation((JsUnaryOperator)incrementOperator, parameterName.makeRef()).source($expression);
        } else {
            JsBinaryOperator jsBinaryOperator;
            object = literal.getType();
            n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    jsBinaryOperator = JsBinaryOperator.ASG_ADD;
                    break;
                }
                case 3: {
                    jsBinaryOperator = JsBinaryOperator.ASG_SUB;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            incrementOperator = jsBinaryOperator;
            jsExpression = new JsBinaryOperation((JsBinaryOperator)incrementOperator, parameterName.makeRef(), step).source($expression);
        }
        JsExpression incrementExpression = jsExpression;
        JsVars $this$translateForExpression_u24translateForOverLiteralRange_u24lambda_u2d12 = jsVars = JsAstUtils.newVar(parameterName, (JsExpression)rangeStart);
        boolean bl2 = false;
        $this$translateForExpression_u24translateForOverLiteralRange_u24lambda_u2d12.setSource($expression);
        object = jsVars;
        Intrinsics.checkNotNullExpressionValue(object, "newVar(parameterName, ra\u2026y { source = expression }");
        Object initVars = object;
        return new JsFor((JsVars)initVars, conditionExpression, incrementExpression, body2);
    }

    private static final JsExpression translateForExpression$translateForOverRange$getProperty(JsExpression rangeExpression, KtExpression loopRange, String funName) {
        JsExpression jsExpression = new JsNameRef(funName, rangeExpression).source(loopRange);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "JsNameRef(funName, range\u2026ession).source(loopRange)");
        return jsExpression;
    }

    private static final JsStatement translateForExpression$translateForOverRange(TranslationContext $context, KtExpression loopRange, JsName parameterName, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter) {
        JsVars jsVars;
        JsExpression jsExpression = $context.defineTemporary(Translation.translateAsExpression(loopRange, $context));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context.defineTemporary(\u2026sion(loopRange, context))");
        JsExpression rangeExpression = jsExpression;
        JsExpression jsExpression2 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, loopRange, "first"));
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "context.defineTemporary(getProperty(\"first\"))");
        JsExpression start = jsExpression2;
        JsExpression jsExpression3 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, loopRange, "last"));
        Intrinsics.checkNotNullExpressionValue(jsExpression3, "context.defineTemporary(getProperty(\"last\"))");
        JsExpression end = jsExpression3;
        JsExpression jsExpression4 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, loopRange, "step"));
        Intrinsics.checkNotNullExpressionValue(jsExpression4, "context.defineTemporary(getProperty(\"step\"))");
        JsExpression increment = jsExpression4;
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, null);
        JsExpression conditionExpression = JsAstUtils.lessThanEq(parameterName.makeRef(), end).source($expression);
        JsExpression incrementExpression = JsAstUtils.addAssign(parameterName.makeRef(), increment).source($expression);
        JsVars $this$translateForExpression_u24translateForOverRange_u24lambda_u2d13 = jsVars = JsAstUtils.newVar(parameterName, start);
        boolean bl = false;
        $this$translateForExpression_u24translateForOverRange_u24lambda_u2d13.setSource($expression);
        JsVars jsVars2 = jsVars;
        Intrinsics.checkNotNullExpressionValue(jsVars2, "newVar(parameterName, st\u2026y { source = expression }");
        JsVars initVars = jsVars2;
        return new JsFor(initVars, conditionExpression, incrementExpression, body2);
    }

    private static final JsStatement translateForExpression$translateForOverArray(TranslationContext $context, KtExpression loopRange, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter, JsName parameterName) {
        JsExpression jsExpression = $context.defineTemporary(Translation.translateAsExpression(loopRange, $context));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context.defineTemporary(\u2026sion(loopRange, context))");
        JsExpression rangeExpression = jsExpression;
        JsExpression jsExpression2 = ArrayFIF.LENGTH_PROPERTY_INTRINSIC.apply(rangeExpression, CollectionsKt.emptyList(), $context);
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "LENGTH_PROPERTY_INTRINSI\u2026ssion, listOf(), context)");
        JsExpression length = jsExpression2;
        JsExpression jsExpression3 = $context.defineTemporary(length);
        Intrinsics.checkNotNullExpressionValue(jsExpression3, "context.defineTemporary(length)");
        JsExpression end = jsExpression3;
        TemporaryVariable temporaryVariable = $context.declareTemporary(new JsIntLiteral(0), $expression);
        Intrinsics.checkNotNullExpressionValue(temporaryVariable, "context.declareTemporary\u2026ntLiteral(0), expression)");
        TemporaryVariable index2 = temporaryVariable;
        JsExpression arrayAccess = new JsArrayAccess(rangeExpression, index2.reference()).source($expression);
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, arrayAccess);
        JsExpression initExpression = JsAstUtils.assignment(index2.reference(), new JsIntLiteral(0)).source($expression);
        JsExpression conditionExpression = JsAstUtils.inequality(index2.reference(), end).source($expression);
        JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference()).source($expression);
        return new JsFor(initExpression, conditionExpression, incrementExpression, body2);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsStatement translateForExpression$translateForOverArrayWithIndex(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        KtExpression ktExpression;
        Object object;
        JsName jsName;
        Object it;
        Object object2;
        JsName jsName2;
        JsExpression jsExpression = $context.cacheExpressionIfNeeded(info.getRange());
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context.cacheExpressionIfNeeded(info.range)");
        JsExpression range = jsExpression;
        VariableDescriptor variableDescriptor = info.getIndex();
        if (variableDescriptor == null) {
            jsName2 = JsScope.declareTemporary();
        } else {
            it = object2 = variableDescriptor;
            boolean bl = false;
            jsName2 = $context.getNameForDescriptor((DeclarationDescriptor)it);
        }
        JsName jsName3 = jsName2;
        Intrinsics.checkNotNullExpressionValue(jsName3, "info.index?.let { contex\u2026sScope.declareTemporary()");
        JsName indexVar = jsName3;
        variableDescriptor = info.getValue();
        if (variableDescriptor == null) {
            jsName = null;
        } else {
            it = object2 = variableDescriptor;
            boolean bl = false;
            jsName = $context.getNameForDescriptor((DeclarationDescriptor)it);
        }
        JsName valueVar = jsName;
        Object $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d16 = it = JsAstUtils.newVar(indexVar, new JsIntLiteral(0));
        boolean bl = false;
        ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d16).setSource($expression);
        object2 = it;
        Intrinsics.checkNotNullExpressionValue(object2, "newVar(indexVar, JsIntLi\u2026y { source = expression }");
        Object initExpression = object2;
        JsExpression conditionExpression = JsAstUtils.inequality(indexVar.makeRef(), new JsNameRef("length", range)).source($expression);
        JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, indexVar.makeRef()).source($expression);
        JsBlock body2 = new JsBlock();
        if (valueVar != null) {
            void $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d17;
            JsVars jsVars;
            JsBlock jsBlock = body2;
            object = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(object, "body.statements");
            JsVars jsVars2 = jsVars = JsAstUtils.newVar(valueVar, new JsArrayAccess(range, indexVar.makeRef()));
            Collection collection = (Collection)object;
            boolean bl2 = false;
            $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d17.setSource($expression);
            Unit unit2 = Unit.INSTANCE;
            collection.add(jsVars);
        }
        if ((ktExpression = $expression.getBody()) != null) {
            Object it2 = object = ktExpression;
            boolean bl3 = false;
            JsBlock jsBlock = body2;
            List<JsStatement> list2 = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
            ((Collection)list2).add(Translation.translateAsStatement((KtExpression)it2, $context.innerBlock(body2)));
        }
        return new JsFor((JsVars)initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
    }

    private static final ClassDescriptor translateForExpression$findCollection(TranslationContext $context) {
        Object object = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue(object, "context.currentModule");
        ModuleDescriptor moduleDescriptor = object;
        object = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(StandardNames.FqNames.collection)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    private static final JsStatement translateForExpression$translateForOverCollectionIndices(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        Object object;
        JsName jsName;
        JsExpression jsExpression = $context.cacheExpressionIfNeeded(info.getRange());
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context.cacheExpressionIfNeeded(info.range)");
        JsExpression range = jsExpression;
        Object object2 = info.getIndex();
        if (object2 == null) {
            jsName = JsScope.declareTemporary();
        } else {
            object = object2;
            VariableDescriptor it = object;
            boolean bl = false;
            jsName = $context.getNameForDescriptor(it);
        }
        JsName jsName2 = jsName;
        Intrinsics.checkNotNullExpressionValue(jsName2, "info.index?.let { contex\u2026sScope.declareTemporary()");
        JsName indexVar = jsName2;
        Object $this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2d20 = object = JsAstUtils.newVar(indexVar, new JsIntLiteral(0));
        boolean bl = false;
        ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2d20).setSource($expression);
        object2 = object;
        Intrinsics.checkNotNullExpressionValue(object2, "newVar(indexVar, JsIntLi\u2026y { source = expression }");
        Object initExpression = object2;
        object = DescriptorUtils.getPropertyByName(LoopTranslator.translateForExpression$findCollection($context).getUnsubstitutedMemberScope(), Name.identifier("size"));
        Intrinsics.checkNotNullExpressionValue(object, "getPropertyByName(findCo\u2026 Name.identifier(\"size\"))");
        Object sizeDescriptor = object;
        $this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2d20 = $context.getNameForDescriptor((DeclarationDescriptor)sizeDescriptor);
        Intrinsics.checkNotNullExpressionValue($this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2d20, "context.getNameForDescriptor(sizeDescriptor)");
        Object sizeName = $this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2d20;
        JsExpression conditionExpression = JsAstUtils.inequality(indexVar.makeRef(), new JsNameRef((JsName)sizeName, range)).source($expression);
        JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, indexVar.makeRef()).source($expression);
        JsBlock body2 = new JsBlock();
        KtExpression ktExpression = $expression.getBody();
        if (ktExpression != null) {
            KtExpression ktExpression2;
            KtExpression it = ktExpression2 = ktExpression;
            boolean bl2 = false;
            JsBlock jsBlock = body2;
            List<JsStatement> list2 = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
            ((Collection)list2).add(Translation.translateAsStatement(it, $context.innerBlock(body2)));
        }
        return new JsFor((JsVars)initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
    }

    private static final ClassDescriptor translateForExpression$findIterable(TranslationContext $context) {
        Object object = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue(object, "context.currentModule");
        ModuleDescriptor moduleDescriptor = object;
        object = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(StandardNames.FqNames.iterable)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    private static final ClassDescriptor translateForExpression$findSequence(TranslationContext $context) {
        Object object = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue(object, "context.currentModule");
        ModuleDescriptor moduleDescriptor = object;
        object = ClassId.topLevel(sequenceFqName);
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(sequenceFqName)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsStatement translateForExpression$translateForOverCollectionWithIndex(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        JsStatement jsStatement;
        Object it;
        Object object;
        JsExpression jsExpression;
        Object $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d25_u24lambda_u2d24;
        Object object2;
        HasMetadata hasMetadata;
        JsName jsName;
        Object it2;
        Object object3;
        JsName jsName2;
        JsExpression jsExpression2 = $context.cacheExpressionIfNeeded(info.getRange());
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "context.cacheExpressionIfNeeded(info.range)");
        JsExpression range = jsExpression2;
        VariableDescriptor variableDescriptor = info.getIndex();
        if (variableDescriptor == null) {
            jsName2 = null;
        } else {
            it2 = object3 = variableDescriptor;
            boolean bl = false;
            jsName2 = $context.getNameForDescriptor((DeclarationDescriptor)it2);
        }
        JsName indexVar = jsName2;
        object3 = info.getValue();
        if (object3 == null) {
            jsName = null;
        } else {
            it2 = object3;
            VariableDescriptor it3 = it2;
            boolean bl = false;
            jsName = $context.getNameForDescriptor(it3);
        }
        JsName valueVar = jsName;
        object3 = indexVar;
        if (object3 != null) {
            Object it4 = it2 = object3;
            boolean bl = false;
            JsVars jsVars = hasMetadata = JsAstUtils.newVar((JsName)it4, new JsIntLiteral(0));
            object2 = $context;
            boolean bl2 = false;
            ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d25_u24lambda_u2d24).setSource($expression);
            Unit unit2 = Unit.INSTANCE;
            ((TranslationContext)object2).addStatementToCurrentBlock((JsStatement)((Object)hasMetadata));
        }
        it2 = JsScope.declareTemporary();
        Intrinsics.checkNotNullExpressionValue(it2, "declareTemporary()");
        Object iteratorVar = it2;
        ClassDescriptor rangeOwner = info.getReceiverType() == WithIndexReceiverType.SEQUENCE ? LoopTranslator.translateForExpression$findSequence($context) : LoopTranslator.translateForExpression$findIterable($context);
        FunctionDescriptor bl = DescriptorUtils.getFunctionByName(rangeOwner.getUnsubstitutedMemberScope(), Name.identifier("iterator"));
        Intrinsics.checkNotNullExpressionValue(bl, "getFunctionByName(rangeO\u2026e.identifier(\"iterator\"))");
        FunctionDescriptor iteratorDescriptor = bl;
        hasMetadata = $context.getNameForDescriptor(iteratorDescriptor);
        Intrinsics.checkNotNullExpressionValue(hasMetadata, "context.getNameForDescriptor(iteratorDescriptor)");
        HasMetadata iteratorName = hasMetadata;
        Object $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d26 = object2 = JsAstUtils.newVar((JsName)iteratorVar, new JsInvocation((JsExpression)JsAstUtils.pureFqn((JsName)iteratorName, range), new JsExpression[0]));
        boolean $i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22 = false;
        ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d26).setSource($expression);
        $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d25_u24lambda_u2d24 = object2;
        Intrinsics.checkNotNullExpressionValue($this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d25_u24lambda_u2d24, "newVar(iteratorVar, JsIn\u2026y { source = expression }");
        Object initExpression = $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d25_u24lambda_u2d24;
        KotlinType kotlinType = iteratorDescriptor.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        object2 = kotlinType.getConstructor().getDeclarationDescriptor();
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor iteratorClassDescriptor = (ClassDescriptor)object2;
        $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d26 = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("hasNext"));
        Intrinsics.checkNotNullExpressionValue($this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d26, "getFunctionByName(iterat\u2026me.identifier(\"hasNext\"))");
        Object hasNextDescriptor = $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d26;
        JsName $i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22 = $context.getNameForDescriptor((DeclarationDescriptor)hasNextDescriptor);
        Intrinsics.checkNotNullExpressionValue($i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22, "context.getNameForDescriptor(hasNextDescriptor)");
        JsName hasNextName = $i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22;
        JsNode hasNextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(hasNextName, (JsExpression)((JsName)iteratorVar).makeRef()), new JsExpression[0]).source($expression);
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("next"));
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getFunctionByName(iterat\u2026 Name.identifier(\"next\"))");
        FunctionDescriptor nextDescriptor = functionDescriptor;
        JsName jsName3 = $context.getNameForDescriptor(nextDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsName3, "context.getNameForDescriptor(nextDescriptor)");
        JsName nextName = jsName3;
        JsNode nextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(nextName, (JsExpression)((JsName)iteratorVar).makeRef()), new JsExpression[0]).source($expression);
        JsName jsName4 = indexVar;
        if (jsName4 == null) {
            jsExpression = null;
        } else {
            it = object = jsName4;
            boolean bl3 = false;
            jsExpression = new JsPrefixOperation(JsUnaryOperator.INC, ((JsName)it).makeRef()).source($expression);
        }
        JsExpression incrementExpression = jsExpression;
        JsBlock body2 = new JsBlock();
        object = body2;
        it = ((JsBlock)object).getStatements();
        Intrinsics.checkNotNullExpressionValue(it, "body.statements");
        Collection collection = (Collection)it;
        if (valueVar != null) {
            void $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d28;
            JsVars bl3;
            JsVars jsVars = bl3 = JsAstUtils.newVar(valueVar, (JsExpression)nextInvocation);
            Collection collection2 = collection;
            boolean bl4 = false;
            $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d28.setSource($expression);
            Unit unit3 = Unit.INSTANCE;
            collection = collection2;
            jsStatement = bl3;
        } else {
            jsStatement = JsAstUtils.asSyntheticStatement((JsExpression)nextInvocation);
        }
        collection.add(jsStatement);
        object = $expression.getBody();
        if (object != null) {
            Object it5 = it = object;
            boolean bl5 = false;
            JsBlock jsBlock = body2;
            List<JsStatement> list2 = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
            ((Collection)list2).add(Translation.translateAsStatement((KtExpression)it5, $context.innerBlock(body2)));
        }
        it = object = new JsFor((JsVars)initExpression, (JsExpression)hasNextInvocation, incrementExpression);
        boolean bl6 = false;
        ((JsFor)it).setBody(body2);
        return (JsStatement)object;
    }

    private static final JsExpression translateForExpression$translateForOverIterator$translateMethodInvocation(TranslationContext $context, JsExpression receiver, ResolvedCall<FunctionDescriptor> resolvedCall2, JsBlock block) {
        TranslationContext translationContext = $context.innerBlock(block);
        Intrinsics.checkNotNullExpressionValue(translationContext, "context.innerBlock(block)");
        return CallTranslator.translate(translationContext, resolvedCall2, receiver);
    }

    private static final JsExpression translateForExpression$translateForOverIterator$iteratorMethodInvocation(KtExpression loopRange, TranslationContext $context) {
        JsExpression jsExpression = Translation.translateAsExpression(loopRange, $context);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsExpression(loopRange, context)");
        JsExpression range = jsExpression;
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getIteratorFunction($context.bindingContext(), loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getIteratorFunction(cont\u2026dingContext(), loopRange)");
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
        return CallTranslator.translate($context, resolvedCall3, range);
    }

    private static final JsExpression translateForExpression$translateForOverIterator$hasNextMethodInvocation(TranslationContext $context, KtExpression loopRange, JsExpression iteratorVar, JsBlock block) {
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getHasNextCallable($context.bindingContext(), loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getHasNextCallable(conte\u2026dingContext(), loopRange)");
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
        return LoopTranslator.translateForExpression$translateForOverIterator$translateMethodInvocation($context, iteratorVar, resolvedCall3, block);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsStatement translateForExpression$translateForOverIterator(TranslationContext $context, KtExpression loopRange, KtForExpression $expression, KtDestructuringDeclaration destructuringParameter, KtParameter loopParameter, JsName parameterName) {
        List<JsStatement> list2;
        Object object;
        Collection collection;
        Object object2;
        Object object3;
        JsExpression jsExpression;
        JsExpression jsExpression2 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverIterator$iteratorMethodInvocation(loopRange, $context));
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "context.defineTemporary(\u2026eratorMethodInvocation())");
        JsExpression iteratorVar = jsExpression2;
        JsBlock hasNextBlock = new JsBlock();
        JsExpression hasNextInvocation = LoopTranslator.translateForExpression$translateForOverIterator$hasNextMethodInvocation($context, loopRange, iteratorVar, hasNextBlock);
        JsBlock nextBlock = new JsBlock();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction($context.bindingContext(), loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getNextFunction(context.\u2026dingContext(), loopRange)");
        JsExpression nextInvoke = LoopTranslator.translateForExpression$translateForOverIterator$translateMethodInvocation($context, iteratorVar, resolvedCall2, nextBlock);
        List bodyStatements = new ArrayList();
        if (hasNextBlock.isEmpty()) {
            jsExpression = hasNextInvocation;
        } else {
            void $this$translateForExpression_u24translateForOverIterator_u24lambda_u2d32;
            Object $this$translateForExpression_u24translateForOverIterator_u24lambda_u2d31;
            Collection collection2 = bodyStatements;
            object3 = hasNextBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(object3, "hasNextBlock.statements");
            CollectionsKt.addAll(collection2, (Iterable)object3);
            object2 = object3 = new JsBreak();
            JsExpression jsExpression3 = JsAstUtils.notOptimized(hasNextInvocation);
            collection = bodyStatements;
            boolean bl = false;
            ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverIterator_u24lambda_u2d31).setSource($expression);
            Unit unit2 = Unit.INSTANCE;
            JsStatement jsStatement = (JsStatement)object3;
            JsExpression jsExpression4 = jsExpression3;
            $this$translateForExpression_u24translateForOverIterator_u24lambda_u2d31 = object3 = new JsIf(jsExpression4, jsStatement);
            boolean bl2 = false;
            $this$translateForExpression_u24translateForOverIterator_u24lambda_u2d32.setSource($expression);
            object = Unit.INSTANCE;
            collection.add(object3);
            jsExpression = new JsBooleanLiteral(true);
        }
        JsExpression exitCondition = jsExpression;
        Collection collection3 = bodyStatements;
        object3 = nextBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue(object3, "nextBlock.statements");
        CollectionsKt.addAll(collection3, (Iterable)object3);
        Collection collection4 = bodyStatements;
        object3 = LoopTranslator.translateForExpression$translateBody($expression, destructuringParameter, $context, loopParameter, parameterName, nextInvoke);
        if (object3 == null) {
            list2 = null;
        } else {
            void p0;
            Object bl2 = object2 = object3;
            collection = collection4;
            boolean bl = false;
            object = JsAstUtils.flattenStatement((JsStatement)p0);
            collection4 = collection;
            list2 = object;
        }
        object2 = list2;
        CollectionsKt.addAll(collection4, (Iterable)(object2 == null ? CollectionsKt.emptyList() : object2));
        JsStatement jsStatement = (JsStatement)CollectionsKt.singleOrNull(bodyStatements);
        return new JsWhile(exitCondition, jsStatement == null ? (JsStatement)new JsBlock(bodyStatements) : jsStatement);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RangeType.values().length];
            nArray[RangeType.RANGE_TO.ordinal()] = 1;
            nArray[RangeType.UNTIL.ordinal()] = 2;
            nArray[RangeType.DOWN_TO.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WithIndexReceiverType.values().length];
            nArray[WithIndexReceiverType.ARRAY.ordinal()] = 1;
            nArray[WithIndexReceiverType.ITERABLE.ordinal()] = 2;
            nArray[WithIndexReceiverType.SEQUENCE.ordinal()] = 3;
            nArray[WithIndexReceiverType.COLLECTION.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

