/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.jvm.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinder;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.konan.KlibModuleOrigin;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmDescriptorMangler;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmIrMangler;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003012BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0014J\"\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020\u0003H\u0014J\u0010\u0010+\u001a\u00020*2\u0006\u0010'\u001a\u00020,H\u0014J\f\u0010-\u001a\u00020**\u00020.H\u0002J\f\u0010/\u001a\u00020**\u00020.H\u0002R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "translationPluginContext", "Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "manglerDesc", "Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmDescriptorMangler;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmDescriptorMangler;)V", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "javaName", "Lorg/jetbrains/kotlin/name/Name;", "getTranslationPluginContext", "()Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "createCurrentModuleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "declareJavaFieldStub", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "isBuiltInModule", "", "platformSpecificSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "isCleanDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isJavaDescriptor", "JvmCurrentModuleDeserializer", "JvmModuleDeserializer", "MetadataJVMModuleDeserializer", "ir.serialization.jvm"})
public final class JvmIrLinker
extends KotlinIrLinker {
    @Nullable
    private final TranslationPluginContext translationPluginContext;
    @NotNull
    private final DeclarationStubGenerator stubGenerator;
    @NotNull
    private final JvmDescriptorMangler manglerDesc;
    @NotNull
    private final FakeOverrideBuilder fakeOverrideBuilder;
    @NotNull
    private final Name javaName;

    public JvmIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull IrMessageLogger messageLogger, @NotNull IrTypeSystemContext typeSystem, @NotNull SymbolTable symbolTable, @Nullable TranslationPluginContext translationPluginContext, @NotNull DeclarationStubGenerator stubGenerator, @NotNull JvmDescriptorMangler manglerDesc) {
        Intrinsics.checkNotNullParameter(messageLogger, "messageLogger");
        Intrinsics.checkNotNullParameter(typeSystem, "typeSystem");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(stubGenerator, "stubGenerator");
        Intrinsics.checkNotNullParameter(manglerDesc, "manglerDesc");
        super(currentModule, messageLogger, typeSystem.getIrBuiltIns(), symbolTable, CollectionsKt.emptyList());
        this.translationPluginContext = translationPluginContext;
        this.stubGenerator = stubGenerator;
        this.manglerDesc = manglerDesc;
        this.fakeOverrideBuilder = new FakeOverrideBuilder(this, symbolTable, JvmIrMangler.INSTANCE, typeSystem, null, null, 48, null);
        Name name = Name.identifier("java");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"java\")");
        this.javaName = name;
    }

    @Override
    @Nullable
    public TranslationPluginContext getTranslationPluginContext() {
        return this.translationPluginContext;
    }

    @Override
    @NotNull
    public FakeOverrideBuilder getFakeOverrideBuilder() {
        return this.fakeOverrideBuilder;
    }

    @Override
    protected boolean isBuiltInModule(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        String string2 = moduleDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "moduleDescriptor.name.asString()");
        return StringsKt.startsWith$default(string2, "<dependencies of ", false, 2, null);
    }

    @Override
    @NotNull
    protected IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary klib, @NotNull DeserializationStrategy strategy) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)strategy, "strategy");
        if (klib != null) {
            boolean bl;
            boolean bl2 = bl = moduleDescriptor.getCapability(KlibModuleOrigin.Companion.getCAPABILITY()) != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            KotlinAbiVersion kotlinAbiVersion = klib.getVersions().getAbiVersion();
            return new JvmModuleDeserializer(moduleDescriptor, klib, kotlinAbiVersion == null ? KotlinAbiVersion.Companion.getCURRENT() : kotlinAbiVersion, strategy);
        }
        return new MetadataJVMModuleDeserializer(moduleDescriptor, CollectionsKt.emptyList());
    }

    private final boolean isJavaDescriptor(DeclarationDescriptor $this$isJavaDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        if ($this$isJavaDescriptor instanceof PackageFragmentDescriptor) {
            return $this$isJavaDescriptor instanceof LazyJavaPackageFragment || ((PackageFragmentDescriptor)$this$isJavaDescriptor).getFqName().startsWith(this.javaName);
        }
        return $this$isJavaDescriptor instanceof JavaClassDescriptor || $this$isJavaDescriptor instanceof JavaCallableMemberDescriptor || ((declarationDescriptor = $this$isJavaDescriptor.getContainingDeclaration()) == null ? false : this.isJavaDescriptor(declarationDescriptor));
    }

    private final boolean isCleanDescriptor(DeclarationDescriptor $this$isCleanDescriptor) {
        if ($this$isCleanDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$isCleanDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
            return this.isCleanDescriptor(propertyDescriptor);
        }
        return $this$isCleanDescriptor instanceof DeserializedDescriptor;
    }

    @Override
    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.isJavaDescriptor(symbol2.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IrField declareJavaFieldStub(IrFieldSymbol symbol2) {
        IrField irField;
        DeclarationStubGenerator declarationStubGenerator;
        DeclarationStubGenerator $this$declareJavaFieldStub_u24lambda_u2d0 = declarationStubGenerator = this.stubGenerator;
        boolean bl = false;
        boolean old = this.stubGenerator.getUnboundSymbolGeneration();
        try {
            this.stubGenerator.setUnboundSymbolGeneration(true);
            irField = $this$declareJavaFieldStub_u24lambda_u2d0.generateFieldStub((PropertyDescriptor)symbol2.getDescriptor());
        }
        finally {
            this.stubGenerator.setUnboundSymbolGeneration(old);
        }
        return irField;
    }

    @Override
    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter(moduleFragment, "moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        return new JvmCurrentModuleDeserializer(moduleFragment, dependencies2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$JvmModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/IrLibrary;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;)V", "ir.serialization.jvm"})
    private final class JvmModuleDeserializer
    extends BasicIrModuleDeserializer {
        public JvmModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrLibrary klib, @NotNull KotlinAbiVersion libraryAbiVersion, DeserializationStrategy strategy) {
            Intrinsics.checkNotNullParameter(JvmIrLinker.this, "this$0");
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(klib, "klib");
            Intrinsics.checkNotNullParameter(libraryAbiVersion, "libraryAbiVersion");
            Intrinsics.checkNotNullParameter((Object)strategy, "strategy");
            super(JvmIrLinker.this, moduleDescriptor, klib, strategy, libraryAbiVersion, false, 32, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$JvmCurrentModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/CurrentModuleDeserializer;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/Collection;)V", "declareIrSymbol", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.serialization.jvm"})
    private final class JvmCurrentModuleDeserializer
    extends CurrentModuleDeserializer {
        public JvmCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, Collection<? extends IrModuleDeserializer> dependencies2) {
            Intrinsics.checkNotNullParameter(JvmIrLinker.this, "this$0");
            Intrinsics.checkNotNullParameter(moduleFragment, "moduleFragment");
            Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
            super(moduleFragment, dependencies2);
        }

        @Override
        public void declareIrSymbol(@NotNull IrSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
            if (JvmIrLinker.this.isJavaDescriptor(descriptor2)) {
                if (symbol2 instanceof IrFieldSymbol) {
                    JvmIrLinker.this.declareJavaFieldStub((IrFieldSymbol)symbol2);
                } else {
                    JvmIrLinker.this.stubGenerator.generateMemberStub(descriptor2);
                }
                return;
            }
            if (JvmIrLinker.this.isCleanDescriptor(descriptor2)) {
                JvmIrLinker.this.stubGenerator.generateMemberStub(descriptor2);
                return;
            }
            super.declareIrSymbol(symbol2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$MetadataJVMModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "dependencies", "", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "descriptorFinder", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "contains", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "declareIrSymbol", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "resolveDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ir.serialization.jvm"})
    private final class MetadataJVMModuleDeserializer
    extends IrModuleDeserializer {
        @NotNull
        private final DescriptorByIdSignatureFinder descriptorFinder;
        @NotNull
        private final IrModuleFragment moduleFragment;
        @NotNull
        private final Collection<IrModuleDeserializer> moduleDependencies;

        public MetadataJVMModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, List<? extends IrModuleDeserializer> dependencies2) {
            Intrinsics.checkNotNullParameter(JvmIrLinker.this, "this$0");
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
            super(moduleDescriptor, KotlinAbiVersion.Companion.getCURRENT());
            this.descriptorFinder = new DescriptorByIdSignatureFinder(moduleDescriptor, JvmIrLinker.this.manglerDesc, DescriptorByIdSignatureFinder.LookupMode.MODULE_ONLY);
            this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor, JvmIrLinker.this.getBuiltIns(), CollectionsKt.emptyList());
            this.moduleDependencies = dependencies2;
        }

        @Override
        public boolean contains(@NotNull IdSignature idSig) {
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            return true;
        }

        private final DeclarationDescriptor resolveDescriptor(IdSignature idSig) {
            DeclarationDescriptor declarationDescriptor = this.descriptorFinder.findDescriptorBySignature(idSig);
            if (declarationDescriptor == null) {
                throw new IllegalStateException(Intrinsics.stringPlus("No descriptor found for ", idSig).toString());
            }
            return declarationDescriptor;
        }

        @Override
        @NotNull
        public IrSymbol deserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
            IrDeclaration irDeclaration2;
            DeclarationStubGenerator declarationStubGenerator;
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
            DeclarationDescriptor descriptor2 = this.resolveDescriptor(idSig);
            DeclarationStubGenerator $this$deserializeIrSymbol_u24lambda_u2d0 = declarationStubGenerator = JvmIrLinker.this.stubGenerator;
            boolean bl = false;
            BinarySymbolData.SymbolKind symbolKind2 = symbolKind;
            int n = WhenMappings.$EnumSwitchMapping$0[symbolKind2.ordinal()];
            switch (n) {
                case 1: {
                    irDeclaration2 = $this$deserializeIrSymbol_u24lambda_u2d0.generateClassStub((ClassDescriptor)descriptor2);
                    break;
                }
                case 2: {
                    irDeclaration2 = $this$deserializeIrSymbol_u24lambda_u2d0.generatePropertyStub((PropertyDescriptor)descriptor2);
                    break;
                }
                case 3: {
                    irDeclaration2 = DeclarationStubGenerator.generateFunctionStub$default($this$deserializeIrSymbol_u24lambda_u2d0, (FunctionDescriptor)descriptor2, false, 2, null);
                    break;
                }
                case 4: {
                    irDeclaration2 = $this$deserializeIrSymbol_u24lambda_u2d0.generateConstructorStub((ClassConstructorDescriptor)descriptor2);
                    break;
                }
                case 5: {
                    irDeclaration2 = $this$deserializeIrSymbol_u24lambda_u2d0.generateEnumEntryStub((ClassDescriptor)descriptor2);
                    break;
                }
                case 6: {
                    irDeclaration2 = $this$deserializeIrSymbol_u24lambda_u2d0.generateTypeAliasStub((TypeAliasDescriptor)descriptor2);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected type " + (Object)((Object)symbolKind) + " for sig " + idSig).toString());
                }
            }
            IrDeclaration declaration2 = irDeclaration2;
            return ((IrDeclarationBase)declaration2).getSymbol();
        }

        @Override
        public void declareIrSymbol(@NotNull IrSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            if (symbol2 instanceof IrFieldSymbol) {
                JvmIrLinker.this.declareJavaFieldStub((IrFieldSymbol)symbol2);
            } else {
                JvmIrLinker.this.stubGenerator.generateMemberStub(symbol2.getDescriptor());
            }
        }

        @Override
        @NotNull
        public IrModuleFragment getModuleFragment() {
            return this.moduleFragment;
        }

        @Override
        @NotNull
        public Collection<IrModuleDeserializer> getModuleDependencies() {
            return this.moduleDependencies;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
                nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 1;
                nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
                nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
                nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 4;
                nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 5;
                nArray[BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 6;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

