/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.SingleAbstractMethodLowering;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsSingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/SingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "enclosingBodyContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "needEqualsHashCodeMethods", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getNeedEqualsHashCodeMethods", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "currentScopeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getSuperTypeForWrapper", "typeOperand", "getWrapperVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "scopes", "", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "backend.js"})
public final class JsSingleAbstractMethodLowering
extends SingleAbstractMethodLowering
implements BodyLoweringPass {
    @Nullable
    private IrDeclaration enclosingBodyContainer;

    public JsSingleAbstractMethodLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
    }

    @Override
    @NotNull
    public DescriptorVisibility getWrapperVisibility(@NotNull IrTypeOperatorCall expression2, @NotNull List<? extends ScopeWithIr> scopes) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(scopes, "scopes");
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "LOCAL");
        return descriptorVisibility;
    }

    @Override
    public boolean getNeedEqualsHashCodeMethods(@NotNull IrType $this$needEqualsHashCodeMethods) {
        Intrinsics.checkNotNullParameter($this$needEqualsHashCodeMethods, "<this>");
        return false;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container2, "container");
        this.getCachedImplementations().clear();
        this.getInlineCachedImplementations().clear();
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull(container2);
        this.setEnclosingContainer(irClass2 == null ? (IrDeclarationContainer)IrUtilsKt.getFile(container2) : (IrDeclarationContainer)irClass2);
        this.enclosingBodyContainer = container2;
        this.transformChildrenVoid(irBody);
        for (IrClass wrapper : CollectionsKt.plus(this.getCachedImplementations().values(), (Iterable)this.getInlineCachedImplementations().values())) {
            IrDeclarationContainer parentClass = (IrDeclarationContainer)wrapper.getParent();
            this.getContext().getIrFactory().getStageController().unrestrictDeclarationListsAccess((Function0)new Function0<Unit>(parentClass, wrapper){
                final /* synthetic */ IrDeclarationContainer $parentClass;
                final /* synthetic */ IrClass $wrapper;
                {
                    this.$parentClass = $parentClass;
                    this.$wrapper = $wrapper;
                    super(0);
                }

                public final void invoke() {
                    IrDeclarationContainer irDeclarationContainer = this.$parentClass;
                    Collection collection = irDeclarationContainer.getDeclarations();
                    IrClass irClass2 = this.$wrapper;
                    boolean bl = false;
                    collection.add(irClass2);
                }
            });
        }
    }

    @Override
    @Nullable
    protected IrSymbol currentScopeSymbol() {
        IrSymbol irSymbol2;
        IrSymbol irSymbol3 = super.currentScopeSymbol();
        if (irSymbol3 == null) {
            IrSymbolOwner irSymbolOwner;
            IrDeclaration irDeclaration2 = this.enclosingBodyContainer;
            IrSymbolOwner irSymbolOwner2 = irSymbolOwner = irDeclaration2 instanceof IrSymbolOwner ? (IrSymbolOwner)irDeclaration2 : null;
            irSymbol2 = irSymbolOwner == null ? null : irSymbolOwner.getSymbol();
        } else {
            irSymbol2 = irSymbol3;
        }
        return irSymbol2;
    }

    @Override
    @NotNull
    public IrType getSuperTypeForWrapper(@NotNull IrType typeOperand) {
        IrType irType;
        Intrinsics.checkNotNullParameter(typeOperand, "typeOperand");
        Object object = IrTypesKt.getClassOrNull(typeOperand);
        IrType irType2 = irType = object == null ? null : IrTypesKt.getDefaultType((IrClassifierSymbol)object);
        if (irType == null) {
            object = Intrinsics.stringPlus("Unsupported SAM conversion: ", RenderIrElementKt.render(typeOperand));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return irType;
    }
}

