/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunInterfaceConstructorReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunInterfaceConstructorReferenceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirFunInterfaceConstructorReferenceChecker INSTANCE = new FirFunInterfaceConstructorReferenceChecker();

    private FirFunInterfaceConstructorReferenceChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirResolvedNamedReference firResolvedNamedReference;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(expression2 instanceof FirCallableReferenceAccess) || expression2 instanceof FirGetClassCall) {
            return;
        }
        FirPureAbstractElement firPureAbstractElement = ((FirCallableReferenceAccess)expression2).getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = firPureAbstractElement instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firPureAbstractElement : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        Object referredDeclaration = reference.getResolvedSymbol().getFir();
        if (referredDeclaration instanceof FirSimpleFunction && Intrinsics.areEqual(((FirSimpleFunction)referredDeclaration).getOrigin(), FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            boolean bl;
            firPureAbstractElement = FirHelpersKt.toRegularClass(((FirSimpleFunction)referredDeclaration).getReturnTypeRef(), context2.getSession());
            if (firPureAbstractElement == null) {
                bl = false;
            } else {
                FirPureAbstractElement $this$isFun$iv = firPureAbstractElement;
                boolean $i$f$isFun = false;
                bl = ((FirRegularClass)$this$isFun$iv).getStatus().isFun();
            }
            if (bl) {
                DiagnosticReporterKt.reportOn$default(reporter, reference.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE(), context2, null, 8, null);
            }
        }
    }
}

