/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.InputStream;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "index", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;Lcom/intellij/psi/search/GlobalSearchScope;)V", "findBinaryClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "fileName", "", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findClass", "rootType", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "findMetadata", "findSourceClass", "findSourceOrBinaryVirtualFile", "findVirtualFileWithHeader", "hasMetadataPackage", "", "fqName", "cli"})
public final class CliVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    private final JvmDependenciesIndex index;
    @NotNull
    private final GlobalSearchScope scope;

    public CliVirtualFileFinder(@NotNull JvmDependenciesIndex index2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull(index2, "index");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        this.index = index2;
        this.scope = scope2;
    }

    @Override
    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String string2 = classId.getRelativeClassName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "classId.relativeClassName.asString()");
        return this.findBinaryClass(classId, Intrinsics.stringPlus(StringsKt.replace$default(string2, '.', '$', false, 4, null), ".class"));
    }

    @Override
    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String string2 = classId.getRelativeClassName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "classId.relativeClassName.asString()");
        VirtualFile virtualFile2 = this.findBinaryClass(classId, Intrinsics.stringPlus(StringsKt.replace$default(string2, '.', '$', false, 4, null), ".class"));
        return virtualFile2 == null ? this.findSourceClass(classId, Intrinsics.stringPlus(classId.getRelativeClassName().asString(), ".java")) : virtualFile2;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        boolean bl = !classId.isNestedClass();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Nested classes are not supported here: ", classId);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        VirtualFile virtualFile2 = this.findBinaryClass(classId, Intrinsics.stringPlus(classId.getShortClassName().asString(), ".kotlin_metadata"));
        return virtualFile2 == null ? null : virtualFile2.getInputStream();
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Ref.BooleanRef found = new Ref.BooleanRef();
        JvmDependenciesIndex.DefaultImpls.traverseDirectoriesInPackage$default(this.index, fqName2, null, new Function2<VirtualFile, JavaRoot.RootType, Boolean>(found){
            final /* synthetic */ Ref.BooleanRef $found;
            {
                this.$found = $found;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull VirtualFile dir, @NotNull JavaRoot.RootType $noName_1) {
                boolean bl;
                boolean bl2;
                block1: {
                    void $this$any$iv;
                    Intrinsics.checkParameterIsNotNull(dir, "dir");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$noName_1), "$noName_1");
                    boolean bl3 = this.$found.element;
                    Object[] objectArray = dir.getChildren();
                    Intrinsics.checkExpressionValueIsNotNull(objectArray, "dir.children");
                    objectArray = objectArray;
                    bl2 = bl3;
                    Ref.BooleanRef booleanRef = this.$found;
                    boolean $i$f$any = false;
                    for (void element$iv : $this$any$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getExtension(), "kotlin_metadata")) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean bl5 = bl;
                booleanRef.element = bl2 | bl5;
                return !this.$found.element;
            }
        }, 2, null);
        return found.element;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        ClassId classId = new ClassId(packageFqName, Name.special("<builtins-metadata>"));
        VirtualFile virtualFile2 = this.findBinaryClass(classId, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFileName(packageFqName));
        return virtualFile2 == null ? null : virtualFile2.getInputStream();
    }

    private final VirtualFile findClass(ClassId classId, String fileName, Set<? extends JavaRoot.RootType> rootType) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3 = (VirtualFile)this.index.findClass(classId, rootType, (Function2)new Function2<VirtualFile, JavaRoot.RootType, VirtualFile>(fileName){
            final /* synthetic */ String $fileName;
            {
                this.$fileName = $fileName;
                super(2);
            }

            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile dir, @NotNull JavaRoot.RootType $noName_1) {
                VirtualFile virtualFile2;
                Intrinsics.checkParameterIsNotNull(dir, "dir");
                Intrinsics.checkParameterIsNotNull((Object)((Object)$noName_1), "$noName_1");
                VirtualFile virtualFile3 = dir.findChild(this.$fileName);
                if (virtualFile3 == null) {
                    virtualFile2 = null;
                } else {
                    VirtualFile virtualFile4 = virtualFile3;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile p0 = virtualFile4;
                    boolean bl3 = false;
                    virtualFile2 = p0.isValid() ? virtualFile4 : null;
                }
                return virtualFile2;
            }
        });
        if (virtualFile3 == null) {
            virtualFile2 = null;
        } else {
            VirtualFile virtualFile4 = virtualFile3;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile4;
            boolean bl3 = false;
            virtualFile2 = this.scope.contains(it) ? virtualFile4 : null;
        }
        return virtualFile2;
    }

    private final VirtualFile findBinaryClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findSourceClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlySource());
    }
}

