/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.PrimitiveComparisonKt;
import org.jetbrains.kotlin.fir.backend.PrimitiveConeNumericComparisonInfo;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u00020JJ \u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010F\u001a\u00020GH\u0002J.\u0010O\u001a\u00020E2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0002J&\u0010U\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010W\u0012\u0004\u0012\u00020X0V2\u0006\u0010P\u001a\u00020Q2\u0006\u0010Y\u001a\u00020ZH\u0002J.\u0010[\u001a\u00020E2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0002J.\u0010\\\u001a\u00020E2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0002J \u0010]\u001a\u00020E*\u00020E2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010`\u001a\u0004\u0018\u00010_H\u0002J\u0014\u0010a\u001a\u00020E*\u00020E2\u0006\u0010b\u001a\u00020cH\u0002R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020)X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0012\u0010,\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u000205X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020=X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0012\u0010@\u001a\u00020AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/OperatorExpressionGenerator;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "visitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "convertComparisonExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "comparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "convertEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "generateComparisonCall", "startOffset", "", "endOffset", "generateEqualityOperatorCall", "operation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "arguments", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getSymbolAndOriginForComparison", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "classifier", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "transformEqualityOperatorCall", "transformIdentityOperatorCall", "asComparisonOperand", "operandType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "targetType", "negate", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "fir2ir"})
public final class OperatorExpressionGenerator
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final Fir2IrVisitor visitor;
    @NotNull
    private final Fir2IrConversionScope conversionScope;

    public OperatorExpressionGenerator(@NotNull Fir2IrComponents components2, @NotNull Fir2IrVisitor visitor2, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter(components2, "components");
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Intrinsics.checkNotNullParameter(conversionScope, "conversionScope");
        this.components = components2;
        this.visitor = visitor2;
        this.conversionScope = conversionScope;
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    @NotNull
    public final IrExpression convertComparisonExpression(@NotNull FirComparisonExpression comparisonExpression) {
        Intrinsics.checkNotNullParameter(comparisonExpression, "comparisonExpression");
        return (IrExpression)ConversionUtilsKt.convertWithOffsets(comparisonExpression, (Function2)new Function2<Integer, Integer, IrExpression>(this, comparisonExpression){
            final /* synthetic */ OperatorExpressionGenerator this$0;
            final /* synthetic */ FirComparisonExpression $comparisonExpression;
            {
                this.this$0 = $receiver;
                this.$comparisonExpression = $comparisonExpression;
                super(2);
            }

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                return OperatorExpressionGenerator.access$generateComparisonCall(this.this$0, startOffset, endOffset, this.$comparisonExpression);
            }
        });
    }

    @NotNull
    public final IrExpression convertEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall) {
        Intrinsics.checkNotNullParameter(equalityOperatorCall, "equalityOperatorCall");
        return (IrExpression)ConversionUtilsKt.convertWithOffsets(equalityOperatorCall, (Function2)new Function2<Integer, Integer, IrExpression>(this, equalityOperatorCall){
            final /* synthetic */ OperatorExpressionGenerator this$0;
            final /* synthetic */ FirEqualityOperatorCall $equalityOperatorCall;
            {
                this.this$0 = $receiver;
                this.$equalityOperatorCall = $equalityOperatorCall;
                super(2);
            }

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                FirCall $this$arguments$iv = this.$equalityOperatorCall;
                boolean $i$f$getArguments = false;
                return OperatorExpressionGenerator.access$generateEqualityOperatorCall(this.this$0, startOffset, endOffset, this.$equalityOperatorCall.getOperation(), $this$arguments$iv.getArgumentList().getArguments());
            }
        });
    }

    private final IrExpression generateComparisonCall(int startOffset, int endOffset, FirComparisonExpression comparisonExpression) {
        FirOperation operation = comparisonExpression.getOperation();
        PrimitiveConeNumericComparisonInfo primitiveConeNumericComparisonInfo = PrimitiveComparisonKt.inferPrimitiveNumericComparisonInfo(comparisonExpression);
        if (primitiveConeNumericComparisonInfo == null) {
            return OperatorExpressionGenerator.generateComparisonCall$fallbackToRealCall(this, operation, startOffset, endOffset, comparisonExpression);
        }
        PrimitiveConeNumericComparisonInfo comparisonInfo = primitiveConeNumericComparisonInfo;
        ConeClassLikeType comparisonType = comparisonInfo.getComparisonType();
        Object object = this.getTypeConverter().getClassIdToTypeMap$fir2ir().get(comparisonType.getLookupTag().getClassId());
        if (object == null) {
            return OperatorExpressionGenerator.generateComparisonCall$fallbackToRealCall(this, operation, startOffset, endOffset, comparisonExpression);
        }
        IrType comparisonIrType = object;
        object = this.getSymbolAndOriginForComparison(operation, IrTypesKt.getClassifierOrFail(comparisonIrType));
        IrSimpleFunctionSymbol symbol2 = (IrSimpleFunctionSymbol)((Pair)object).component1();
        IrStatementOriginImpl origin = (IrStatementOriginImpl)((Pair)object).component2();
        Intrinsics.checkNotNull(symbol2);
        return PrimitivesKt.primitiveOp2(startOffset, endOffset, symbol2, this.getIrBuiltIns().getBooleanType(), origin, this.asComparisonOperand(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, PrimitiveComparisonKt.getLeft(comparisonExpression), false, 2, null), comparisonInfo.getLeftType(), comparisonType), this.asComparisonOperand(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, PrimitiveComparisonKt.getRight(comparisonExpression), false, 2, null), comparisonInfo.getRightType(), comparisonType));
    }

    private final Pair<IrSimpleFunctionSymbol, IrStatementOriginImpl> getSymbolAndOriginForComparison(FirOperation operation, IrClassifierSymbol classifier2) {
        Pair<IrSimpleFunctionSymbol, IrStatementOriginImpl> pair;
        FirOperation firOperation = operation;
        int n = WhenMappings.$EnumSwitchMapping$0[firOperation.ordinal()];
        switch (n) {
            case 1: {
                pair = TuplesKt.to(this.getIrBuiltIns().getLessFunByOperandType().get(classifier2), IrStatementOrigin.LT.INSTANCE);
                break;
            }
            case 2: {
                pair = TuplesKt.to(this.getIrBuiltIns().getGreaterFunByOperandType().get(classifier2), IrStatementOrigin.GT.INSTANCE);
                break;
            }
            case 3: {
                pair = TuplesKt.to(this.getIrBuiltIns().getLessOrEqualFunByOperandType().get(classifier2), IrStatementOrigin.LTEQ.INSTANCE);
                break;
            }
            case 4: {
                pair = TuplesKt.to(this.getIrBuiltIns().getGreaterOrEqualFunByOperandType().get(classifier2), IrStatementOrigin.GTEQ.INSTANCE);
                break;
            }
            default: {
                String string2 = Intrinsics.stringPlus("Unexpected comparison operation: ", (Object)operation);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return pair;
    }

    private final IrExpression generateEqualityOperatorCall(int startOffset, int endOffset, FirOperation operation, List<? extends FirExpression> arguments2) {
        IrExpression irExpression;
        FirOperation firOperation = operation;
        int n = WhenMappings.$EnumSwitchMapping$0[firOperation.ordinal()];
        switch (n) {
            case 5: 
            case 6: {
                irExpression = this.transformEqualityOperatorCall(startOffset, endOffset, operation, arguments2);
                break;
            }
            case 7: 
            case 8: {
                irExpression = this.transformIdentityOperatorCall(startOffset, endOffset, operation, arguments2);
                break;
            }
            default: {
                String string2 = Intrinsics.stringPlus("Unexpected operation: ", (Object)operation);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return irExpression;
    }

    private final IrExpression transformEqualityOperatorCall(int startOffset, int endOffset, FirOperation operation, List<? extends FirExpression> arguments2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        PrimitiveConeNumericComparisonInfo comparisonInfo;
        IrStatementOriginImpl irStatementOriginImpl;
        FirOperation firOperation = operation;
        int n = WhenMappings.$EnumSwitchMapping$0[firOperation.ordinal()];
        switch (n) {
            case 5: {
                irStatementOriginImpl = IrStatementOrigin.EQEQ.INSTANCE;
                break;
            }
            case 6: {
                irStatementOriginImpl = IrStatementOrigin.EXCLEQ.INSTANCE;
                break;
            }
            default: {
                String string2 = Intrinsics.stringPlus("Not an equality operation: ", (Object)operation);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        IrStatementOriginImpl origin = irStatementOriginImpl;
        PrimitiveConeNumericComparisonInfo primitiveConeNumericComparisonInfo = comparisonInfo = PrimitiveComparisonKt.inferPrimitiveNumericComparisonInfo(arguments2.get(0), arguments2.get(1));
        ConeClassLikeType comparisonType = primitiveConeNumericComparisonInfo == null ? null : primitiveConeNumericComparisonInfo.getComparisonType();
        Object object = comparisonType;
        if (object == null) {
            irSimpleFunctionSymbol = null;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            IrClassSymbol irClassSymbol = this.getTypeConverter().getClassIdToSymbolMap$fir2ir().get(((ConeClassLikeType)it).getLookupTag().getClassId());
            if (irClassSymbol == null) {
                irSimpleFunctionSymbol = null;
            } else {
                object2 = irClassSymbol;
                bl = false;
                bl2 = false;
                it = object2;
                boolean bl4 = false;
                irSimpleFunctionSymbol = this.getIrBuiltIns().getIeee754equalsFunByOperandType().get(it);
            }
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol eqeqSymbol = irSimpleFunctionSymbol2 == null ? this.getIrBuiltIns().getEqeqSymbol() : irSimpleFunctionSymbol2;
        object = comparisonInfo;
        IrExpression irExpression = this.asComparisonOperand(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, arguments2.get(0), false, 2, null), object == null ? null : ((PrimitiveConeNumericComparisonInfo)object).getLeftType(), comparisonType);
        object = comparisonInfo;
        IrExpression equalsCall = PrimitivesKt.primitiveOp2(startOffset, endOffset, eqeqSymbol, this.getIrBuiltIns().getBooleanType(), origin, irExpression, this.asComparisonOperand(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, arguments2.get(1), false, 2, null), object == null ? null : ((PrimitiveConeNumericComparisonInfo)object).getRightType(), comparisonType));
        return operation == FirOperation.EQ ? equalsCall : this.negate(equalsCall, origin);
    }

    private final IrExpression transformIdentityOperatorCall(int startOffset, int endOffset, FirOperation operation, List<? extends FirExpression> arguments2) {
        IrStatementOriginImpl irStatementOriginImpl;
        FirOperation firOperation = operation;
        int n = WhenMappings.$EnumSwitchMapping$0[firOperation.ordinal()];
        switch (n) {
            case 7: {
                irStatementOriginImpl = IrStatementOrigin.EQEQEQ.INSTANCE;
                break;
            }
            case 8: {
                irStatementOriginImpl = IrStatementOrigin.EXCLEQEQ.INSTANCE;
                break;
            }
            default: {
                String string2 = Intrinsics.stringPlus("Not an identity operation: ", (Object)operation);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        IrStatementOriginImpl origin = irStatementOriginImpl;
        IrExpression identityCall = PrimitivesKt.primitiveOp2(startOffset, endOffset, this.getIrBuiltIns().getEqeqeqSymbol(), this.getIrBuiltIns().getBooleanType(), origin, Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, arguments2.get(0), false, 2, null), Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, arguments2.get(1), false, 2, null));
        return operation == FirOperation.IDENTITY ? identityCall : this.negate(identityCall, origin);
    }

    private final IrExpression negate(IrExpression $this$negate, IrStatementOrigin origin) {
        return PrimitivesKt.primitiveOp1($this$negate.getStartOffset(), $this$negate.getEndOffset(), this.getIrBuiltIns().getBooleanNotSymbol(), this.getIrBuiltIns().getBooleanType(), origin, $this$negate);
    }

    private final IrExpression asComparisonOperand(IrExpression $this$asComparisonOperand, ConeClassLikeType operandType, ConeClassLikeType targetType) {
        IrExpression irExpression;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        ClassId targetClassId;
        if (targetType == null) {
            return $this$asComparisonOperand;
        }
        if (operandType == null) {
            String string2 = "operandType should be non-null if targetType is non-null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ClassId operandClassId = operandType.getLookupTag().getClassId();
        if (Intrinsics.areEqual(operandClassId, targetClassId = targetType.getLookupTag().getClassId())) {
            return $this$asComparisonOperand;
        }
        Object object = this.getTypeConverter().getClassIdToSymbolMap$fir2ir().get(operandClassId);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol = object == null ? null : AdditionalIrUtilsKt.getSimpleFunction((IrClassSymbol)object, Intrinsics.stringPlus("to", targetType.getLookupTag().getClassId().getShortClassName().asString()));
        if (irSimpleFunctionSymbol == null) {
            object = "No conversion function for " + operandType + " ~> " + targetType;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        IrSimpleFunctionSymbol conversionFunction = irSimpleFunctionSymbol;
        IrExpression dispatchReceiver = $this$asComparisonOperand;
        int n = $this$asComparisonOperand.getStartOffset();
        int n2 = $this$asComparisonOperand.getEndOffset();
        IrType irType = ((IrSimpleFunction)conversionFunction.getOwner()).getReturnType();
        Object object2 = new IrCallImpl(n, n2, irType, conversionFunction, 0, 0, null, null, 192, null);
        n2 = 0;
        boolean bl = false;
        IrCallImpl it = object2;
        boolean bl2 = false;
        it.setDispatchReceiver(dispatchReceiver);
        IrCallImpl unsafeIrCall = object2;
        if (ConeTypeUtilsKt.isNullable(operandType)) {
            object2 = ConversionUtilsKt.createTemporaryVariableForSafeCallConstruction(this.components, dispatchReceiver, this.conversionScope);
            IrVariable receiverVariable = (IrVariable)((Pair)object2).component1();
            IrValueSymbol receiverVariableSymbol = (IrValueSymbol)((Pair)object2).component2();
            unsafeIrCall.setDispatchReceiver(new IrGetValueImpl($this$asComparisonOperand.getStartOffset(), $this$asComparisonOperand.getEndOffset(), receiverVariableSymbol, null, 8, null));
            irExpression = ConversionUtilsKt.createSafeCallConstruction(this.components, receiverVariable, receiverVariableSymbol, unsafeIrCall);
        } else {
            irExpression = unsafeIrCall;
        }
        return irExpression;
    }

    private static final IrExpression generateComparisonCall$fallbackToRealCall(OperatorExpressionGenerator this$0, FirOperation operation, int $startOffset, int $endOffset, FirComparisonExpression $comparisonExpression) {
        Pair<IrSimpleFunctionSymbol, IrStatementOriginImpl> pair = this$0.getSymbolAndOriginForComparison(operation, IrTypesKt.getClassifierOrFail(this$0.getIrBuiltIns().getIntType()));
        IrSimpleFunctionSymbol symbol2 = pair.component1();
        IrStatementOriginImpl origin = pair.component2();
        Intrinsics.checkNotNull(symbol2);
        return PrimitivesKt.primitiveOp2($startOffset, $endOffset, symbol2, this$0.getIrBuiltIns().getBooleanType(), origin, (IrExpression)$comparisonExpression.getCompareToCall().accept(this$0.visitor, null), IrConstImpl.Companion.int($startOffset, $endOffset, this$0.getIrBuiltIns().getIntType(), 0));
    }

    public static final /* synthetic */ IrExpression access$generateComparisonCall(OperatorExpressionGenerator $this, int startOffset, int endOffset, FirComparisonExpression comparisonExpression) {
        return $this.generateComparisonCall(startOffset, endOffset, comparisonExpression);
    }

    public static final /* synthetic */ IrExpression access$generateEqualityOperatorCall(OperatorExpressionGenerator $this, int startOffset, int endOffset, FirOperation operation, List arguments2) {
        return $this.generateEqualityOperatorCall(startOffset, endOffset, operation, arguments2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            nArray[FirOperation.LT.ordinal()] = 1;
            nArray[FirOperation.GT.ordinal()] = 2;
            nArray[FirOperation.LT_EQ.ordinal()] = 3;
            nArray[FirOperation.GT_EQ.ordinal()] = 4;
            nArray[FirOperation.EQ.ordinal()] = 5;
            nArray[FirOperation.NOT_EQ.ordinal()] = 6;
            nArray[FirOperation.IDENTITY.ordinal()] = 7;
            nArray[FirOperation.NOT_IDENTITY.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

