/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtil;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtilKt;
import org.jetbrains.kotlin.ant.KotlinCompilerBaseTask;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ant/Kotlin2JvmTask;", "Lorg/jetbrains/kotlin/ant/KotlinCompilerBaseTask;", "()V", "cmdl", "Lorg/apache/tools/ant/types/CommandlineJava;", "compileClasspath", "Lorg/apache/tools/ant/types/Path;", "compilerFqName", "", "getCompilerFqName", "()Ljava/lang/String;", "fork", "", "getFork", "()Z", "setFork", "(Z)V", "includeRuntime", "getIncludeRuntime", "setIncludeRuntime", "moduleName", "getModuleName", "setModuleName", "(Ljava/lang/String;)V", "noReflect", "getNoReflect", "setNoReflect", "addConfiguredClasspath", "", "classpath", "createJvmarg", "Lorg/apache/tools/ant/types/Commandline$Argument;", "exec", "execute", "fillSpecificArguments", "setClasspath", "setClasspathRef", "ref", "Lorg/apache/tools/ant/types/Reference;", "kotlin-ant"})
public final class Kotlin2JvmTask
extends KotlinCompilerBaseTask {
    @NotNull
    private final String compilerFqName;
    private boolean includeRuntime;
    @Nullable
    private String moduleName;
    private boolean noReflect;
    @NotNull
    private final CommandlineJava cmdl = new CommandlineJava();
    private boolean fork;
    @Nullable
    private Path compileClasspath;

    public Kotlin2JvmTask() {
        this.compilerFqName = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    }

    @Override
    @NotNull
    protected String getCompilerFqName() {
        return this.compilerFqName;
    }

    public final boolean getIncludeRuntime() {
        return this.includeRuntime;
    }

    public final void setIncludeRuntime(boolean bl) {
        this.includeRuntime = bl;
    }

    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(@Nullable String string) {
        this.moduleName = string;
    }

    public final boolean getNoReflect() {
        return this.noReflect;
    }

    public final void setNoReflect(boolean bl) {
        this.noReflect = bl;
    }

    public final boolean getFork() {
        return this.fork;
    }

    public final void setFork(boolean bl) {
        this.fork = bl;
    }

    public final void setClasspath(@NotNull Path classpath) {
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            Path path = this.compileClasspath;
            Intrinsics.checkNotNull(path);
            path.append(classpath);
        }
    }

    public final void setClasspathRef(@NotNull Reference ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        Path path = this.compileClasspath;
        Intrinsics.checkNotNull(path);
        path.createPath().setRefid(ref);
    }

    public final void addConfiguredClasspath(@NotNull Path classpath) {
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        this.setClasspath(classpath);
    }

    @Override
    public void fillSpecificArguments() {
        Object object;
        Object it;
        boolean bl;
        boolean bl2;
        this.getArgs().add("-d");
        List<String> list = this.getArgs();
        Object object2 = this.getOutput();
        Intrinsics.checkNotNull(object2);
        String string = ((File)object2).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue(string, "output!!.canonicalPath");
        list.add(string);
        string = this.compileClasspath;
        if (string != null) {
            object2 = string;
            bl2 = false;
            bl = false;
            it = object2;
            boolean bl3 = false;
            this.getArgs().add("-classpath");
            List<String> list2 = this.getArgs();
            object = it.list();
            Intrinsics.checkNotNullExpressionValue(object, "it.list()");
            Object[] objectArray = object;
            object = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(object, "pathSeparator");
            list2.add(ArraysKt.joinToString$default(objectArray, (CharSequence)object, null, null, 0, null, null, 62, null));
        }
        if (this.moduleName == null) {
            this.moduleName = KotlinAntTaskUtilKt.getDefaultModuleName(this);
        }
        if ((string = this.moduleName) != null) {
            object2 = string;
            bl2 = false;
            bl = false;
            it = object2;
            boolean bl4 = false;
            this.getArgs().add("-module-name");
            List<String> list3 = this.getArgs();
            object = this.getModuleName();
            Intrinsics.checkNotNull(object);
            list3.add((String)object);
        }
        if (this.getNoStdlib()) {
            this.getArgs().add("-no-stdlib");
        }
        if (this.noReflect) {
            this.getArgs().add("-no-reflect");
        }
        if (this.includeRuntime) {
            this.getArgs().add("-include-runtime");
        }
    }

    @Override
    public void execute() {
        if (!this.fork) {
            super.execute();
        } else {
            this.exec();
        }
    }

    private final void exec() {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        Redirector redirector = new Redirector((Task)this);
        this.fillArguments();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        Collection collection = command;
        String[] stringArray = this.cmdl.getVmCommand().getArguments();
        Intrinsics.checkNotNullExpressionValue(stringArray, "cmdl.vmCommand.arguments");
        CollectionsKt.addAll(collection, (Object[])stringArray);
        command.add("-Dorg.jetbrains.kotlin.cliMessageRenderer=FullPath");
        command.add("-cp");
        command.add(KotlinAntTaskUtil.INSTANCE.getCompilerJar().getCanonicalPath());
        command.add(this.getCompilerFqName());
        command.addAll((Collection)this.getArgs());
        Execute exe = new Execute(redirector.createHandler(), null);
        exe.setAntRun(this.getProject());
        Object $this$toTypedArray$iv = (String[])command;
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        exe.setCommandline(stringArray2);
        this.log(Intrinsics.stringPlus("Executing command: ", CollectionsKt.joinToString$default(command, " ", null, null, 0, null, null, 62, null)), LogLevel.DEBUG.getLevel());
        StringBuilder stringBuilder = new StringBuilder().append("Compiling ");
        Path path = this.getSrc();
        Intrinsics.checkNotNull(path);
        $this$toTypedArray$iv = path.list();
        Intrinsics.checkNotNullExpressionValue($this$toTypedArray$iv, "src!!.list()");
        StringBuilder stringBuilder2 = stringBuilder.append(ArraysKt.toList((Object[])$this$toTypedArray$iv)).append(" => [");
        $this$toTypedArray$iv = this.getOutput();
        Intrinsics.checkNotNull($this$toTypedArray$iv);
        this.log(stringBuilder2.append((Object)((File)$this$toTypedArray$iv).getCanonicalPath()).append(']').toString());
        int exitCode = exe.execute();
        redirector.complete();
        if (this.getFailOnError() && exitCode != 0) {
            throw new BuildException("Compile failed; see the compiler error output for details.");
        }
    }

    @NotNull
    public final Commandline.Argument createJvmarg() {
        Commandline.Argument argument = this.cmdl.createVmArgument();
        Intrinsics.checkNotNullExpressionValue(argument, "cmdl.createVmArgument()");
        return argument;
    }
}

