/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.ICKotlinLibrary;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0010H\u0016J\u0011\u0010&\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0010H\u0096\u0002J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020$H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\f\u0010,\u001a\u00020\u0016*\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/CurrentModuleWithICDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "delegate", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "icData", "", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "icReaderFactory", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/library/IrLibrary;", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "dirtyDeclarations", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "icDeserializer", "icKlib", "Lorg/jetbrains/kotlin/backend/common/serialization/ICKotlinLibrary;", "isCurrent", "", "()Z", "klib", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "addModuleReachableTopLevel", "", "idSig", "contains", "deserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeReachableDeclarations", "init", "isDirtyDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ir.serialization.common"})
public final class CurrentModuleWithICDeserializer
extends IrModuleDeserializer {
    @NotNull
    private final IrModuleDeserializer delegate;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Map<IdSignature, IrSymbol> dirtyDeclarations;
    @NotNull
    private final ICKotlinLibrary icKlib;
    @NotNull
    private final IrModuleDeserializer icDeserializer;

    public CurrentModuleWithICDeserializer(@NotNull IrModuleDeserializer delegate, @NotNull SymbolTable symbolTable, @NotNull IrBuiltIns irBuiltIns, @NotNull List<SerializedIrFile> icData, @NotNull Function1<? super IrLibrary, ? extends IrModuleDeserializer> icReaderFactory) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(icData, "icData");
        Intrinsics.checkNotNullParameter(icReaderFactory, "icReaderFactory");
        super(delegate.getModuleDescriptor());
        this.delegate = delegate;
        this.symbolTable = symbolTable;
        this.irBuiltIns = irBuiltIns;
        boolean bl = false;
        this.dirtyDeclarations = new LinkedHashMap();
        this.icKlib = new ICKotlinLibrary(icData);
        this.icDeserializer = icReaderFactory.invoke(this.icKlib);
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Map<IdSignature, IrSymbol> map = this.dirtyDeclarations;
        boolean bl = false;
        Map<IdSignature, IrSymbol> map2 = map;
        boolean bl2 = false;
        return map2.containsKey(idSig) || this.icDeserializer.contains(idSig.topLevelSignature()) || this.delegate.contains(idSig);
    }

    @Override
    @NotNull
    public IrSymbol deserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        IrSymbol irSymbol = this.dirtyDeclarations.get(idSig);
        if (irSymbol != null) {
            IrSymbol irSymbol2 = irSymbol;
            boolean bl = false;
            boolean bl2 = false;
            IrSymbol it = irSymbol2;
            boolean bl3 = false;
            return it;
        }
        if (this.icDeserializer.contains(idSig.topLevelSignature())) {
            return this.icDeserializer.deserializeIrSymbol(idSig, symbolKind);
        }
        return this.delegate.deserializeIrSymbol(idSig, symbolKind);
    }

    @Override
    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        boolean bl = this.icDeserializer.contains(idSig);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.icDeserializer.addModuleReachableTopLevel(idSig);
    }

    @Override
    public void deserializeReachableDeclarations() {
        this.icDeserializer.deserializeReachableDeclarations();
    }

    private final boolean isDirtyDescriptor(DeclarationDescriptor $this$isDirtyDescriptor) {
        if ($this$isDirtyDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$isDirtyDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
            return this.isDirtyDescriptor(propertyDescriptor);
        }
        if ($this$isDirtyDescriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$isDirtyDescriptor).getDispatchReceiverParameter() != null) {
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)$this$isDirtyDescriptor).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "containingDeclaration");
            return this.isDirtyDescriptor(declarationDescriptor);
        }
        return !($this$isDirtyDescriptor instanceof DeserializedDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull IrModuleDeserializer delegate) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        Iterable $this$map$iv = DeclarationTableKt.getKnownBuiltins(this.irBuiltIns);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrDeclaration irDeclaration2 = (IrDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrSymbol irSymbol = it.getSymbol();
            collection.add(irSymbol);
        }
        Set knownBuiltIns = CollectionsKt.toSet((List)destination$iv$iv);
        this.symbolTable.forEachPublicSymbol((Function1<? super IrSymbol, Unit>)new Function1<IrSymbol, Unit>(this, knownBuiltIns){
            final /* synthetic */ CurrentModuleWithICDeserializer this$0;
            final /* synthetic */ Set<IrSymbol> $knownBuiltIns;
            {
                this.this$0 = $receiver;
                this.$knownBuiltIns = $knownBuiltIns;
                super(1);
            }

            public final void invoke(@NotNull IrSymbol it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (CurrentModuleWithICDeserializer.access$isDirtyDescriptor(this.this$0, it.getDescriptor()) && !this.$knownBuiltIns.contains(it)) {
                    Map map = CurrentModuleWithICDeserializer.access$getDirtyDeclarations$p(this.this$0);
                    IdSignature idSignature = it.getSignature();
                    Intrinsics.checkNotNull(idSignature);
                    boolean bl = false;
                    map.put(idSignature, it);
                }
            }
        });
        this.icDeserializer.init(delegate);
    }

    @Override
    @NotNull
    public IrLibrary getKlib() {
        return this.icDeserializer.getKlib();
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.delegate.getModuleFragment();
    }

    @Override
    @NotNull
    public Collection<IrModuleDeserializer> getModuleDependencies() {
        return this.delegate.getModuleDependencies();
    }

    @Override
    public boolean isCurrent() {
        return this.delegate.isCurrent();
    }

    public static final /* synthetic */ boolean access$isDirtyDescriptor(CurrentModuleWithICDeserializer $this, DeclarationDescriptor $receiver) {
        return $this.isDirtyDescriptor($receiver);
    }

    public static final /* synthetic */ Map access$getDirtyDeclarations$p(CurrentModuleWithICDeserializer $this) {
        return $this.dirtyDeclarations;
    }
}

