/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeRefinerImpl;
import org.jetbrains.kotlin.types.KotlinTypeRefinerImplKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefinerKt;
import org.jetbrains.kotlin.types.checker.Ref;
import org.jetbrains.kotlin.types.refinement.TypeRefinement;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J-\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018H\u0017\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\fH\u0017J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!2\u0006\u0010\u0016\u001a\u00020\u000fH\u0017J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0017J\f\u0010$\u001a\u00020\n*\u00020\fH\u0002J\f\u0010%\u001a\u00020\n*\u00020\rH\u0002J\f\u0010&\u001a\u00020\n*\u00020\rH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl;", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "isRefinementNeededForTypeConstructorCache", "Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "", "refinedTypeCache", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "scopes", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "findClassAcrossModuleDependencies", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getOrPutScopeForClass", "S", "classDescriptor", "compute", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "isRefinementNeededForModule", "isRefinementNeededForTypeConstructor", "typeConstructor", "refineDescriptor", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "refineSupertypes", "", "refineType", "type", "areThereExpectSupertypes", "canBeCached", "needsRefinement", "frontend"})
public final class KotlinTypeRefinerImpl
extends KotlinTypeRefiner {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final CacheWithNotNullValues<TypeConstructor, KotlinType> refinedTypeCache;
    @NotNull
    private final CacheWithNotNullValues<ClassifierDescriptor, Boolean> isRefinementNeededForTypeConstructorCache;
    @NotNull
    private final CacheWithNotNullValues<ClassDescriptor, MemberScope> scopes;

    public KotlinTypeRefinerImpl(@NotNull ModuleDescriptor moduleDescriptor, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.moduleDescriptor = moduleDescriptor;
        Ref<KotlinTypeRefiner> ref = this.moduleDescriptor.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        if (ref != null) {
            ref.setValue(this);
        }
        this.refinedTypeCache = storageManager.createCacheWithNotNullValues();
        this.isRefinementNeededForTypeConstructorCache = storageManager.createCacheWithNotNullValues();
        this.scopes = storageManager.createCacheWithNotNullValues();
    }

    @Override
    @TypeRefinement
    @NotNull
    public KotlinType refineType(@NotNull KotlinType type2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!this.needsRefinement(type2)) {
            kotlinType = type2;
        } else if (this.canBeCached(type2)) {
            KotlinType cached2 = this.refinedTypeCache.computeIfAbsent(type2.getConstructor(), new Function0<KotlinType>(type2, this){
                final /* synthetic */ KotlinType $type;
                final /* synthetic */ KotlinTypeRefinerImpl this$0;
                {
                    this.$type = $type;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final KotlinType invoke() {
                    ClassifierDescriptor classifierDescriptor = this.$type.getConstructor().getDeclarationDescriptor();
                    Intrinsics.checkNotNull(classifierDescriptor);
                    return classifierDescriptor.getDefaultType().refine(this.this$0);
                }
            });
            kotlinType = KotlinTypeRefinerImplKt.access$restoreAdditionalTypeInformation(cached2, type2);
        } else {
            kotlinType = type2.refine(this);
        }
        return kotlinType;
    }

    private final boolean needsRefinement(KotlinType $this$needsRefinement) {
        return this.isRefinementNeededForTypeConstructor($this$needsRefinement.getConstructor());
    }

    private final boolean canBeCached(KotlinType $this$canBeCached) {
        return $this$canBeCached.getHasNotTrivialRefinementFactory() && $this$canBeCached.getConstructor().getDeclarationDescriptor() != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @TypeRefinement
    @NotNull
    public Collection<KotlinType> refineSupertypes(@NotNull ClassDescriptor classDescriptor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classDescriptor2, "classDescriptor");
        Collection<KotlinType> collection = classDescriptor2.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, "classDescriptor.typeConstructor.supertypes");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            KotlinType kotlinType2 = this.refineType((KotlinType)it);
            collection2.add(kotlinType2);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @TypeRefinement
    @Nullable
    public ClassifierDescriptor refineDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2 instanceof ClassifierDescriptorWithTypeParameters)) {
            return null;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.moduleDescriptor, classId2);
    }

    @Override
    @TypeRefinement
    @Nullable
    public ClassDescriptor findClassAcrossModuleDependencies(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(this.moduleDescriptor, classId);
    }

    @Override
    @TypeRefinement
    public boolean isRefinementNeededForModule(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        return this.moduleDescriptor != moduleDescriptor;
    }

    @Override
    @TypeRefinement
    public boolean isRefinementNeededForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        ClassifierDescriptor classifierDescriptor2 = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor2 == null) {
            return this.areThereExpectSupertypes(typeConstructor2);
        }
        ClassifierDescriptor owner = classifierDescriptor = classifierDescriptor2;
        return this.isRefinementNeededForTypeConstructorCache.computeIfAbsent(owner, new Function0<Boolean>(this, typeConstructor2){
            final /* synthetic */ KotlinTypeRefinerImpl this$0;
            final /* synthetic */ TypeConstructor $typeConstructor;
            {
                this.this$0 = $receiver;
                this.$typeConstructor = $typeConstructor;
                super(0);
            }

            public final boolean invoke() {
                return KotlinTypeRefinerImpl.access$areThereExpectSupertypes(this.this$0, this.$typeConstructor);
            }
        });
    }

    @Override
    @TypeRefinement
    @NotNull
    public <S extends MemberScope> S getOrPutScopeForClass(@NotNull ClassDescriptor classDescriptor2, @NotNull Function0<? extends S> compute) {
        Intrinsics.checkNotNullParameter(classDescriptor2, "classDescriptor");
        Intrinsics.checkNotNullParameter(compute, "compute");
        return (S)((MemberScope)this.scopes.computeIfAbsent(classDescriptor2, compute));
    }

    private final boolean areThereExpectSupertypes(TypeConstructor $this$areThereExpectSupertypes) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        areThereExpectSupertypes.1 var3_3 = areThereExpectSupertypes.1.INSTANCE;
        DFS.dfs((Collection)CollectionsKt.listOf($this$areThereExpectSupertypes), new KotlinTypeRefinerImplKt.sam.org_jetbrains_kotlin_utils_DFS_Neighbors.0(var3_3), new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<TypeConstructor, Unit>(this, result2){
            final /* synthetic */ KotlinTypeRefinerImpl this$0;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public boolean beforeChildren(@NotNull TypeConstructor current2) {
                ClassifierDescriptor classifierDescriptor;
                Intrinsics.checkNotNullParameter(current2, "current");
                if (KotlinTypeRefinerImplKt.access$isExpectClass(current2) && !Intrinsics.areEqual((classifierDescriptor = current2.getDeclarationDescriptor()) == null ? null : DescriptorUtilsKt.getModule(classifierDescriptor), KotlinTypeRefinerImpl.access$getModuleDescriptor$p(this.this$0))) {
                    this.$result.element = true;
                    return false;
                }
                return true;
            }

            public void result() {
            }
        });
        return result2.element;
    }

    public static final /* synthetic */ boolean access$areThereExpectSupertypes(KotlinTypeRefinerImpl $this, TypeConstructor $receiver) {
        return $this.areThereExpectSupertypes($receiver);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(KotlinTypeRefinerImpl $this) {
        return $this.moduleDescriptor;
    }
}

