/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J/\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirApplySupertypesTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;)V", "getResolvedSupertypeRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
final class FirApplySupertypesTransformer
extends FirDefaultTransformer {
    private final SupertypeComputationSession supertypeComputationSession;

    @Override
    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, "element");
        E $this$compose$iv = element;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(file2, "file");
        file2.replaceResolvePhase(FirResolvePhase.SUPER_TYPES);
        FirElement firElement = file2.transformChildren(this, null);
        if (firElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
        }
        FirElement $this$compose$iv = (FirFile)firElement;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirStatement> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            Iterable $this$any$iv = regularClass.getSuperTypeRefs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof FirResolvedTypeRef))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            List<FirTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(regularClass);
            regularClass.replaceSuperTypeRefs(supertypeRefs);
            regularClass.replaceResolvePhase(FirResolvePhase.SUPER_TYPES);
        }
        FirElement firElement = regularClass.transformChildren(this, null);
        if (firElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        }
        FirElement $this$compose$iv = (FirRegularClass)firElement;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    private final List<FirTypeRef> getResolvedSupertypeRefs(FirClassLikeDeclaration<?> classLikeDeclaration) {
        SupertypeComputationStatus status2 = this.supertypeComputationSession.getSupertypesComputationStatus(classLikeDeclaration);
        boolean bl = status2 instanceof SupertypeComputationStatus.Computed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unexpected status at FirApplySupertypesTransformer: " + status2 + " for " + classLikeDeclaration.getSymbol().getClassId();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
            FirElement $this$compose$iv = typeAlias;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        List<FirTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(typeAlias);
        boolean $i$f$compose = supertypeRefs.size() == 1;
        boolean bl = false;
        if (_Assertions.ENABLED && !$i$f$compose) {
            boolean bl2 = false;
            String string2 = "Expected single supertypeRefs, but found " + supertypeRefs.size() + " in " + typeAlias.getSymbol().getClassId();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        typeAlias.replaceExpandedTypeRef(supertypeRefs.get(0));
        typeAlias.replaceResolvePhase(FirResolvePhase.SUPER_TYPES);
        FirElement $this$compose$iv = typeAlias;
        boolean $i$f$compose2 = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    public FirApplySupertypesTransformer(@NotNull SupertypeComputationSession supertypeComputationSession) {
        Intrinsics.checkNotNullParameter(supertypeComputationSession, "supertypeComputationSession");
        this.supertypeComputationSession = supertypeComputationSession;
    }
}

