/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirReceiversKt;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001cJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "S", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "boundSymbol", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getBoundSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "<set-?>", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "implicitScope", "getImplicitScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getReceiverExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "replaceType", "", "replaceType$resolve", "scope", "resolve"})
public abstract class ImplicitReceiverValue<S extends AbstractFirBasedSymbol<?>>
implements ReceiverValue {
    @NotNull
    private ConeKotlinType type;
    @Nullable
    private FirScope implicitScope;
    @NotNull
    private final FirExpression receiverExpression;
    @NotNull
    private final S boundSymbol;
    private final FirSession useSiteSession;
    private final ScopeSession scopeSession;

    @Override
    @NotNull
    public final ConeKotlinType getType() {
        return this.type;
    }

    @Nullable
    public final FirScope getImplicitScope() {
        return this.implicitScope;
    }

    @Override
    @Nullable
    public FirScope scope(@NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkParameterIsNotNull(useSiteSession, "useSiteSession");
        Intrinsics.checkParameterIsNotNull(scopeSession, "scopeSession");
        return this.implicitScope;
    }

    @Override
    @NotNull
    public FirExpression getReceiverExpression() {
        return this.receiverExpression;
    }

    public final void replaceType$resolve(@NotNull ConeKotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        if (Intrinsics.areEqual(type2, this.type)) {
            return;
        }
        this.type = type2;
        this.implicitScope = ScopeUtilsKt.scope(type2, this.useSiteSession, this.scopeSession);
    }

    @NotNull
    public final S getBoundSymbol() {
        return this.boundSymbol;
    }

    public ImplicitReceiverValue(@NotNull S boundSymbol, @NotNull ConeKotlinType type2, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkParameterIsNotNull(boundSymbol, "boundSymbol");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(useSiteSession, "useSiteSession");
        Intrinsics.checkParameterIsNotNull(scopeSession, "scopeSession");
        this.boundSymbol = boundSymbol;
        this.useSiteSession = useSiteSession;
        this.scopeSession = scopeSession;
        this.type = type2;
        this.implicitScope = ScopeUtilsKt.scope(type2, this.useSiteSession, this.scopeSession);
        this.receiverExpression = FirReceiversKt.access$receiverExpression(this.boundSymbol, type2);
    }
}

