/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiStatement psiStatement = this.myStatement;
        if (psiStatement == null) {
            PsiLabelReference.$$$reportNull$$$0(0);
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        int start = this.myIdentifier.getStartOffsetInParent();
        TextRange textRange = new TextRange(start, this.myIdentifier.getTextLength() + start);
        if (textRange == null) {
            PsiLabelReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Override
    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        for (PsiElement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof PsiLabeledStatement) || !label.equals(((PsiLabeledStatement)context).getName())) continue;
            return context;
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getElement().getText();
        if (string == null) {
            PsiLabelReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiLabelReference.$$$reportNull$$$0(3);
        }
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiLabelReference.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiLabeledStatement)) {
            throw new IncorrectOperationException("Can't bind to non-labeled statement");
        }
        return this.handleElementRename(((PsiLabeledStatement)element).getName());
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiLabelReference.$$$reportNull$$$0(5);
        }
        return this.resolve() == element;
    }

    @NotNull
    public String[] getVariants() {
        String[] stringArray = ArrayUtil.toStringArray(PsiImplUtil.findAllEnclosingLabels(this.myStatement));
        if (stringArray == null) {
            PsiLabelReference.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiLabelReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiLabelReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

