/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.m2;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.License;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.XMLHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader {
    private static final String PACKAGING = "packaging";
    private static final String DEPENDENCY = "dependency";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY_MGT = "dependencyManagement";
    private static final String PROJECT = "project";
    private static final String MODEL = "model";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String DESCRIPTION = "description";
    private static final String HOMEPAGE = "url";
    private static final String LICENSES = "licenses";
    private static final String LICENSE = "license";
    private static final String LICENSE_NAME = "name";
    private static final String LICENSE_URL = "url";
    private static final String PARENT = "parent";
    private static final String SCOPE = "scope";
    private static final String CLASSIFIER = "classifier";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions";
    private static final String EXCLUSION = "exclusion";
    private static final String DISTRIBUTION_MGT = "distributionManagement";
    private static final String RELOCATION = "relocation";
    private static final String PROPERTIES = "properties";
    private static final String PLUGINS = "plugins";
    private static final String PLUGIN = "plugin";
    private static final String TYPE = "type";
    private HashMap properties = new HashMap();
    private final Element projectElement;
    private final Element parentElement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomReader(URL descriptorURL, Resource res) throws IOException, SAXException {
        AddDTDFilterInputStream stream = new AddDTDFilterInputStream(URLHandlerRegistry.getDefault().openStream(descriptorURL));
        InputSource source = new InputSource(stream);
        source.setSystemId(XMLHelper.toSystemId(descriptorURL));
        try {
            Document pomDomDoc = XMLHelper.parseToDom(source, new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.endsWith("m2-entities.ent")) {
                        return new InputSource(PomReader.class.getResourceAsStream("m2-entities.ent"));
                    }
                    return null;
                }
            });
            this.projectElement = pomDomDoc.getDocumentElement();
            if (!PROJECT.equals(this.projectElement.getNodeName()) && !MODEL.equals(this.projectElement.getNodeName())) {
                throw new SAXParseException("project must be the root tag", res.getName(), res.getName(), 0, 0);
            }
            this.parentElement = PomReader.getFirstChildElement(this.projectElement, PARENT);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String prop, String val) {
        if (!this.properties.containsKey(prop) && val != null) {
            this.properties.put(prop, val);
        }
    }

    public String getGroupId() {
        String groupId = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getParentGroupId() {
        String groupId = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getArtifactId() {
        String val = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getParentArtifactId() {
        String val = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getVersion() {
        String val = PomReader.getFirstChildText(this.projectElement, VERSION);
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getParentVersion() {
        String val = PomReader.getFirstChildText(this.parentElement, VERSION);
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getPackaging() {
        String val = PomReader.getFirstChildText(this.projectElement, PACKAGING);
        if (val == null) {
            val = "jar";
        }
        return val;
    }

    public String getHomePage() {
        String val = PomReader.getFirstChildText(this.projectElement, "url");
        if (val == null) {
            val = "";
        }
        return val;
    }

    public String getDescription() {
        String val = PomReader.getFirstChildText(this.projectElement, DESCRIPTION);
        if (val == null) {
            val = "";
        }
        return val.trim();
    }

    public License[] getLicenses() {
        Element licenses = PomReader.getFirstChildElement(this.projectElement, LICENSES);
        if (licenses == null) {
            return new License[0];
        }
        licenses.normalize();
        ArrayList<License> lics = new ArrayList<License>();
        for (Element license : PomReader.getAllChilds(licenses)) {
            if (!LICENSE.equals(license.getNodeName())) continue;
            String name = PomReader.getFirstChildText(license, LICENSE_NAME);
            String url = PomReader.getFirstChildText(license, "url");
            if (name == null && url == null) continue;
            if (name == null) {
                name = "Unknown License";
            }
            lics.add(new License(name, url));
        }
        return lics.toArray(new License[lics.size()]);
    }

    public ModuleRevisionId getRelocation() {
        Element distrMgt = PomReader.getFirstChildElement(this.projectElement, DISTRIBUTION_MGT);
        Element relocation = PomReader.getFirstChildElement(distrMgt, RELOCATION);
        if (relocation == null) {
            return null;
        }
        String relocGroupId = PomReader.getFirstChildText(relocation, GROUP_ID);
        String relocArtId = PomReader.getFirstChildText(relocation, ARTIFACT_ID);
        String relocVersion = PomReader.getFirstChildText(relocation, VERSION);
        relocGroupId = relocGroupId == null ? this.getGroupId() : relocGroupId;
        relocArtId = relocArtId == null ? this.getArtifactId() : relocArtId;
        relocVersion = relocVersion == null ? this.getVersion() : relocVersion;
        return ModuleRevisionId.newInstance(relocGroupId, relocArtId, relocVersion);
    }

    public List getDependencies() {
        Element dependenciesElement = PomReader.getFirstChildElement(this.projectElement, DEPENDENCIES);
        LinkedList<PomDependencyData> dependencies2 = new LinkedList<PomDependencyData>();
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                dependencies2.add(new PomDependencyData((Element)node));
            }
        }
        return dependencies2;
    }

    public List getDependencyMgt() {
        Element dependenciesElement = PomReader.getFirstChildElement(this.projectElement, DEPENDENCY_MGT);
        dependenciesElement = PomReader.getFirstChildElement(dependenciesElement, DEPENDENCIES);
        LinkedList<PomDependencyMgtElement> dependencies2 = new LinkedList<PomDependencyMgtElement>();
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                dependencies2.add(new PomDependencyMgtElement((Element)node));
            }
        }
        return dependencies2;
    }

    public List getPlugins() {
        LinkedList<PomPluginElement> plugins = new LinkedList<PomPluginElement>();
        Element buildElement = PomReader.getFirstChildElement(this.projectElement, "build");
        if (buildElement == null) {
            return plugins;
        }
        Element pluginsElement = PomReader.getFirstChildElement(buildElement, PLUGINS);
        if (pluginsElement != null) {
            NodeList childs = pluginsElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !PLUGIN.equals(node.getNodeName())) continue;
                plugins.add(new PomPluginElement((Element)node));
            }
        }
        return plugins;
    }

    public Map getPomProperties() {
        HashMap<String, String> pomProperties = new HashMap<String, String>();
        Element propsEl = PomReader.getFirstChildElement(this.projectElement, PROPERTIES);
        if (propsEl != null) {
            propsEl.normalize();
        }
        for (Element prop : PomReader.getAllChilds(propsEl)) {
            pomProperties.put(prop.getNodeName(), PomReader.getTextContent(prop));
        }
        return pomProperties;
    }

    private String replaceProps(String val) {
        if (val == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(val, this.properties).trim();
    }

    private static String getTextContent(Element element) {
        StringBuffer result = new StringBuffer();
        NodeList childNodes = element.getChildNodes();
        block3: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    result.append(child.getNodeValue());
                    continue block3;
                }
            }
        }
        return result.toString();
    }

    private static String getFirstChildText(Element parentElem, String name) {
        Element node = PomReader.getFirstChildElement(parentElem, name);
        if (node != null) {
            return PomReader.getTextContent(node);
        }
        return null;
    }

    private static Element getFirstChildElement(Element parentElem, String name) {
        if (parentElem == null) {
            return null;
        }
        NodeList childs = parentElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element) || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List getAllChilds(Element parent) {
        LinkedList<Node> r = new LinkedList<Node>();
        if (parent != null) {
            NodeList childs = parent.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element)) continue;
                r.add(node);
            }
        }
        return r;
    }

    private static final class AddDTDFilterInputStream
    extends FilterInputStream {
        private static final int MARK = 10000;
        private static final String DOCTYPE = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n";
        private int count;
        private byte[] prefix = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n".getBytes();

        private AddDTDFilterInputStream(InputStream in) throws IOException {
            super(new BufferedInputStream(in));
            this.in.mark(10000);
            int byte1 = this.in.read();
            int byte2 = this.in.read();
            int byte3 = this.in.read();
            if (byte1 == 239 && byte2 == 187 && byte3 == 191) {
                this.in.mark(10000);
            } else {
                this.in.reset();
            }
            int bytesToSkip = 0;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.in, "UTF-8"), 100);
            String firstLine = reader.readLine();
            if (firstLine != null) {
                String trimmed = firstLine.trim();
                if (trimmed.startsWith("<?xml ")) {
                    int endIndex = trimmed.indexOf("?>");
                    String xmlDecl = trimmed.substring(0, endIndex + 2);
                    this.prefix = (xmlDecl + "\n" + DOCTYPE).getBytes();
                    bytesToSkip = xmlDecl.getBytes().length;
                }
            } else {
                this.prefix = new byte[0];
            }
            this.in.reset();
            for (int i = 0; i < bytesToSkip; ++i) {
                this.in.read();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.count < this.prefix.length) {
                return this.prefix[this.count++];
            }
            int result = super.read();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int nbrBytesCopied = 0;
            if (this.count < this.prefix.length) {
                int nbrBytesFromPrefix = Math.min(this.prefix.length - this.count, len);
                System.arraycopy(this.prefix, this.count, b, off, nbrBytesFromPrefix);
                nbrBytesCopied = nbrBytesFromPrefix;
            }
            if (nbrBytesCopied < len) {
                nbrBytesCopied += this.in.read(b, off + nbrBytesCopied, len - nbrBytesCopied);
            }
            this.count += nbrBytesCopied;
            return nbrBytesCopied;
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        public PomDependencyData(PomDependencyData copyFrom) {
            this(copyFrom.depElement);
        }

        PomDependencyData(Element depElement) {
            super(depElement);
            this.depElement = depElement;
        }

        @Override
        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.SCOPE);
            return PomReader.this.replaceProps(val);
        }

        public String getClassifier() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.CLASSIFIER);
            return PomReader.this.replaceProps(val);
        }

        public String getType() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.TYPE);
            return PomReader.this.replaceProps(val);
        }

        public boolean isOptional() {
            Element e = PomReader.getFirstChildElement(this.depElement, PomReader.OPTIONAL);
            return e != null && "true".equalsIgnoreCase(PomReader.getTextContent(e));
        }
    }

    public class PomPluginElement
    implements PomDependencyMgt {
        private Element pluginElement;

        PomPluginElement(Element pluginElement) {
            this.pluginElement = pluginElement;
        }

        @Override
        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.pluginElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.pluginElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomReader.getFirstChildText(this.pluginElement, PomReader.VERSION);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List getExcludedModules() {
            return Collections.EMPTY_LIST;
        }
    }

    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        public PomDependencyMgtElement(PomDependencyMgtElement copyFrom) {
            this(copyFrom.depElement);
        }

        PomDependencyMgtElement(Element depElement) {
            this.depElement = depElement;
        }

        @Override
        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.VERSION);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.SCOPE);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public List getExcludedModules() {
            Element exclusionsElement = PomReader.getFirstChildElement(this.depElement, PomReader.EXCLUSIONS);
            LinkedList<ModuleId> exclusions = new LinkedList<ModuleId>();
            if (exclusionsElement != null) {
                NodeList childs = exclusionsElement.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    if (!(node instanceof Element) || !PomReader.EXCLUSION.equals(node.getNodeName())) continue;
                    String groupId = PomReader.getFirstChildText((Element)node, PomReader.GROUP_ID);
                    String artifactId = PomReader.getFirstChildText((Element)node, PomReader.ARTIFACT_ID);
                    if (groupId == null || artifactId == null) continue;
                    exclusions.add(ModuleId.newInstance(groupId, artifactId));
                }
            }
            return exclusions;
        }
    }
}

