/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InconsistentOperatorFromJavaCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "CONCURRENT_HASH_MAP_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class InconsistentOperatorFromJavaCallChecker
implements CallChecker {
    private static final FqName CONCURRENT_HASH_MAP_FQ_NAME;
    public static final InconsistentOperatorFromJavaCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Object candidateDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object obj = candidateDescriptor = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "candidateDescriptor");
        if (Intrinsics.areEqual(obj.getName(), OperatorNameConventions.CONTAINS) ^ true) {
            return;
        }
        List<ValueParameterDescriptor> list2 = candidateDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "candidateDescriptor.valueParameters");
        Annotated annotated = CollectionsKt.singleOrNull(list2);
        if (annotated == null || (annotated = annotated.getType()) == null || !TypeUtilsKt.isAnyOrNullableAny((KotlinType)annotated)) {
            return;
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        if (!(call2.getCallElement() instanceof KtBinaryExpression) || !resolvedCall2.getStatus().possibleTransformToSuccess()) {
            return;
        }
        Iterator<?> iterator2 = DescriptorUtilsKt.overriddenTreeUniqueAsSequence(candidateDescriptor, false).iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor containingClass;
            CallableDescriptor callableDescriptor;
            CallableDescriptor callableDescriptor2 = callableDescriptor = (CallableDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor2, "callableDescriptor");
            DeclarationDescriptor declarationDescriptor = callableDescriptor2.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                continue;
            }
            if (Intrinsics.areEqual(DescriptorUtilsKt.fqNameOrNull(containingClass), CONCURRENT_HASH_MAP_FQ_NAME) ^ true) continue;
            DiagnosticFactory0<PsiElement> diagnosticFactory = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitConcurrentHashMapContains) ? ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR_ERROR : ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR;
            context.getTrace().report(diagnosticFactory.on(reportOn));
            break;
        }
    }

    private InconsistentOperatorFromJavaCallChecker() {
    }

    static {
        InconsistentOperatorFromJavaCallChecker inconsistentOperatorFromJavaCallChecker;
        INSTANCE = inconsistentOperatorFromJavaCallChecker = new InconsistentOperatorFromJavaCallChecker();
        CONCURRENT_HASH_MAP_FQ_NAME = new FqName("java.util.concurrent.ConcurrentHashMap");
    }
}

