/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u0002H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u001a\u0010\u0016\u001a\u00020\n*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001b\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "reportInlineFunction", "", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "descriptor", "translatedFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sourceInfo", "Lcom/intellij/psi/PsiElement;", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "outerContext", "js.translator"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $this$translateAndAliasParameters, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        boolean bl;
        Object object;
        JsParameter suggestedName;
        Collection paramNameForType;
        Intrinsics.checkParameterIsNotNull($this$translateAndAliasParameters, "$this$translateAndAliasParameters");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(targetList2, "targetList");
        boolean bl2 = false;
        Map aliases = new LinkedHashMap();
        Iterator<TypeParameterDescriptor> iterator2 = FunctionTranslatorKt.getCorrectTypeParameters(descriptor2).iterator();
        while (iterator2.hasNext()) {
            JsName paramName;
            TypeParameterDescriptor type2;
            TypeParameterDescriptor typeParameterDescriptor = type2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "type");
            if (!typeParameterDescriptor.isReified()) continue;
            Intrinsics.checkExpressionValueIsNotNull($this$translateAndAliasParameters.getNameForDescriptor(type2), "getNameForDescriptor(type)");
            Collection collection = targetList2;
            JsParameter jsParameter = new JsParameter((JsName)((Object)paramNameForType));
            boolean bl3 = false;
            collection.add(jsParameter);
            Intrinsics.checkExpressionValueIsNotNull(Namer.isInstanceSuggestedName(type2), "Namer.isInstanceSuggestedName(type)");
            Intrinsics.checkExpressionValueIsNotNull(JsScope.declareTemporaryName((String)((Object)suggestedName)), "JsScope.declareTemporaryName(suggestedName)");
            object = targetList2;
            JsParameter jsParameter2 = new JsParameter(paramName);
            bl = false;
            object.add(jsParameter2);
            JsNameRef jsNameRef = paramName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "paramName.makeRef()");
            aliases.put(type2, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkExpressionValueIsNotNull(jsName, "JsScope.declareTemporary\u2026tReceiverParameterName())");
            JsName receiverParameterName = jsName;
            JsNameRef jsNameRef = receiverParameterName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "receiverParameterName.makeRef()");
            JsNameRef receiverRef = jsNameRef;
            JsExpression jsExpression = receiverRef;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "descriptor.extensionReceiverParameter!!");
            MetadataProperties.setType(jsExpression, receiverParameterDescriptor.getType());
            ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor2, "descriptor.extensionReceiverParameter!!");
            aliases.put(receiverParameterDescriptor2, receiverRef);
            paramNameForType = targetList2;
            suggestedName = new JsParameter(receiverParameterName);
            boolean bl4 = false;
            paramNameForType.add(suggestedName);
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            JsName tmpName;
            JsName name;
            Intrinsics.checkExpressionValueIsNotNull($this$translateAndAliasParameters.getNameForDescriptor(valueParameter), "getNameForDescriptor(valueParameter)");
            Object object2 = JsScope.declareTemporaryName(name.getIdent());
            boolean bl5 = false;
            boolean bl6 = false;
            JsName it = object2;
            boolean bl7 = false;
            JsName jsName = it;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "it");
            MetadataProperties.setDescriptor(jsName, (DeclarationDescriptor)valueParameter);
            Intrinsics.checkExpressionValueIsNotNull(object2, "JsScope.declareTemporary\u2026riptor = valueParameter }");
            ValueParameterDescriptor valueParameterDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "valueParameter");
            JsNameRef jsNameRef = JsAstUtils.pureFqn(tmpName, null);
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(tmpName, null)");
            aliases.put(valueParameterDescriptor, jsNameRef);
            object2 = targetList2;
            object = new JsParameter(tmpName);
            bl6 = false;
            bl = false;
            Object $this$apply = object;
            boolean bl8 = false;
            MetadataProperties.setHasDefaultValue((JsParameter)$this$apply, ArgumentsUtilsKt.hasDefaultValue(valueParameter));
            bl6 = false;
            object2.add(object);
        }
        ValueParameterDescriptor continuationDescriptor = $this$translateAndAliasParameters.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter = new JsParameter($this$translateAndAliasParameters.getNameForDescriptor(continuationDescriptor));
            Collection collection = targetList2;
            boolean bl9 = false;
            collection.add(jsParameter);
            JsExpression jsExpression = JsAstUtils.stateMachineReceiver();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.stateMachineReceiver()");
            aliases.put(continuationDescriptor, jsExpression);
        }
        TranslationContext translationContext = $this$translateAndAliasParameters.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(@NotNull FunctionDescriptor $this$getCorrectTypeParameters) {
        List<TypeParameterDescriptor> list2;
        FunctionDescriptor functionDescriptor = $this$getCorrectTypeParameters;
        if (!(functionDescriptor instanceof PropertyAccessorDescriptor)) {
            functionDescriptor = null;
        }
        if ((list2 = (PropertyAccessorDescriptor)functionDescriptor) == null || (list2 = list2.getCorrespondingProperty()) == null || (list2 = list2.getTypeParameters()) == null) {
            list2 = $this$getCorrectTypeParameters.getTypeParameters();
        }
        Intrinsics.checkExpressionValueIsNotNull(list2, "(this as? PropertyAccess\u2026ameters ?: typeParameters");
        return list2;
    }

    private static final boolean getRequiresExtensionReceiverParameter(@NotNull FunctionDescriptor $this$requiresExtensionReceiverParameter) {
        return DescriptorUtils.isExtension($this$requiresExtensionReceiverParameter);
    }

    public static final void translateFunction(@NotNull TranslationContext $this$translateFunction, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull($this$translateFunction, "$this$translateFunction");
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor($this$translateFunction.bindingContext(), declaration);
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "BindingUtils.getFunction\u2026ngContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (declaration.hasBody()) {
            JsBlock jsBlock = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, $this$translateFunction);
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "translateFunctionBody(de\u2026iptor, declaration, this)");
            JsBlock body = jsBlock;
            JsBlock jsBlock2 = function2.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock2, "function.body");
            Collection collection = jsBlock2.getStatements();
            List<JsStatement> list2 = body.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "body.statements");
            Iterable iterable = list2;
            boolean bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $this$wrapWithInlineMetadata, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($this$wrapWithInlineMetadata, "$this$wrapWithInlineMetadata");
        Intrinsics.checkParameterIsNotNull(outerContext, "outerContext");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "descriptor.source");
        PsiElement sourceInfo = KotlinSourceElementKt.getPsi(sourceElement);
        if (descriptor2.isInline()) {
            IncrementalResultsConsumer incrementalResults;
            boolean bl;
            JsExpression jsExpression2;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            JsConfig jsConfig = $this$wrapWithInlineMetadata.getConfig();
            Intrinsics.checkExpressionValueIsNotNull(jsConfig, "config");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) {
                InlineMetadata metadata2 = InlineMetadata.Companion.compose(function2, descriptor2, $this$wrapWithInlineMetadata);
                jsExpression2 = metadata2.functionWithMetadata(outerContext, sourceInfo);
            } else {
                InlineFunctionContext inlineFunctionContext = $this$wrapWithInlineMetadata.getInlineFunctionContext();
                if (inlineFunctionContext == null) {
                    Intrinsics.throwNpe();
                }
                InlineFunctionContext inlineFunctionContext2 = inlineFunctionContext;
                bl = false;
                boolean bl2 = false;
                InlineFunctionContext it = inlineFunctionContext2;
                boolean bl3 = false;
                List<JsStatement> list2 = it.getImportBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list2, "it.importBlock.statements");
                Collection collection = list2;
                List<JsStatement> list3 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list3, "it.prototypeBlock.statements");
                Collection collection2 = CollectionsKt.plus(collection, (Iterable)list3);
                List<JsStatement> list4 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list4, "it.declarationsBlock.statements");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus(collection2, (Iterable)list4), new JsReturn(function2)));
                jsExpression2 = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
            JsExpression jsExpression3 = jsExpression2;
            boolean bl4 = false;
            bl = false;
            JsExpression it = jsExpression3;
            boolean bl5 = false;
            JsConfig jsConfig2 = $this$wrapWithInlineMetadata.getConfig();
            Intrinsics.checkExpressionValueIsNotNull(jsConfig2, "config");
            IncrementalResultsConsumer incrementalResultsConsumer = incrementalResults = jsConfig2.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
            if (incrementalResultsConsumer != null) {
                FunctionTranslatorKt.reportInlineFunction(incrementalResultsConsumer, descriptor2, it, sourceInfo);
            }
            jsExpression = jsExpression3;
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private static final void reportInlineFunction(@NotNull IncrementalResultsConsumer $this$reportInlineFunction, FunctionDescriptor descriptor2, JsExpression translatedFunction, PsiElement sourceInfo) {
        String string;
        Object object;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "descriptor.source");
        SourceFile sourceFile = sourceElement.getContainingFile();
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((object = (PsiSourceFile)sourceFile) == null || (object = ((PsiSourceFile)object).getPsiFile()) == null) {
            return;
        }
        Object psiFile = object;
        File file2 = VfsUtilCore.virtualToIoFile(psiFile.getVirtualFile());
        Intrinsics.checkExpressionValueIsNotNull(file2, "VfsUtilCore.virtualToIoFile(psiFile.virtualFile)");
        File file3 = file2;
        Visibility visibility = descriptor2.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "descriptor.visibility");
        if (EffectiveVisibilityKt.effectiveVisibility(visibility, descriptor2, true).getPrivateApi()) {
            return;
        }
        FunctionDescriptor functionDescriptor = descriptor2;
        if (functionDescriptor instanceof PropertyGetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<get>");
            PropertyDescriptor propertyDescriptor2 = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor2, "descriptor.correspondingProperty");
            string = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor2).asString()).toString();
        } else if (functionDescriptor instanceof PropertySetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<set>");
            PropertyDescriptor propertyDescriptor3 = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor3, "descriptor.correspondingProperty");
            string = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor3).asString()).toString();
        } else {
            String string2 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "descriptor.fqNameSafe.asString()");
        }
        String fqName2 = string;
        UserDataHolder userDataHolder = sourceInfo;
        Integer offset2 = userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? Integer.valueOf(userDataHolder.getStartOffset()) : null;
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull(fileViewProvider, "psiFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        int sourceLine = -1;
        int sourceColumn = -1;
        if (offset2 != null && document != null) {
            sourceLine = document.getLineNumber(offset2);
            sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
        }
        $this$reportInlineFunction.processInlineFunction(file3, fqName2, translatedFunction, sourceLine, sourceColumn);
    }
}

