/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.ClasspathChanged;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache;
import org.jetbrains.kotlin.kapt3.base.incremental.SourcesToReprocess;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aJ\b\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\u0014\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCacheManager;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "classpathFqNamesHistory", "(Ljava/io/File;Ljava/io/File;)V", "aptCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalAptCache;", "aptCacheFile", "closed", "", "getFile", "()Ljava/io/File;", "javaCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "getJavaCache$kotlin_annotation_processing_base", "()Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "javaCacheFile", "lastBuildTimestamp", "close", "", "getDirtyFqNamesFromClasspath", "Lorg/jetbrains/kotlin/kapt3/base/incremental/ClasspathChanged;", "invalidateAndGetDirtyFiles", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourcesToReprocess;", "changedSources", "", "maybeGetAptCacheFromFile", "maybeGetJavaCacheFromFile", "updateCache", "processors", "", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "kotlin-annotation-processing-base"})
public final class JavaClassCacheManager
implements Closeable {
    private final File javaCacheFile;
    @NotNull
    private final JavaClassCache javaCache;
    private final File aptCacheFile;
    private final IncrementalAptCache aptCache;
    private final File lastBuildTimestamp;
    private boolean closed;
    @NotNull
    private final File file;
    private final File classpathFqNamesHistory;

    @NotNull
    public final JavaClassCache getJavaCache$kotlin_annotation_processing_base() {
        return this.javaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ClasspathChanged getDirtyFqNamesFromClasspath() {
        void before;
        if (!this.lastBuildTimestamp.exists()) {
            return ClasspathChanged.FullRebuild.INSTANCE;
        }
        String lastTimestamp = FilesKt.readText$default((File)this.lastBuildTimestamp, null, (int)1, null);
        File[] fileArray = this.classpathFqNamesHistory.listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"classpathFqNamesHistory.listFiles()");
        File[] $this$partition$iv22 = fileArray;
        boolean $i$f$partition = false;
        ArrayList<File> first$iv = new ArrayList<File>();
        ArrayList<File> second$iv = new ArrayList<File>();
        File[] fileArray2 = $this$partition$iv22;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File it = element$iv = fileArray2[i];
            boolean bl = false;
            File file = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            if (file.getName().compareTo(lastTimestamp) < 0) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List list = (List)pair.component1();
        List after = (List)pair.component2();
        if (before.isEmpty()) {
            return ClasspathChanged.FullRebuild.INSTANCE;
        }
        boolean $this$partition$iv22 = false;
        Set dirtyFqNames = new LinkedHashSet();
        Iterable $this$forEach$iv = after;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            Object object = file2;
            int n2 = 0;
            InputStream inputStream = new FileInputStream((File)object);
            object = inputStream;
            n2 = 8192;
            boolean bl2 = false;
            inputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n2);
            InputStream inputStream2 = inputStream;
            object = new ObjectInputStream(inputStream2);
            n2 = 0;
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object;
                boolean bl3 = false;
                Object object2 = it.readObject();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<kotlin.String>");
                }
                boolean bl4 = dirtyFqNames.addAll((Collection)object2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        Collection collection = dirtyFqNames;
        boolean bl = false;
        return !collection.isEmpty() ? (ClasspathChanged)ClasspathChanged.FullRebuild.INSTANCE : (ClasspathChanged)new ClasspathChanged.Incremental(dirtyFqNames);
    }

    public final void updateCache(@NotNull List<IncrementalProcessor> processors) {
        Intrinsics.checkParameterIsNotNull(processors, (String)"processors");
        if (!this.aptCache.updateCache(processors)) {
            this.javaCache.invalidateAll$kotlin_annotation_processing_base();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final SourcesToReprocess invalidateAndGetDirtyFiles(@NotNull Collection<? extends File> changedSources) {
        SourcesToReprocess sourcesToReprocess;
        Intrinsics.checkParameterIsNotNull(changedSources, (String)"changedSources");
        if (!this.aptCache.isIncremental()) {
            return SourcesToReprocess.FullRebuild.INSTANCE;
        }
        ClasspathChanged dirtyFqNamesFromClasspath = this.getDirtyFqNamesFromClasspath();
        ClasspathChanged classpathChanged = dirtyFqNamesFromClasspath;
        if (classpathChanged instanceof ClasspathChanged.FullRebuild) {
            sourcesToReprocess = SourcesToReprocess.FullRebuild.INSTANCE;
            return sourcesToReprocess;
        } else {
            if (!(classpathChanged instanceof ClasspathChanged.Incremental)) throw new NoWhenBranchMatchedException();
            Changes changes = new Changes(changedSources, ((ClasspathChanged.Incremental)dirtyFqNamesFromClasspath).getDirtyFqNames());
            SourcesToReprocess filesToReprocess = this.javaCache.invalidateEntriesForChangedFiles(changes);
            SourcesToReprocess sourcesToReprocess2 = filesToReprocess;
            if (sourcesToReprocess2 instanceof SourcesToReprocess.FullRebuild) {
                sourcesToReprocess = SourcesToReprocess.FullRebuild.INSTANCE;
                return sourcesToReprocess;
            } else {
                if (!(sourcesToReprocess2 instanceof SourcesToReprocess.Incremental)) throw new NoWhenBranchMatchedException();
                Set toReprocess = CollectionsKt.toMutableSet((Iterable)((SourcesToReprocess.Incremental)filesToReprocess).getToReprocess());
                List<File> isolatingGenerated = this.aptCache.invalidateIsolatingGenerated(toReprocess);
                Set generatedDirtyTypes = CollectionsKt.toMutableSet((Iterable)this.javaCache.invalidateGeneratedTypes(isolatingGenerated));
                if (!toReprocess.isEmpty()) {
                    List<File> aggregatingGenerated = this.aptCache.invalidateAggregating();
                    generatedDirtyTypes.addAll((Collection)this.javaCache.invalidateGeneratedTypes(aggregatingGenerated));
                    toReprocess.addAll((Collection)this.javaCache.invalidateEntriesAnnotatedWith(this.aptCache.getAggregatingClaimedAnnotations()));
                }
                sourcesToReprocess = new SourcesToReprocess.Incremental(CollectionsKt.toList((Iterable)toReprocess), generatedDirtyTypes);
            }
        }
        return sourcesToReprocess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IncrementalAptCache maybeGetAptCacheFromFile() {
        Serializable serializable;
        if (this.aptCacheFile.exists()) {
            Object object;
            try {
                IncrementalAptCache incrementalAptCache;
                object = this.aptCacheFile;
                boolean bl = false;
                FileInputStream fileInputStream = new FileInputStream((File)object);
                InputStream inputStream = fileInputStream;
                InputStream inputStream2 = new BufferedInputStream(inputStream);
                object = new ObjectInputStream(inputStream2);
                bl = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl2 = false;
                    Object object2 = it.readObject();
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache");
                    }
                    incrementalAptCache = (IncrementalAptCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = incrementalAptCache;
            }
            catch (Throwable e) {
                object = new IncrementalAptCache();
            }
            serializable = object;
        } else {
            serializable = new IncrementalAptCache();
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JavaClassCache maybeGetJavaCacheFromFile() {
        Serializable serializable;
        if (this.javaCacheFile.exists()) {
            Object object;
            try {
                JavaClassCache javaClassCache;
                object = this.javaCacheFile;
                boolean bl = false;
                FileInputStream fileInputStream = new FileInputStream((File)object);
                InputStream inputStream = fileInputStream;
                InputStream inputStream2 = new BufferedInputStream(inputStream);
                object = new ObjectInputStream(inputStream2);
                bl = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl2 = false;
                    Object object2 = it.readObject();
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache");
                    }
                    javaClassCache = (JavaClassCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = javaClassCache;
            }
            catch (Throwable e) {
                object = new JavaClassCache();
            }
            serializable = object;
        } else {
            serializable = new JavaClassCache();
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ObjectOutputStream it2;
        if (this.closed) {
            return;
        }
        File file = this.javaCacheFile;
        boolean bl = false;
        boolean bl2 = false;
        File $this$with = file;
        boolean bl3 = false;
        $this$with.delete();
        $this$with.getParentFile().mkdirs();
        Object object = $this$with;
        boolean bl4 = false;
        FileOutputStream fileOutputStream = new FileOutputStream((File)object);
        OutputStream outputStream = fileOutputStream;
        OutputStream outputStream2 = new BufferedOutputStream(outputStream);
        object = new ObjectOutputStream(outputStream2);
        bl4 = false;
        Throwable throwable = null;
        try {
            it2 = (ObjectOutputStream)object;
            boolean bl5 = false;
            it2.writeObject(this.javaCache);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        file = this.aptCacheFile;
        bl = false;
        bl2 = false;
        $this$with = file;
        boolean bl6 = false;
        $this$with.delete();
        $this$with.getParentFile().mkdirs();
        object = $this$with;
        bl4 = false;
        fileOutputStream = new FileOutputStream((File)object);
        OutputStream outputStream3 = fileOutputStream;
        OutputStream outputStream4 = new BufferedOutputStream(outputStream3);
        object = new ObjectOutputStream(outputStream4);
        bl4 = false;
        throwable = null;
        try {
            it2 = (ObjectOutputStream)object;
            boolean bl7 = false;
            it2.writeObject(this.aptCache);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        file = this.lastBuildTimestamp;
        bl = false;
        bl2 = false;
        $this$with = file;
        boolean bl8 = false;
        FilesKt.writeText$default((File)$this$with, (String)String.valueOf(System.currentTimeMillis()), null, (int)2, null);
        this.closed = true;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public JavaClassCacheManager(@NotNull File file, @NotNull File classpathFqNamesHistory) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)classpathFqNamesHistory, (String)"classpathFqNamesHistory");
        this.file = file;
        this.classpathFqNamesHistory = classpathFqNamesHistory;
        this.javaCacheFile = FilesKt.resolve((File)this.file, (String)"java-cache.bin");
        this.javaCache = this.maybeGetJavaCacheFromFile();
        this.aptCacheFile = FilesKt.resolve((File)this.file, (String)"apt-cache.bin");
        this.aptCache = this.maybeGetAptCacheFromFile();
        this.lastBuildTimestamp = FilesKt.resolve((File)this.file, (String)"last-build-ts.bin");
    }
}

