/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002J&\u0010\u0019\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J#\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010 J#\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010#J \u0010$\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lcom/intellij/psi/PsiElementFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinFinderMarker;", "project", "Lcom/intellij/openapi/project/Project;", "kotlinAsJavaSupport", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "findClass", "Lcom/intellij/psi/PsiClass;", "qualifiedName", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClasses", "", "qualifiedNameString", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "findClassesAndObjects", "", "Lorg/jetbrains/kotlin/name/FqName;", "answer", "", "findInterfaceDefaultImpls", "findPackage", "Lcom/intellij/psi/PsiPackage;", "getClassNames", "", "psiPackage", "getClasses", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "getPackageFiles", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiFile;", "getPackageFilesFilter", "Lcom/intellij/openapi/util/Condition;", "getSubPackages", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiPackage;", "Companion", "light-classes"})
public final class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    private final PsiManager psiManager;
    private final Project project;
    private final KotlinAsJavaSupport kotlinAsJavaSupport;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(qualifiedName, "qualifiedName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        return ArraysKt.firstOrNull(this.findClasses(qualifiedName, scope));
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(qualifiedNameString, "qualifiedNameString");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            Intrinsics.checkExpressionValueIsNotNull(PsiClass.EMPTY_ARRAY, "PsiClass.EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope, (List<PsiClass>)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName, scope));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName, scope));
        Collection collection = $receiver$iv = (Collection)JavaElementFinder.Companion.sortByClasspathPreferringNonFakeFiles(answer, scope);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[0]);
        if (psiClassArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiClassArray;
    }

    private final void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName, scope, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName, scope);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = LightClassUtilsKt.toLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private final void findInterfaceDefaultImpls(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        if (qualifiedName.isRoot()) {
            return;
        }
        if (Intrinsics.areEqual(qualifiedName.shortName().asString(), "DefaultImpls") ^ true) {
            return;
        }
        FqName fqName2 = qualifiedName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "qualifiedName.parent()");
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(fqName2, scope)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            if (!(classOrObject instanceof KtClass) || !((KtClass)classOrObject).isInterface()) continue;
            if (LightClassUtilsKt.toLightClass(classOrObject) == null) {
                continue;
            }
            if (interfaceClass.findInnerClassByName("DefaultImpls", false) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull(implsClass, "interfaceClass.findInner\u2026_NAME, false) ?: continue");
            answer.add(implsClass);
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(psiPackage, "psiPackage");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        HashSet<String> answer = Sets.newHashSet();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope));
        for (KtClassOrObject declaration : declarations2) {
            String name;
            if (declaration.getName() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull(name, "declaration.name ?: continue");
            answer.add(name);
        }
        HashSet<String> hashSet = answer;
        Intrinsics.checkExpressionValueIsNotNull(hashSet, "answer");
        return hashSet;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        Intrinsics.checkParameterIsNotNull(qualifiedNameString, "qualifiedNameString");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.project);
        Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "GlobalSearchScope.allScope(project)");
        GlobalSearchScope allScope = globalSearchScope;
        return this.kotlinAsJavaSupport.packageExists(fqName2, allScope) ? new KtLightPackage(this.psiManager, fqName2, allScope) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(psiPackage, "psiPackage");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(new FqName(psiPackage.getQualifiedName()), scope);
        Iterable iterable = $receiver$iv = (Iterable)subpackages;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            KtLightPackage ktLightPackage = new KtLightPackage(this.psiManager, (FqName)it, scope);
            collection.add(ktLightPackage);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        PsiPackage[] psiPackageArray = thisCollection$iv.toArray(new PsiPackage[0]);
        if (psiPackageArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(psiPackage, "psiPackage");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope));
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        for (KtClassOrObject declaration : declarations2) {
            KtLightClass aClass2;
            if (LightClassUtilsKt.toLightClass(declaration) == null) {
                continue;
            }
            answer.add(aClass2);
        }
        Collection collection = $receiver$iv = (Collection)JavaElementFinder.Companion.sortByClasspathPreferringNonFakeFiles(answer, scope);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[0]);
        if (psiClassArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Collection<KtFile> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(psiPackage, "psiPackage");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtFile> collection = $receiver$iv = this.kotlinAsJavaSupport.findFilesForPackage(packageFQN, scope);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection<KtFile> thisCollection$iv = collection;
        PsiFile[] psiFileArray = thisCollection$iv.toArray(new PsiFile[0]);
        if (psiFileArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiFileArray;
    }

    @Override
    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(psiPackage, "psiPackage");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        return new Condition<PsiFile>(psiPackage){
            final /* synthetic */ PsiPackage $psiPackage;

            public final boolean value(PsiFile input) {
                return !(input instanceof KtFile) ? true : Intrinsics.areEqual(this.$psiPackage.getQualifiedName(), ((KtFile)input).getPackageFqName().asString());
            }
            {
                this.$psiPackage = psiPackage;
            }
        };
    }

    public JavaElementFinder(@NotNull Project project, @NotNull KotlinAsJavaSupport kotlinAsJavaSupport) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(kotlinAsJavaSupport, "kotlinAsJavaSupport");
        this.project = project;
        this.kotlinAsJavaSupport = kotlinAsJavaSupport;
        PsiManager psiManager = PsiManager.getInstance(this.project);
        Intrinsics.checkExpressionValueIsNotNull(psiManager, "PsiManager.getInstance(project)");
        this.psiManager = psiManager;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion;", "", "()V", "byClasspathComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getInstance", "Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "project", "Lcom/intellij/openapi/project/Project;", "sortByClasspathPreferringNonFakeFiles", "", "Lcom/intellij/psi/PsiClass;", "light-classes"})
    public static final class Companion {
        @NotNull
        public final JavaElementFinder getInstance(@NotNull Project project) {
            PsiElementFinder[] extensions;
            Intrinsics.checkParameterIsNotNull(project, "project");
            ExtensionPoint<PsiElementFinder> extensionPoint = Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME);
            Intrinsics.checkExpressionValueIsNotNull(extensionPoint, "Extensions.getArea(proje\u2026PsiElementFinder.EP_NAME)");
            PsiElementFinder[] psiElementFinderArray = extensionPoint.getExtensions();
            Intrinsics.checkExpressionValueIsNotNull(psiElementFinderArray, "Extensions.getArea(proje\u2026inder.EP_NAME).extensions");
            for (PsiElementFinder extension : extensions = psiElementFinderArray) {
                if (!(extension instanceof JavaElementFinder)) continue;
                return (JavaElementFinder)extension;
            }
            throw (Throwable)new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
        }

        @NotNull
        public final Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkParameterIsNotNull(searchScope, "searchScope");
            return new Comparator<PsiElement>(searchScope){
                final /* synthetic */ GlobalSearchScope $searchScope;

                public final int compare(PsiElement o1, PsiElement o2) {
                    VirtualFile f2;
                    VirtualFile f1 = PsiUtilCore.getVirtualFile(o1);
                    return f1 == (f2 = PsiUtilCore.getVirtualFile(o2)) ? 0 : (f1 == null ? -1 : (f2 == null ? 1 : this.$searchScope.compare(f2, f1)));
                }
                {
                    this.$searchScope = globalSearchScope;
                }
            };
        }

        private final List<PsiClass> sortByClasspathPreferringNonFakeFiles(@NotNull List<? extends PsiClass> $receiver, GlobalSearchScope searchScope) {
            List<PsiClass> result2 = CollectionsKt.toMutableList((Collection)$receiver);
            ContainerUtil.quickSort(result2, this.byClasspathComparator(searchScope));
            List<PsiClass> $receiver$iv = result2;
            if ($receiver$iv.size() > 1) {
                List<PsiClass> list2 = $receiver$iv;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        PsiClass it = (PsiClass)a;
                        Comparable comparable = Boolean.valueOf(it instanceof FakeLightClassForFileOfPackage);
                        it = (PsiClass)b;
                        Comparable comparable2 = comparable;
                        Boolean bl = it instanceof FakeLightClassForFileOfPackage;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)bl);
                    }
                };
                CollectionsKt.sortWith(list2, comparator);
            }
            return result2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

