/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import com.sun.tools.javac.util.Context;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptFlags;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.base.kapt3.KaptOptionsKt;
import org.jetbrains.kotlin.kapt3.base.AnnotationProcessingKt;
import org.jetbrains.kotlin.kapt3.base.Kapt;
import org.jetbrains.kotlin.kapt3.base.KaptContext;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;
import org.jetbrains.kotlin.kapt3.base.util.WriterBackedKaptLogger;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/Kapt;", "", "()V", "JAVAC_CONTEXT_CLASS", "", "checkJavacComponentsAccess", "", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "findClassLoaderWithJavac", "Ljava/lang/ClassLoader;", "kapt", "options", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;", "kaptFlags", "Lorg/jetbrains/kotlin/base/kapt3/KaptFlags;", "rawFlags", "", "kotlin-annotation-processing-base"})
public final class Kapt {
    private static final String JAVAC_CONTEXT_CLASS = "com.sun.tools.javac.util.Context";
    public static final Kapt INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final KaptFlags kaptFlags(@NotNull Set<String> rawFlags) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(rawFlags, (String)"rawFlags");
        KaptFlag[] kaptFlagArray = KaptFlag.values();
        KaptFlags.Companion companion = KaptFlags.Companion;
        Collection collection = new LinkedHashSet();
        Collection collection2 = collection;
        for (void element$iv : $receiver$iv) {
            void destination$iv;
            void it = element$iv;
            if (!rawFlags.contains(it.name())) continue;
            destination$iv.add(element$iv);
        }
        collection = collection2;
        return companion.fromSet((Set<? extends KaptFlag>)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean kapt(@NotNull KaptOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        WriterBackedKaptLogger logger = new WriterBackedKaptLogger(options.get(KaptFlag.VERBOSE), null, null, null, 14, null);
        if (!INSTANCE.checkJavacComponentsAccess(logger)) {
            return false;
        }
        KaptContext kaptContext = new KaptContext(options, false, logger);
        KaptLogger $receiver$iv = logger;
        if ($receiver$iv.isVerbose()) {
            KaptLogger kaptLogger = $receiver$iv;
            String string = KaptOptionsKt.logString(options, "stand-alone mode");
            kaptLogger.info(string);
        }
        List<File> javaSourceFiles = KaptOptionsKt.collectJavaSourceFiles(options);
        ProcessorLoader processorLoader = new ProcessorLoader(options, logger);
        Closeable closeable = processorLoader;
        Throwable throwable = null;
        try {
            ProcessorLoader it = (ProcessorLoader)closeable;
            LoadedProcessors processors = processorLoader.loadProcessors(INSTANCE.findClassLoaderWithJavac());
            long start$iv = System.currentTimeMillis();
            AnnotationProcessingKt.doAnnotationProcessing$default(kaptContext, javaSourceFiles, processors.getProcessors(), null, 4, null);
            long annotationProcessingTime = System.currentTimeMillis() - start$iv;
            KaptLogger $receiver$iv2 = logger;
            if ($receiver$iv2.isVerbose()) {
                KaptLogger kaptLogger = $receiver$iv2;
                String string = "Annotation processing took " + annotationProcessingTime + " ms";
                kaptLogger.info(string);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    public final boolean checkJavacComponentsAccess(@NotNull KaptLogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        try {
            Class.forName(JAVAC_CONTEXT_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.error("'com.sun.tools.javac.util.Context' class can't be found ('tools.jar' is absent in the plugin classpath). Kapt won't work.");
            return false;
        }
    }

    private final ClassLoader findClassLoaderWithJavac() {
        ClassLoader kaptClassLoader;
        findClassLoaderWithJavac.1 toClassFilePath$ = findClassLoaderWithJavac.1.INSTANCE;
        String javacContextPath = toClassFilePath$.invoke(Context.class);
        String kaptPath = toClassFilePath$.invoke(Kapt.class);
        Function1<ClassLoader, ClassLoader> findRightClassLoader$ = new Function1<ClassLoader, ClassLoader>(javacContextPath, kaptPath){
            final /* synthetic */ String $javacContextPath;
            final /* synthetic */ String $kaptPath;

            @Nullable
            public final ClassLoader invoke(@NotNull ClassLoader current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if (current.getResource(this.$javacContextPath) != null && current.getResource(this.$kaptPath) == null) {
                    return current;
                }
                ClassLoader classLoader = current.getParent();
                if (classLoader == null) {
                    return null;
                }
                ClassLoader parent = classLoader;
                return this.invoke(parent);
            }
            {
                this.$javacContextPath = string;
                this.$kaptPath = string2;
                super(1);
            }
        };
        ClassLoader classLoader = kaptClassLoader = Kapt.class.getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"kaptClassLoader");
        ClassLoader classLoader2 = findRightClassLoader$.invoke(classLoader);
        if (classLoader2 == null) {
            classLoader2 = kaptClassLoader;
        }
        return classLoader2;
    }

    private Kapt() {
    }

    static {
        Kapt kapt;
        INSTANCE = kapt = new Kapt();
    }
}

