/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.modules;

import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.SmartList;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.modules.DelegatedSaxHandler;
import org.jetbrains.kotlin.cli.common.modules.ModuleBuilder;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleXmlParser {
    public static final String MODULES = "modules";
    public static final String MODULE = "module";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String TYPE_PRODUCTION = "java-production";
    public static final String TYPE_TEST = "java-test";
    public static final String OUTPUT_DIR = "outputDir";
    public static final String FRIEND_DIR = "friendDir";
    public static final String SOURCES = "sources";
    public static final String COMMON_SOURCES = "commonSources";
    public static final String JAVA_SOURCE_ROOTS = "javaSourceRoots";
    public static final String JAVA_SOURCE_PACKAGE_PREFIX = "packagePrefix";
    public static final String PATH = "path";
    public static final String CLASSPATH = "classpath";
    public static final String MODULAR_JDK_ROOT = "modularJdkRoot";
    private final MessageCollector messageCollector;
    private final List<Module> modules = new SmartList<Module>();
    private DefaultHandler currentState;
    private final DefaultHandler initial = new DefaultHandler(){

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            if (!ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                throw ModuleXmlParser.createError(qName);
            }
            ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
        }
    };
    private final DefaultHandler insideModules = new DefaultHandler(){

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            if (!ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                throw ModuleXmlParser.createError(qName);
            }
            String moduleType = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.TYPE, qName);
            assert (ModuleXmlParser.TYPE_PRODUCTION.equals(moduleType) || ModuleXmlParser.TYPE_TEST.equals(moduleType)) : "Unknown module type: " + moduleType;
            ModuleXmlParser.this.setCurrentState(new InsideModule(ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.NAME, qName), ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.OUTPUT_DIR, qName), moduleType));
        }

        @Override
        public void endElement(String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName) || ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ModuleChunk parseModuleScript(@NotNull String xmlFile, @NotNull MessageCollector messageCollector2) {
        ModuleChunk moduleChunk;
        FileInputStream stream2 = null;
        try {
            stream2 = new FileInputStream(xmlFile);
            moduleChunk = new ModuleXmlParser(messageCollector2).parse(new BufferedInputStream(stream2));
        }
        catch (FileNotFoundException e) {
            ModuleChunk moduleChunk2;
            try {
                MessageCollectorUtil.reportException(messageCollector2, e);
                moduleChunk2 = ModuleChunk.EMPTY;
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(stream2);
                throw throwable;
            }
            StreamUtil.closeStream(stream2);
            return moduleChunk2;
        }
        StreamUtil.closeStream(stream2);
        return moduleChunk;
    }

    private ModuleXmlParser(@NotNull MessageCollector messageCollector2) {
        this.messageCollector = messageCollector2;
    }

    private void setCurrentState(@NotNull DefaultHandler currentState) {
        this.currentState = currentState;
    }

    private ModuleChunk parse(@NotNull InputStream xml) {
        try {
            this.setCurrentState(this.initial);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(xml, (DefaultHandler)new DelegatedSaxHandler(){

                @Override
                @NotNull
                protected DefaultHandler getDelegate() {
                    return ModuleXmlParser.this.currentState;
                }
            });
            return new ModuleChunk(this.modules);
        }
        catch (IOException | ParserConfigurationException e) {
            MessageCollectorUtil.reportException(this.messageCollector, e);
        }
        catch (SAXException e) {
            this.messageCollector.report(CompilerMessageSeverity.ERROR, "Build file does not have a valid XML: " + e, null);
        }
        return ModuleChunk.EMPTY;
    }

    @NotNull
    private static String getAttribute(Attributes attributes, String qName, String tag) throws SAXException {
        String name = attributes.getValue(qName);
        if (name == null) {
            throw new SAXException("No '" + qName + "' attribute for " + tag);
        }
        return name;
    }

    @Nullable
    private static String getNullableAttribute(Attributes attributes, String qName) throws SAXException {
        return attributes.getValue(qName);
    }

    private static SAXException createError(String qName) throws SAXException {
        return new SAXException("Unexpected tag: " + qName);
    }

    private class InsideModule
    extends DefaultHandler {
        private final ModuleBuilder moduleBuilder;

        private InsideModule(String name, String outputDir2, @NotNull String type2) {
            this.moduleBuilder = new ModuleBuilder(name, outputDir2, type2);
            ModuleXmlParser.this.modules.add(this.moduleBuilder);
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            if (ModuleXmlParser.SOURCES.equalsIgnoreCase(qName)) {
                String path2 = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addSourceFiles(path2);
            } else if (ModuleXmlParser.COMMON_SOURCES.equalsIgnoreCase(qName)) {
                String path3 = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addCommonSourceFiles(path3);
            } else if (ModuleXmlParser.FRIEND_DIR.equalsIgnoreCase(qName)) {
                String path4 = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addFriendDir(path4);
            } else if (ModuleXmlParser.CLASSPATH.equalsIgnoreCase(qName)) {
                String path5 = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addClasspathEntry(path5);
            } else if (ModuleXmlParser.JAVA_SOURCE_ROOTS.equalsIgnoreCase(qName)) {
                String path6 = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                String packagePrefix = ModuleXmlParser.getNullableAttribute(attributes, ModuleXmlParser.JAVA_SOURCE_PACKAGE_PREFIX);
                this.moduleBuilder.addJavaSourceRoot(new JavaRootPath(path6, packagePrefix));
            } else if (ModuleXmlParser.MODULAR_JDK_ROOT.equalsIgnoreCase(qName)) {
                String path7 = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.setModularJdkRoot(path7);
            } else {
                throw ModuleXmlParser.createError(qName);
            }
        }

        @Override
        public void endElement(String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }
        }
    }
}

