/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.KotlinLightClassBuilderFactory;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderResult;
import org.jetbrains.kotlin.asJava.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.builder.StubComputationTracker;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aj\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2<\u0010\r\u001a8\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00130\u000e\u001a&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a$\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "buildLightClass", "Lorg/jetbrains/kotlin/asJava/builder/LightClassBuilderResult;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "generateClassFilter", "Lorg/jetbrains/kotlin/codegen/state/GenerationState$GenerateClassFilter;", "context", "Lorg/jetbrains/kotlin/asJava/builder/LightClassConstructionContext;", "generate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "Lkotlin/ParameterName;", "name", "state", "", "createJavaFileStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "project", "Lcom/intellij/openapi/project/Project;", "logErrorWithOSInfo", "cause", "", "fqName", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "light-classes"})
public final class LightClassBuilderKt {
    private static final Logger LOG;

    @NotNull
    public static final LightClassBuilderResult buildLightClass(@NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> files2, @NotNull GenerationState.GenerateClassFilter generateClassFilter, @NotNull LightClassConstructionContext context, @NotNull Function2<? super GenerationState, ? super Collection<? extends KtFile>, Unit> generate2) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(generateClassFilter, "generateClassFilter");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(generate2, "generate");
        Project project = ((KtFile)CollectionsKt.first((Iterable)files2)).getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "files.first().project");
        Project project2 = project;
        try {
            CompilerConfiguration compilerConfiguration;
            KotlinLightClassBuilderFactory classBuilderFactory = new KotlinLightClassBuilderFactory(LightClassBuilderKt.createJavaFileStub(project2, packageFqName, files2));
            Project project3 = project2;
            ClassBuilderFactory classBuilderFactory2 = classBuilderFactory;
            ModuleDescriptor moduleDescriptor = context.getModule();
            BindingContext bindingContext = context.getBindingContext();
            List list2 = CollectionsKt.toList((Iterable)files2);
            LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
            if (languageVersionSettings != null) {
                CompilerConfiguration compilerConfiguration2;
                LanguageVersionSettings languageVersionSettings2 = languageVersionSettings;
                List list3 = list2;
                BindingContext bindingContext2 = bindingContext;
                ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                ClassBuilderFactory classBuilderFactory3 = classBuilderFactory2;
                Project project4 = project3;
                LanguageVersionSettings it = languageVersionSettings2;
                CompilerConfiguration $receiver = compilerConfiguration2 = new CompilerConfiguration();
                CommonConfigurationKeysKt.setLanguageVersionSettings($receiver, it);
                $receiver.setReadOnly(true);
                CompilerConfiguration compilerConfiguration3 = compilerConfiguration2;
                project3 = project4;
                classBuilderFactory2 = classBuilderFactory3;
                moduleDescriptor = moduleDescriptor2;
                bindingContext = bindingContext2;
                list2 = list3;
                compilerConfiguration = compilerConfiguration3;
            } else {
                CompilerConfiguration compilerConfiguration4 = CompilerConfiguration.EMPTY;
                compilerConfiguration = compilerConfiguration4;
                Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration4, "CompilerConfiguration.EMPTY");
            }
            CompilerConfiguration compilerConfiguration5 = compilerConfiguration;
            List list4 = list2;
            BindingContext bindingContext3 = bindingContext;
            ModuleDescriptor moduleDescriptor3 = moduleDescriptor;
            ClassBuilderFactory classBuilderFactory4 = classBuilderFactory2;
            Project project5 = project3;
            GenerationState state2 = new GenerationState.Builder(project5, classBuilderFactory4, moduleDescriptor3, bindingContext3, list4, compilerConfiguration5).generateDeclaredClassFilter(generateClassFilter).wantsDiagnostics(false).build();
            state2.beforeCompile();
            generate2.invoke(state2, files2);
            PsiJavaFileStub javaFileStub = classBuilderFactory.result();
            StubComputationTracker stubComputationTracker = ServiceManager.getService(project2, StubComputationTracker.class);
            if (stubComputationTracker != null) {
                stubComputationTracker.onStubComputed(javaFileStub, context);
            }
            return new LightClassBuilderResult(javaFileStub, context.getBindingContext(), state2.getCollectedExtraJvmDiagnostics());
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (RuntimeException e) {
            LightClassBuilderKt.logErrorWithOSInfo(e, packageFqName, null);
            throw (Throwable)e;
        }
    }

    private static final PsiJavaFileStub createJavaFileStub(Project project, FqName packageFqName, Collection<? extends KtFile> files2) {
        PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(packageFqName.asString(), true);
        javaFileStub.setPsiFactory(ClsWrapperStubPsiFactory.INSTANCE);
        ClsFileImpl fakeFile2 = new ClsFileImpl(javaFileStub, packageFqName, files2, ((KtFile)CollectionsKt.first((Iterable)files2)).getViewProvider()){
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ FqName $packageFqName;
            final /* synthetic */ Collection $files;

            @NotNull
            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            @NotNull
            public String getPackageName() {
                String string = this.$packageFqName.asString();
                Intrinsics.checkExpressionValueIsNotNull(string, "packageFqName.asString()");
                return string;
            }

            public boolean isPhysical() {
                return false;
            }

            public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
                Intrinsics.checkParameterIsNotNull(buffer, "buffer");
                if (this.$files.size() == 1) {
                    LightClassBuilderKt.access$getLOG$p().error("Mirror text should never be calculated for light classes generated from a single file");
                }
                super.appendMirrorText(indentLevel, buffer);
            }

            public void setMirror(@NotNull TreeElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (this.$files.size() == 1) {
                    LightClassBuilderKt.access$getLOG$p().error("Mirror element should never be set for light classes generated from a single file");
                }
                super.setMirror(element);
            }

            @NotNull
            public PsiElement getMirror() {
                if (this.$files.size() == 1) {
                    LightClassBuilderKt.access$getLOG$p().error("Mirror element should never be calculated for light classes generated from a single file");
                }
                PsiElement psiElement = super.getMirror();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "super.getMirror()");
                return psiElement;
            }

            @NotNull
            public String getText() {
                Object object = (KtFile)CollectionsKt.singleOrNull(this.$files);
                if (object == null || (object = ((PsiFileImpl)object).getText()) == null) {
                    String string = super.getText();
                    object = string;
                    Intrinsics.checkExpressionValueIsNotNull(string, "super.getText()");
                }
                return object;
            }
            {
                this.$javaFileStub = $captured_local_variable$0;
                this.$packageFqName = $captured_local_variable$1;
                this.$files = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        return javaFileStub;
    }

    private static final void logErrorWithOSInfo(Throwable cause, FqName fqName2, VirtualFile virtualFile2) {
        String string;
        if (virtualFile2 == null) {
            string = "<null>";
        } else {
            String string2 = virtualFile2.getPath();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "virtualFile.path");
        }
        String path2 = string;
        LOG.error("Could not generate LightClass for " + fqName2 + " declared in " + path2 + '\n' + "System: " + SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION + " Java Runtime: " + SystemInfo.JAVA_RUNTIME_VERSION, cause);
    }

    static {
        Logger logger = Logger.getInstance(LightClassBuilderResult.class);
        Intrinsics.checkExpressionValueIsNotNull(logger, "Logger.getInstance(Light\u2026uilderResult::class.java)");
        LOG = logger;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

